/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.BatchedBucketsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedInfluencersIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedRecordsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.ml.job.persistence.InfluencersQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.RecordsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.security.support.Exceptions;

public class JobProvider {
    private static final Logger LOGGER = Loggers.getLogger(JobProvider.class);
    private static final List<String> SECONDARY_SORT = Arrays.asList(AnomalyRecord.RECORD_SCORE.getPreferredName(), AnomalyRecord.OVER_FIELD_VALUE.getPreferredName(), AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), AnomalyRecord.BY_FIELD_VALUE.getPreferredName(), AnomalyRecord.FIELD_NAME.getPreferredName(), AnomalyRecord.FUNCTION.getPreferredName());
    private static final int RECORDS_SIZE_PARAM = 10000;
    private final Client client;
    private final Settings settings;

    public JobProvider(Client client, Settings settings) {
        this.client = Objects.requireNonNull(client);
        this.settings = settings;
    }

    public void checkForLeftOverDocuments(final Job job, final ActionListener<Boolean> listener) {
        String resultsIndexName = job.getResultsIndexName();
        SearchRequestBuilder stateDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexName()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{CategorizerState.documentId(job.getId(), 1), CategorizerState.v54DocumentId(job.getId(), 1)})).setIndicesOptions(IndicesOptions.lenientExpandOpen());
        SearchRequestBuilder quantilesDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexName()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{Quantiles.documentId(job.getId()), Quantiles.v54DocumentId(job.getId())})).setIndicesOptions(IndicesOptions.lenientExpandOpen());
        SearchRequestBuilder resultDocSearch = this.client.prepareSearch(new String[]{resultsIndexName}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).setSize(1);
        ActionListener<MultiSearchResponse> searchResponseActionListener = new ActionListener<MultiSearchResponse>(){

            public void onResponse(MultiSearchResponse searchResponse) {
                for (MultiSearchResponse.Item itemResponse : searchResponse.getResponses()) {
                    if (itemResponse.getResponse().getHits().getTotalHits() <= 0L) continue;
                    listener.onFailure((Exception)ExceptionsHelper.conflictStatusException("Result and/or state documents exist for a prior job with Id [" + job.getId() + "]. Please create the job with a different Id", new Object[0]));
                    return;
                }
                listener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        this.client.prepareMultiSearch().add(stateDocSearch).add(resultDocSearch).add(quantilesDocSearch).execute((ActionListener)searchResponseActionListener);
    }

    public void createJobResultIndex(Job job, ClusterState state, ActionListener<Boolean> finalListener) {
        List<String> termFields = job.getAnalysisConfig() != null ? job.getAnalysisConfig().termFields() : Collections.emptyList();
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName(job.getId());
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias(job.getId());
        String indexName = job.getResultsIndexName();
        ActionListener createAliasListener = ActionListener.wrap(success -> this.client.admin().indices().prepareAliases().addAlias(indexName, readAliasName, (QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).addAlias(indexName, writeAliasName).execute(ActionListener.wrap(r -> finalListener.onResponse((Object)true), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        if (!state.getMetaData().hasIndex(indexName)) {
            LOGGER.trace("ES API CALL: create index {}", (Object)indexName);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            try (XContentBuilder termFieldsMapping = ElasticsearchMappings.termFieldsMapping("doc", termFields);){
                createIndexRequest.mapping("doc", termFieldsMapping);
            }
            this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)r.isAcknowledged()), e -> {
                if (e instanceof ResourceAlreadyExistsException) {
                    LOGGER.info("Index already exists");
                    createAliasListener.onResponse((Object)true);
                } else {
                    finalListener.onFailure(e);
                }
            }));
        } else {
            long fieldCountLimit = (Long)MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.get(this.settings);
            if (JobProvider.violatedFieldCountLimit(indexName, termFields.size(), fieldCountLimit, state)) {
                String message = "Cannot create job in index '" + indexName + "' as the " + MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey() + " setting will be violated";
                finalListener.onFailure((Exception)new IllegalArgumentException(message));
            } else {
                this.updateIndexMappingWithTermFields(indexName, termFields, (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> ((ActionListener)createAliasListener).onResponse(arg_0), arg_0 -> finalListener.onFailure(arg_0)));
            }
        }
    }

    static boolean violatedFieldCountLimit(String indexName, long additionalFieldCount, long fieldCountLimit, ClusterState clusterState) {
        long numFields = 0L;
        IndexMetaData indexMetaData = clusterState.metaData().index(indexName);
        Iterator mappings = indexMetaData.getMappings().valuesIt();
        while (mappings.hasNext()) {
            MappingMetaData mapping = (MappingMetaData)mappings.next();
            try {
                numFields += (long)JobProvider.countFields(mapping.sourceAsMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return numFields + additionalFieldCount > fieldCountLimit;
    }

    static int countFields(Map<String, Object> mapping) {
        Object propertiesNode = mapping.get("properties");
        if (propertiesNode == null || !(propertiesNode instanceof Map)) {
            return 0;
        }
        mapping = (Map)propertiesNode;
        int count = 0;
        for (Map.Entry entry : mapping.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map fieldMapping = (Map)entry.getValue();
                count += JobProvider.countFields(fieldMapping);
            }
            ++count;
        }
        return count;
    }

    private void updateIndexMappingWithTermFields(String indexName, Collection<String> termFields, final ActionListener<Boolean> listener) {
        try (XContentBuilder termFieldsMapping = ElasticsearchMappings.termFieldsMapping(null, termFields);){
            this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType("doc").setSource(termFieldsMapping).execute((ActionListener)new ActionListener<PutMappingResponse>(){

                public void onResponse(PutMappingResponse putMappingResponse) {
                    listener.onResponse((Object)putMappingResponse.isAcknowledged());
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public void dataCounts(String jobId, Consumer<DataCounts> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        this.searchSingleResult(jobId, DataCounts.TYPE.getPreferredName(), this.createLatestDataCountsSearch(indexName, jobId), (BiFunction)DataCounts.PARSER, result -> handler.accept((DataCounts)((Object)result.result)), errorHandler, () -> new DataCounts(jobId));
    }

    private SearchRequestBuilder createLatestDataCountsSearch(String indexName, String jobId) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DataCounts.documentId(jobId), DataCounts.v54DocumentId(jobId)})).addSort(SortBuilders.fieldSort((String)DataCounts.LATEST_RECORD_TIME.getPreferredName()).order(SortOrder.DESC));
    }

    public void getAutodetectParams(Job job, Consumer<AutodetectParams> consumer, Consumer<Exception> errorHandler) {
        AutodetectParams.Builder paramsBuilder = new AutodetectParams.Builder(job.getId());
        String jobId = job.getId();
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        String stateIndex = AnomalyDetectorsIndex.jobStateIndexName();
        MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(this.createLatestDataCountsSearch(resultsIndex, jobId)).add(this.createLatestModelSizeStatsSearch(resultsIndex)).add(this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId(jobId, job.getModelSnapshotId()))).add(this.createDocIdSearch(stateIndex, Quantiles.documentId(jobId)));
        for (String filterId : job.getAnalysisConfig().extractReferencedFilters()) {
            msearch.add(this.createDocIdSearch(".ml-meta", filterId));
        }
        msearch.execute(ActionListener.wrap(response -> {
            for (int i = 0; i < response.getResponses().length; ++i) {
                MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                if (itemResponse.isFailure()) {
                    errorHandler.accept(itemResponse.getFailure());
                    continue;
                }
                SearchResponse searchResponse = itemResponse.getResponse();
                Object[] shardFailures = searchResponse.getShardFailures();
                int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
                if (shardFailures != null && shardFailures.length > 0) {
                    LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
                    errorHandler.accept((Exception)new ElasticsearchException(ExceptionsHelper.shardFailuresToErrorMsg(jobId, (ShardSearchFailure[])shardFailures), new Object[0]));
                    continue;
                }
                if (unavailableShards > 0) {
                    errorHandler.accept((Exception)new ElasticsearchException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards", new Object[0]));
                    continue;
                }
                SearchHits hits = searchResponse.getHits();
                long hitsCount = hits.getHits().length;
                if (hitsCount == 0L) {
                    SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                    LOGGER.debug("Found 0 hits for [{}/{}]", (Object)searchRequest.indices(), (Object)searchRequest.types());
                    continue;
                }
                if (hitsCount == 1L) {
                    this.parseAutodetectParamSearchHit(jobId, paramsBuilder, hits.getAt(0), errorHandler);
                    continue;
                }
                if (hitsCount <= 1L) continue;
                errorHandler.accept(new IllegalStateException("Expected hits count to be 0 or 1, but got [" + hitsCount + "]"));
            }
            consumer.accept(paramsBuilder.build());
        }, errorHandler));
    }

    private SearchRequestBuilder createDocIdSearch(String index, String id) {
        return this.client.prepareSearch(new String[]{index}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{id})).setRouting(id);
    }

    private void parseAutodetectParamSearchHit(String jobId, AutodetectParams.Builder paramsBuilder, SearchHit hit, Consumer<Exception> errorHandler) {
        String hitId = hit.getId();
        if (DataCounts.documentId(jobId).equals(hitId)) {
            paramsBuilder.setDataCounts((DataCounts)((Object)this.parseSearchHit(hit, (BiFunction)DataCounts.PARSER, errorHandler)));
        } else if (hitId.startsWith(ModelSizeStats.documentIdPrefix(jobId))) {
            ModelSizeStats.Builder modelSizeStats = (ModelSizeStats.Builder)this.parseSearchHit(hit, (BiFunction)ModelSizeStats.PARSER, errorHandler);
            paramsBuilder.setModelSizeStats(modelSizeStats == null ? null : modelSizeStats.build());
        } else if (hitId.startsWith(ModelSnapshot.documentIdPrefix(jobId))) {
            ModelSnapshot.Builder modelSnapshot = (ModelSnapshot.Builder)this.parseSearchHit(hit, (BiFunction)ModelSnapshot.PARSER, errorHandler);
            paramsBuilder.setModelSnapshot(modelSnapshot == null ? null : modelSnapshot.build());
        } else if (Quantiles.documentId(jobId).equals(hit.getId())) {
            paramsBuilder.setQuantiles((Quantiles)((Object)this.parseSearchHit(hit, (BiFunction)Quantiles.PARSER, errorHandler)));
        } else if (hitId.startsWith("filter_")) {
            paramsBuilder.addFilter(((MlFilter.Builder)this.parseSearchHit(hit, (BiFunction)MlFilter.PARSER, errorHandler)).build());
        } else {
            errorHandler.accept(new IllegalStateException("Unexpected type [" + hit.getType() + "]"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, U> T parseSearchHit(SearchHit hit, BiFunction<XContentParser, U, T> objectParser, Consumer<Exception> errorHandler) {
        BytesReference source = hit.getSourceRef();
        try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
            XContentParser t = objectParser.apply(parser, null);
            return (T)t;
        }
        catch (IOException e) {
            errorHandler.accept((Exception)((Object)new ElasticsearchParseException("failed to parse " + hit.getType(), (Throwable)e, new Object[0])));
            return null;
        }
    }

    public static IndicesOptions addIgnoreUnavailable(IndicesOptions indicesOptions) {
        return IndicesOptions.fromOptions((boolean)true, (boolean)indicesOptions.allowNoIndices(), (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed(), (IndicesOptions)indicesOptions);
    }

    public void bucketsViaInternalClient(String jobId, BucketsQueryBuilder.BucketsQuery query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler) {
        this.buckets(jobId, query, handler, errorHandler, this.client);
    }

    public void buckets(String jobId, BucketsQueryBuilder.BucketsQuery query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) throws ResourceNotFoundException {
        ResultsFilterBuilder rfb = new ResultsFilterBuilder();
        if (query.getTimestamp() != null) {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), query.getTimestamp());
        } else {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Bucket.ANOMALY_SCORE.getPreferredName(), query.getAnomalyScoreFilter()).interim(query.isIncludeInterim());
        }
        SortBuilder sortBuilder = new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        BoolQueryBuilder boolQuery = new BoolQueryBuilder().filter(rfb.build()).filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"bucket"));
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.from(query.getFrom());
        searchSourceBuilder.size(query.getSize());
        if (!Result.TIMESTAMP.getPreferredName().equals(query.getSortField())) {
            searchSourceBuilder.sort(Result.TIMESTAMP.getPreferredName(), query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        }
        searchRequest.source(searchSourceBuilder);
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            SearchHits hits = searchResponse.getHits();
            if (query.getTimestamp() != null) {
                if (hits.getTotalHits() == 0L) {
                    throw QueryPage.emptyQueryPage(Bucket.RESULTS_FIELD);
                }
                if (hits.getTotalHits() > 1L) {
                    LOGGER.error("Found more than one bucket with timestamp [{}] from index {}", (Object)query.getTimestamp(), (Object)indexName);
                }
            }
            ArrayList<Bucket> results = new ArrayList<Bucket>();
            for (SearchHit hit : hits.getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    Bucket bucket2 = (Bucket)((Object)((Object)Bucket.PARSER.apply(parser, null)));
                    if (!query.isIncludeInterim() && bucket2.isInterim()) continue;
                    results.add(bucket2);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
                }
            }
            if (query.getTimestamp() != null && results.isEmpty()) {
                throw QueryPage.emptyQueryPage(Bucket.RESULTS_FIELD);
            }
            QueryPage<Bucket> buckets = new QueryPage<Bucket>(results, searchResponse.getHits().getTotalHits(), Bucket.RESULTS_FIELD);
            if (query.isExpand()) {
                Iterator<Bucket> bucketsToExpand = buckets.results().stream().filter(bucket -> bucket.getBucketInfluencers().size() > 0).iterator();
                this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
            } else {
                handler.accept(buckets);
            }
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/buckets/get"))));
    }

    private void expandBuckets(String jobId, BucketsQueryBuilder.BucketsQuery query, QueryPage<Bucket> buckets, Iterator<Bucket> bucketsToExpand, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) {
        if (bucketsToExpand.hasNext()) {
            Consumer<Integer> c = i -> this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
            this.expandBucket(jobId, query.isIncludeInterim(), bucketsToExpand.next(), query.getPartitionValue(), c, errorHandler, client);
        } else {
            handler.accept(buckets);
        }
    }

    public BatchedResultsIterator<Bucket> newBatchedBucketsIterator(String jobId) {
        return new BatchedBucketsIterator(this.client, jobId);
    }

    public BatchedResultsIterator<AnomalyRecord> newBatchedRecordsIterator(String jobId) {
        return new BatchedRecordsIterator(this.client, jobId);
    }

    public void expandBucket(String jobId, boolean includeInterim, Bucket bucket, String partitionFieldValue, Consumer<Integer> consumer, Consumer<Exception> errorHandler, Client client) {
        Consumer<QueryPage<AnomalyRecord>> h = page -> {
            bucket.getRecords().addAll(page.results());
            if (partitionFieldValue != null) {
                bucket.setAnomalyScore(bucket.partitionAnomalyScore(partitionFieldValue));
            }
            consumer.accept(bucket.getRecords().size());
        };
        this.bucketRecords(jobId, bucket, 0, 10000, includeInterim, AnomalyRecord.PROBABILITY.getPreferredName(), false, partitionFieldValue, h, errorHandler, client);
    }

    void bucketRecords(String jobId, Bucket bucket, int from, int size, boolean includeInterim, String sortField, boolean descending, String partitionFieldValue, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        TermQueryBuilder recordFilter = QueryBuilders.termQuery((String)Result.TIMESTAMP.getPreferredName(), (long)bucket.getTimestamp().getTime());
        ResultsFilterBuilder builder = new ResultsFilterBuilder((QueryBuilder)recordFilter).interim(includeInterim);
        if (partitionFieldValue != null) {
            builder.term(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), partitionFieldValue);
        }
        recordFilter = builder.build();
        FieldSortBuilder sb = null;
        if (sortField != null) {
            sb = (FieldSortBuilder)new FieldSortBuilder(sortField).missing((Object)"_last").order(descending ? SortOrder.DESC : SortOrder.ASC);
        }
        this.records(jobId, from, size, (QueryBuilder)recordFilter, sb, SECONDARY_SORT, descending, handler, errorHandler, client);
    }

    public void categoryDefinitions(String jobId, Long categoryId, Integer from, Integer size, Consumer<QueryPage<CategoryDefinition>> handler, Consumer<Exception> errorHandler, Client client) {
        if (categoryId != null && (from != null || size != null)) {
            throw new IllegalStateException("Both categoryId and pageParams are specified");
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search all of category definitions from index {} sort ascending {} from {} size {}", (Object)indexName, (Object)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (categoryId != null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)categoryId));
        } else if (from != null && size != null) {
            sourceBuilder.from(from.intValue()).size(size.intValue()).query((QueryBuilder)QueryBuilders.existsQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName())).sort(new FieldSortBuilder(CategoryDefinition.CATEGORY_ID.getPreferredName()).order(SortOrder.ASC));
        } else {
            throw new IllegalStateException("Both categoryId and pageParams are not specified");
        }
        searchRequest.source(sourceBuilder);
        client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            SearchHit[] hits = searchResponse.getHits().getHits();
            ArrayList<CategoryDefinition> results = new ArrayList<CategoryDefinition>(hits.length);
            for (SearchHit hit : hits) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    CategoryDefinition categoryDefinition = (CategoryDefinition)((Object)((Object)CategoryDefinition.PARSER.apply(parser, null)));
                    results.add(categoryDefinition);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse category definition", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits(), CategoryDefinition.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/categories/get"))));
    }

    public void records(String jobId, RecordsQueryBuilder.RecordsQuery query, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(AnomalyRecord.RECORD_SCORE.getPreferredName(), query.getRecordScoreThreshold()).interim(query.isIncludeInterim()).term(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), query.getPartitionFieldValue()).build();
        FieldSortBuilder sb = null;
        if (query.getSortField() != null) {
            sb = (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).missing((Object)"_last").order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        }
        this.records(jobId, query.getFrom(), query.getSize(), fb, sb, SECONDARY_SORT, query.isSortDescending(), handler, errorHandler, client);
    }

    private void records(String jobId, int from, int size, QueryBuilder recordFilter, FieldSortBuilder sb, List<String> secondarySort, boolean descending, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        recordFilter = new BoolQueryBuilder().filter(recordFilter).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"record"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.source(new SearchSourceBuilder().from(from).size(size).query(recordFilter).sort((SortBuilder)(sb == null ? SortBuilders.fieldSort((String)"_doc") : sb)).fetchSource(true));
        for (String sortField : secondarySort) {
            searchRequest.source().sort(sortField, descending ? SortOrder.DESC : SortOrder.ASC);
        }
        LOGGER.trace("ES API CALL: search all of records from index {}{}{} with filter after sort from {} size {}", (Object)indexName, (Object)(sb != null ? " with sort" : ""), (Object)(secondarySort.isEmpty() ? "" : " with secondary sort"), (Object)from, (Object)size);
        client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            ArrayList<Object> results = new ArrayList<Object>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    results.add(AnomalyRecord.PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse records", (Throwable)e, new Object[0]);
                }
            }
            QueryPage queryPage = new QueryPage(results, searchResponse.getHits().getTotalHits(), AnomalyRecord.RESULTS_FIELD);
            handler.accept(queryPage);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/records/get"))));
    }

    public void influencers(String jobId, InfluencersQueryBuilder.InfluencersQuery query, Consumer<QueryPage<Influencer>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Influencer.INFLUENCER_SCORE.getPreferredName(), query.getInfluencerScoreFilter()).interim(query.isIncludeInterim()).build();
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[4];
        supplierArray[0] = () -> indexName;
        supplierArray[1] = () -> query.getSortField() != null ? " with sort " + (query.isSortDescending() ? "descending" : "ascending") + " on field " + query.getSortField() : "";
        supplierArray[2] = query::getFrom;
        supplierArray[3] = query::getSize;
        LOGGER.trace("ES API CALL: search all of influencers from index {}{}  with filter from {} size {}", supplierArray);
        BoolQueryBuilder qb = new BoolQueryBuilder().filter(fb).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"influencer"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        FieldSortBuilder sb = query.getSortField() == null ? SortBuilders.fieldSort((String)"_doc") : (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)qb).from(query.getFrom()).size(query.getSize()).sort((SortBuilder)sb));
        client.search(searchRequest, ActionListener.wrap(response -> {
            ArrayList<Object> influencers = new ArrayList<Object>();
            for (SearchHit hit : response.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    influencers.add(Influencer.PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse influencer", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(influencers, response.getHits().getTotalHits(), Influencer.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/influencers/get"))));
    }

    public BatchedResultsIterator<Influencer> newBatchedInfluencersIterator(String jobId) {
        return new BatchedInfluencersIterator(this.client, jobId);
    }

    public void getModelSnapshot(String jobId, @Nullable String modelSnapshotId, Consumer<Result<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (modelSnapshotId == null) {
            handler.accept(null);
            return;
        }
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        SearchRequestBuilder search = this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId(jobId, modelSnapshotId));
        this.searchSingleResult(jobId, ModelSnapshot.TYPE.getPreferredName(), search, (BiFunction)ModelSnapshot.PARSER, result -> handler.accept(result.result == null ? null : new Result<ModelSnapshot>(result.index, ((ModelSnapshot.Builder)result.result).build())), errorHandler, () -> null);
    }

    public void modelSnapshots(String jobId, int from, int size, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        this.modelSnapshots(jobId, from, size, null, true, (QueryBuilder)QueryBuilders.matchAllQuery(), handler, errorHandler);
    }

    public void modelSnapshots(String jobId, int from, int size, String startEpochMs, String endEpochMs, String sortField, boolean sortDescending, String snapshotId, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        ResultsFilterBuilder fb = new ResultsFilterBuilder();
        if (snapshotId != null && !snapshotId.isEmpty()) {
            fb.term(ModelSnapshot.SNAPSHOT_ID.getPreferredName(), snapshotId);
        }
        QueryBuilder qb = fb.timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs).build();
        this.modelSnapshots(jobId, from, size, sortField, sortDescending, qb, handler, errorHandler);
    }

    private void modelSnapshots(String jobId, int from, int size, String sortField, boolean sortDescending, QueryBuilder qb, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (Strings.isEmpty((CharSequence)sortField)) {
            sortField = ModelSnapshot.TIMESTAMP.getPreferredName();
        }
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).must(qb);
        FieldSortBuilder sb = (FieldSortBuilder)new FieldSortBuilder(sortField).order(sortDescending ? SortOrder.DESC : SortOrder.ASC);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search all model snapshots from index {} sort ascending {} with filter after sort from {} size {}", (Object)indexName, (Object)sortField, (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.sort((SortBuilder)sb);
        sourceBuilder.query((QueryBuilder)finalQuery);
        sourceBuilder.from(from);
        sourceBuilder.size(size);
        searchRequest.source(sourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            ArrayList<ModelSnapshot> results = new ArrayList<ModelSnapshot>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                results.add(ModelSnapshot.fromJson(hit.getSourceRef()));
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits(), ModelSnapshot.RESULTS_FIELD);
            handler.accept(result);
        }, errorHandler));
    }

    public QueryPage<ModelPlot> modelPlot(String jobId, int from, int size) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search model plots from index {} from {} size {}", (Object)indexName, (Object)from, (Object)size);
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setIndicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).setQuery((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_plot"})).setFrom(from).setSize(size).get();
        ArrayList<ModelPlot> results = new ArrayList<ModelPlot>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            BytesReference source = hit.getSourceRef();
            try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                ModelPlot modelPlot = (ModelPlot)((Object)ModelPlot.PARSER.apply(parser, null));
                results.add(modelPlot);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse modelPlot", (Throwable)e, new Object[0]);
            }
        }
        return new QueryPage<ModelPlot>(results, searchResponse.getHits().getTotalHits(), ModelPlot.RESULTS_FIELD);
    }

    public void modelSizeStats(String jobId, Consumer<ModelSizeStats> handler, Consumer<Exception> errorHandler) {
        LOGGER.trace("ES API CALL: search latest {} for job {}", (Object)"model_size_stats", (Object)jobId);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        this.searchSingleResult(jobId, "model_size_stats", this.createLatestModelSizeStatsSearch(indexName), (BiFunction)ModelSizeStats.PARSER, result -> handler.accept(((ModelSizeStats.Builder)result.result).build()), errorHandler, () -> new ModelSizeStats.Builder(jobId));
    }

    private <U, T> void searchSingleResult(String jobId, String resultDescription, SearchRequestBuilder search, BiFunction<XContentParser, U, T> objectParser, Consumer<Result<T>> handler, Consumer<Exception> errorHandler, Supplier<T> notFoundSupplier) {
        search.execute(ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                LOGGER.trace("No {} for job with id {}", (Object)resultDescription, (Object)jobId);
                handler.accept(new Result(null, notFoundSupplier.get()));
            } else if (hits.length == 1) {
                handler.accept(new Result(hits[0].getIndex(), this.parseSearchHit(hits[0], objectParser, errorHandler)));
            } else {
                errorHandler.accept(new IllegalStateException("Search for unique [" + resultDescription + "] returned [" + hits.length + "] hits even though size was 1"));
            }
        }, errorHandler));
    }

    private SearchRequestBuilder createLatestModelSizeStatsSearch(String indexName) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats")).addSort(SortBuilders.fieldSort((String)ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).order(SortOrder.DESC));
    }

    static Exception mapAuthFailure(Exception e, String jobId, String mappedActionName) {
        if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).status() == RestStatus.FORBIDDEN) {
            e = Exceptions.authorizationError(e.getMessage().replaceFirst("action \\[.*?\\]", "action [" + mappedActionName + "]") + " for job [{}]", jobId);
        }
        return e;
    }
}

