/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.job.config.Detector;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influence;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.notifications.AuditMessage;

public class ElasticsearchMappings {
    public static final String DOC_TYPE = "doc";
    static final String ENABLED = "enabled";
    static final String ANALYZER = "analyzer";
    static final String WHITESPACE = "whitespace";
    static final String NESTED = "nested";
    static final String COPY_TO = "copy_to";
    static final String PROPERTIES = "properties";
    static final String TYPE = "type";
    static final String DYNAMIC = "dynamic";
    static final String FIELDS = "fields";
    public static final String ALL_FIELD_VALUES = "all_field_values";
    static final String ES_DOC = "_doc";
    static final String BOOLEAN = "boolean";
    static final String DATE = "date";
    static final String DOUBLE = "double";
    static final String INTEGER = "integer";
    static final String KEYWORD = "keyword";
    static final String LONG = "long";
    static final String TEXT = "text";
    static final String RAW = "raw";

    private ElasticsearchMappings() {
    }

    public static void addDefaultMapping(XContentBuilder builder) throws IOException {
        builder.startArray("dynamic_templates").startObject().startObject("strings_as_keywords").field("match", "*").startObject("mapping").field(TYPE, KEYWORD).endObject().endObject().endObject().endArray();
    }

    public static XContentBuilder docMapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject(DOC_TYPE);
        ElasticsearchMappings.addDefaultMapping(builder);
        builder.startObject(PROPERTIES);
        builder.startObject(ALL_FIELD_VALUES).field(TYPE, TEXT).field(ANALYZER, WHITESPACE).endObject();
        builder.startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject();
        builder.startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject();
        ElasticsearchMappings.addResultsMapping(builder);
        ElasticsearchMappings.addCategoryDefinitionMapping(builder);
        ElasticsearchMappings.addDataCountsMapping(builder);
        ElasticsearchMappings.addModelSnapshotMapping(builder);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static void addResultsMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Bucket.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Bucket.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Result.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(Bucket.RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.EVENT_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.PROCESSING_TIME_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(Bucket.PARTITION_SCORES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Bucket.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject().startObject(Bucket.BUCKET_INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(BucketInfluencer.INITIAL_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(BucketInfluencer.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Result.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(BucketInfluencer.BUCKET_SPAN.getPreferredName()).field(TYPE, LONG).endObject().startObject(Result.IS_INTERIM.getPreferredName()).field(TYPE, BOOLEAN).endObject().endObject().endObject().startObject(ModelPlot.MODEL_FEATURE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelPlot.MODEL_LOWER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_UPPER.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(ModelPlot.MODEL_MEDIAN.getPreferredName()).field(TYPE, DOUBLE).endObject();
        ElasticsearchMappings.addAnomalyRecordFieldsToMapping(builder);
        ElasticsearchMappings.addInfluencerFieldsToMapping(builder);
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
    }

    static XContentBuilder termFieldsMapping(String type, Collection<String> termFields) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            if (type != null) {
                builder.startObject(type);
            }
            builder.startObject(PROPERTIES);
            ElasticsearchMappings.addTermFields(builder, termFields);
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            return builder.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTermFields(XContentBuilder builder, Collection<String> termFields) throws IOException {
        for (String fieldName : termFields) {
            if (!ReservedFieldNames.isValidFieldName(fieldName)) continue;
            builder.startObject(fieldName).field(TYPE, KEYWORD).endObject();
        }
    }

    private static void addAnomalyRecordFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Detector.DETECTOR_INDEX.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(AnomalyRecord.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyRecord.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyRecord.RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.INITIAL_RECORD_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyRecord.CAUSES.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(AnomalyCause.ACTUAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.TYPICAL.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.PROBABILITY.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(AnomalyCause.FUNCTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.FUNCTION_DESCRIPTION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.CORRELATED_BY_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.PARTITION_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().startObject(AnomalyCause.OVER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AnomalyCause.OVER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject().startObject(AnomalyRecord.INFLUENCERS.getPreferredName()).field(TYPE, NESTED).startObject(PROPERTIES).startObject(Influence.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influence.INFLUENCER_FIELD_VALUES.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject().endObject().endObject();
    }

    private static void addInfluencerFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(Influencer.INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INITIAL_INFLUENCER_SCORE.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(Influencer.INFLUENCER_FIELD_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Influencer.INFLUENCER_FIELD_VALUE.getPreferredName()).field(TYPE, KEYWORD).field(COPY_TO, ALL_FIELD_VALUES).endObject();
    }

    private static void addDataCountsMapping(XContentBuilder builder) throws IOException {
        builder.startObject(DataCounts.PROCESSED_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.PROCESSED_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_BYTES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_RECORD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INPUT_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.INVALID_DATE_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.MISSING_FIELD_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.OUT_OF_ORDER_TIME_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EMPTY_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.SPARSE_BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.BUCKET_COUNT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataCounts.EARLIEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_EMPTY_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LATEST_SPARSE_BUCKET_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataCounts.LAST_DATA_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static void addCategoryDefinitionMapping(XContentBuilder builder) throws IOException {
        builder.startObject(CategoryDefinition.CATEGORY_ID.getPreferredName()).field(TYPE, LONG).endObject().startObject(CategoryDefinition.TERMS.getPreferredName()).field(TYPE, TEXT).endObject().startObject(CategoryDefinition.REGEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(CategoryDefinition.MAX_MATCHING_LENGTH.getPreferredName()).field(TYPE, LONG).endObject().startObject(CategoryDefinition.EXAMPLES.getPreferredName()).field(TYPE, TEXT).endObject();
    }

    public static XContentBuilder stateMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(DOC_TYPE).field(ENABLED, false).endObject().endObject();
    }

    private static void addModelSnapshotMapping(XContentBuilder builder) throws IOException {
        builder.startObject(ModelSnapshot.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(ModelSnapshot.SNAPSHOT_ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName()).field(TYPE, INTEGER).endObject().startObject(ModelSnapshot.RETAIN.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(Result.RESULT_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.TIMESTAMP_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
        ElasticsearchMappings.addModelSizeStatsFieldsToMapping(builder);
        builder.endObject();
        builder.endObject();
        builder.startObject(ModelSnapshot.QUANTILES.getPreferredName()).field(ENABLED, false).endObject().startObject(ModelSnapshot.LATEST_RECORD_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(ModelSnapshot.LATEST_RESULT_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static void addModelSizeStatsFieldsToMapping(XContentBuilder builder) throws IOException {
        builder.startObject(ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName()).field(TYPE, LONG).endObject().startObject(ModelSizeStats.MEMORY_STATUS_FIELD.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).field(TYPE, DATE).endObject();
    }

    public static XContentBuilder auditMessageMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject(AuditMessage.TYPE.getPreferredName()).startObject(PROPERTIES).startObject(Job.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(AuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
    }
}

