/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.DefaultDetectorDescription;
import org.elasticsearch.xpack.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class Detector
extends ToXContentToBytes
implements Writeable {
    public static final ParseField DETECTOR_DESCRIPTION_FIELD = new ParseField("detector_description", new String[0]);
    public static final ParseField FUNCTION_FIELD = new ParseField("function", new String[0]);
    public static final ParseField FIELD_NAME_FIELD = new ParseField("field_name", new String[0]);
    public static final ParseField BY_FIELD_NAME_FIELD = new ParseField("by_field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME_FIELD = new ParseField("over_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME_FIELD = new ParseField("partition_field_name", new String[0]);
    public static final ParseField USE_NULL_FIELD = new ParseField("use_null", new String[0]);
    public static final ParseField EXCLUDE_FREQUENT_FIELD = new ParseField("exclude_frequent", new String[0]);
    public static final ParseField DETECTOR_RULES_FIELD = new ParseField("detector_rules", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("detector", Builder::new);
    public static final String COUNT = "count";
    public static final String HIGH_COUNT = "high_count";
    public static final String LOW_COUNT = "low_count";
    public static final String NON_ZERO_COUNT = "non_zero_count";
    public static final String LOW_NON_ZERO_COUNT = "low_non_zero_count";
    public static final String HIGH_NON_ZERO_COUNT = "high_non_zero_count";
    public static final String NZC = "nzc";
    public static final String LOW_NZC = "low_nzc";
    public static final String HIGH_NZC = "high_nzc";
    public static final String DISTINCT_COUNT = "distinct_count";
    public static final String LOW_DISTINCT_COUNT = "low_distinct_count";
    public static final String HIGH_DISTINCT_COUNT = "high_distinct_count";
    public static final String DC = "dc";
    public static final String LOW_DC = "low_dc";
    public static final String HIGH_DC = "high_dc";
    public static final String RARE = "rare";
    public static final String FREQ_RARE = "freq_rare";
    public static final String INFO_CONTENT = "info_content";
    public static final String LOW_INFO_CONTENT = "low_info_content";
    public static final String HIGH_INFO_CONTENT = "high_info_content";
    public static final String METRIC = "metric";
    public static final String MEAN = "mean";
    public static final String MEDIAN = "median";
    public static final String LOW_MEDIAN = "low_median";
    public static final String HIGH_MEDIAN = "high_median";
    public static final String HIGH_MEAN = "high_mean";
    public static final String LOW_MEAN = "low_mean";
    public static final String AVG = "avg";
    public static final String HIGH_AVG = "high_avg";
    public static final String LOW_AVG = "low_avg";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String SUM = "sum";
    public static final String LOW_SUM = "low_sum";
    public static final String HIGH_SUM = "high_sum";
    public static final String NON_NULL_SUM = "non_null_sum";
    public static final String LOW_NON_NULL_SUM = "low_non_null_sum";
    public static final String HIGH_NON_NULL_SUM = "high_non_null_sum";
    public static final String BY = "by";
    public static final String OVER = "over";
    public static final String POPULATION_VARIANCE = "varp";
    public static final String LOW_POPULATION_VARIANCE = "low_varp";
    public static final String HIGH_POPULATION_VARIANCE = "high_varp";
    public static final String TIME_OF_DAY = "time_of_day";
    public static final String TIME_OF_WEEK = "time_of_week";
    public static final String LAT_LONG = "lat_long";
    public static final Set<String> ANALYSIS_FUNCTIONS;
    public static final Set<String> COUNT_WITHOUT_FIELD_FUNCTIONS;
    public static final Set<String> FIELD_NAME_FUNCTIONS;
    public static final Set<String> BY_FIELD_NAME_FUNCTIONS;
    public static final Set<String> OVER_FIELD_NAME_FUNCTIONS;
    public static final Set<String> NO_BY_FIELD_NAME_FUNCTIONS;
    public static final Set<String> NO_OVER_FIELD_NAME_FUNCTIONS;
    public static final Set<String> NO_OVERLAPPING_BUCKETS_FUNCTIONS;
    public static final Set<String> OVERLAPPING_BUCKETS_FUNCTIONS_NOT_NEEDED;
    public static final Character[] PROHIBITED_FIELDNAME_CHARACTERS;
    public static final String PROHIBITED;
    private final String detectorDescription;
    private final String function;
    private final String fieldName;
    private final String byFieldName;
    private final String overFieldName;
    private final String partitionFieldName;
    private final boolean useNull;
    private final ExcludeFrequent excludeFrequent;
    private final List<DetectionRule> detectorRules;
    private final int detectorIndex;

    public Detector(StreamInput in) throws IOException {
        this.detectorDescription = in.readString();
        this.function = in.readString();
        this.fieldName = in.readOptionalString();
        this.byFieldName = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.useNull = in.readBoolean();
        this.excludeFrequent = in.readBoolean() ? ExcludeFrequent.readFromStream(in) : null;
        this.detectorRules = in.readList(DetectionRule::new);
        this.detectorIndex = in.getVersion().onOrAfter(Version.V_5_5_0_UNRELEASED) ? in.readInt() : -1;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorDescription);
        out.writeString(this.function);
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.partitionFieldName);
        out.writeBoolean(this.useNull);
        if (this.excludeFrequent != null) {
            out.writeBoolean(true);
            this.excludeFrequent.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeList(this.detectorRules);
        if (out.getVersion().onOrAfter(Version.V_5_5_0_UNRELEASED)) {
            out.writeInt(this.detectorIndex);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DETECTOR_DESCRIPTION_FIELD.getPreferredName(), this.detectorDescription);
        builder.field(FUNCTION_FIELD.getPreferredName(), this.function);
        if (this.fieldName != null) {
            builder.field(FIELD_NAME_FIELD.getPreferredName(), this.fieldName);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME_FIELD.getPreferredName(), this.byFieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME_FIELD.getPreferredName(), this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName);
        }
        if (this.useNull) {
            builder.field(USE_NULL_FIELD.getPreferredName(), this.useNull);
        }
        if (this.excludeFrequent != null) {
            builder.field(EXCLUDE_FREQUENT_FIELD.getPreferredName(), (Object)this.excludeFrequent);
        }
        builder.field(DETECTOR_RULES_FIELD.getPreferredName(), this.detectorRules);
        if (this.detectorIndex >= 0 && !params.paramAsBoolean("for_cluster_state", false)) {
            builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        }
        builder.endObject();
        return builder;
    }

    private Detector(String detectorDescription, String function, String fieldName, String byFieldName, String overFieldName, String partitionFieldName, boolean useNull, ExcludeFrequent excludeFrequent, List<DetectionRule> detectorRules, int detectorIndex) {
        this.function = function;
        this.fieldName = fieldName;
        this.byFieldName = byFieldName;
        this.overFieldName = overFieldName;
        this.partitionFieldName = partitionFieldName;
        this.useNull = useNull;
        this.excludeFrequent = excludeFrequent;
        this.detectorRules = Collections.unmodifiableList(detectorRules);
        this.detectorDescription = detectorDescription != null ? detectorDescription : DefaultDetectorDescription.of(this);
        this.detectorIndex = detectorIndex;
    }

    public String getDetectorDescription() {
        return this.detectorDescription;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public boolean isUseNull() {
        return this.useNull;
    }

    public ExcludeFrequent getExcludeFrequent() {
        return this.excludeFrequent;
    }

    public List<DetectionRule> getDetectorRules() {
        return this.detectorRules;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public List<String> extractAnalysisFields() {
        List<String> analysisFields = Arrays.asList(this.getByFieldName(), this.getOverFieldName(), this.getPartitionFieldName());
        return analysisFields.stream().filter(item -> item != null).collect(Collectors.toList());
    }

    public Set<String> extractReferencedFilters() {
        return this.detectorRules == null ? Collections.emptySet() : this.detectorRules.stream().map(DetectionRule::extractReferencedFilters).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getByOverPartitionTerms() {
        HashSet<String> terms = new HashSet<String>();
        if (this.byFieldName != null) {
            terms.add(this.byFieldName);
        }
        if (this.overFieldName != null) {
            terms.add(this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            terms.add(this.partitionFieldName);
        }
        return terms;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Detector)) {
            return false;
        }
        Detector that = (Detector)((Object)other);
        return Objects.equals(this.detectorDescription, that.detectorDescription) && Objects.equals(this.function, that.function) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.useNull, that.useNull) && Objects.equals((Object)this.excludeFrequent, (Object)that.excludeFrequent) && Objects.equals(this.detectorRules, that.detectorRules) && this.detectorIndex == that.detectorIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detectorDescription, this.function, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.detectorRules, this.detectorIndex});
    }

    static {
        PARSER.declareString(Builder::setDetectorDescription, DETECTOR_DESCRIPTION_FIELD);
        PARSER.declareString(Builder::setFunction, FUNCTION_FIELD);
        PARSER.declareString(Builder::setFieldName, FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setByFieldName, BY_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setOverFieldName, OVER_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setPartitionFieldName, PARTITION_FIELD_NAME_FIELD);
        PARSER.declareBoolean(Builder::setUseNull, USE_NULL_FIELD);
        PARSER.declareField(Builder::setExcludeFrequent, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ExcludeFrequent.forString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, EXCLUDE_FREQUENT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareObjectArray(Builder::setDetectorRules, (parser, parseFieldMatcher) -> ((DetectionRule.Builder)DetectionRule.PARSER.apply(parser, parseFieldMatcher)).build(), DETECTOR_RULES_FIELD);
        PARSER.declareInt(Builder::setDetectorIndex, DETECTOR_INDEX);
        ANALYSIS_FUNCTIONS = new HashSet<String>(Arrays.asList(COUNT, HIGH_COUNT, LOW_COUNT, NON_ZERO_COUNT, NZC, LOW_NON_ZERO_COUNT, LOW_NZC, HIGH_NON_ZERO_COUNT, HIGH_NZC, DISTINCT_COUNT, DC, LOW_DISTINCT_COUNT, LOW_DC, HIGH_DISTINCT_COUNT, HIGH_DC, RARE, FREQ_RARE, INFO_CONTENT, LOW_INFO_CONTENT, HIGH_INFO_CONTENT, METRIC, MEAN, AVG, HIGH_MEAN, HIGH_AVG, LOW_MEAN, LOW_AVG, MEDIAN, LOW_MEDIAN, HIGH_MEDIAN, MIN, MAX, SUM, LOW_SUM, HIGH_SUM, NON_NULL_SUM, LOW_NON_NULL_SUM, HIGH_NON_NULL_SUM, POPULATION_VARIANCE, LOW_POPULATION_VARIANCE, HIGH_POPULATION_VARIANCE, TIME_OF_DAY, TIME_OF_WEEK, LAT_LONG));
        COUNT_WITHOUT_FIELD_FUNCTIONS = new HashSet<String>(Arrays.asList(COUNT, HIGH_COUNT, LOW_COUNT, NON_ZERO_COUNT, NZC, LOW_NON_ZERO_COUNT, LOW_NZC, HIGH_NON_ZERO_COUNT, HIGH_NZC, TIME_OF_DAY, TIME_OF_WEEK));
        FIELD_NAME_FUNCTIONS = new HashSet<String>(Arrays.asList(DISTINCT_COUNT, DC, LOW_DISTINCT_COUNT, LOW_DC, HIGH_DISTINCT_COUNT, HIGH_DC, INFO_CONTENT, LOW_INFO_CONTENT, HIGH_INFO_CONTENT, METRIC, MEAN, AVG, HIGH_MEAN, HIGH_AVG, LOW_MEAN, LOW_AVG, MEDIAN, LOW_MEDIAN, HIGH_MEDIAN, MIN, MAX, SUM, LOW_SUM, HIGH_SUM, NON_NULL_SUM, LOW_NON_NULL_SUM, HIGH_NON_NULL_SUM, POPULATION_VARIANCE, LOW_POPULATION_VARIANCE, HIGH_POPULATION_VARIANCE, LAT_LONG));
        BY_FIELD_NAME_FUNCTIONS = new HashSet<String>(Arrays.asList(RARE, FREQ_RARE));
        OVER_FIELD_NAME_FUNCTIONS = new HashSet<String>(Arrays.asList(FREQ_RARE));
        NO_BY_FIELD_NAME_FUNCTIONS = new HashSet<String>();
        NO_OVER_FIELD_NAME_FUNCTIONS = new HashSet<String>(Arrays.asList(NON_ZERO_COUNT, NZC, LOW_NON_ZERO_COUNT, LOW_NZC, HIGH_NON_ZERO_COUNT, HIGH_NZC));
        NO_OVERLAPPING_BUCKETS_FUNCTIONS = new HashSet<String>(Arrays.asList(RARE, FREQ_RARE));
        OVERLAPPING_BUCKETS_FUNCTIONS_NOT_NEEDED = new HashSet<String>(Arrays.asList(MIN, MAX, TIME_OF_DAY, TIME_OF_WEEK));
        PROHIBITED_FIELDNAME_CHARACTERS = new Character[]{Character.valueOf('\"'), Character.valueOf('\\')};
        PROHIBITED = String.join((CharSequence)",", Arrays.stream(PROHIBITED_FIELDNAME_CHARACTERS).map(c -> Character.toString(c.charValue())).collect(Collectors.toList()));
    }

    public static class Builder {
        static final Set<String> FUNCTIONS_WITHOUT_RULE_SUPPORT = new HashSet<String>(Arrays.asList("lat_long", "metric"));
        private String detectorDescription;
        private String function;
        private String fieldName;
        private String byFieldName;
        private String overFieldName;
        private String partitionFieldName;
        private boolean useNull = false;
        private ExcludeFrequent excludeFrequent;
        private List<DetectionRule> detectorRules = Collections.emptyList();
        private int detectorIndex = -1;

        public Builder() {
        }

        public Builder(Detector detector) {
            this.detectorDescription = detector.detectorDescription;
            this.function = detector.function;
            this.fieldName = detector.fieldName;
            this.byFieldName = detector.byFieldName;
            this.overFieldName = detector.overFieldName;
            this.partitionFieldName = detector.partitionFieldName;
            this.useNull = detector.useNull;
            this.excludeFrequent = detector.excludeFrequent;
            this.detectorRules = new ArrayList<DetectionRule>(detector.detectorRules.size());
            this.detectorRules.addAll(detector.getDetectorRules());
            this.detectorIndex = detector.detectorIndex;
        }

        public Builder(String function, String fieldName) {
            this.function = function;
            this.fieldName = fieldName;
        }

        public void setDetectorDescription(String detectorDescription) {
            this.detectorDescription = detectorDescription;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setByFieldName(String byFieldName) {
            this.byFieldName = byFieldName;
        }

        public void setOverFieldName(String overFieldName) {
            this.overFieldName = overFieldName;
        }

        public void setPartitionFieldName(String partitionFieldName) {
            this.partitionFieldName = partitionFieldName;
        }

        public void setUseNull(boolean useNull) {
            this.useNull = useNull;
        }

        public void setExcludeFrequent(ExcludeFrequent excludeFrequent) {
            this.excludeFrequent = excludeFrequent;
        }

        public void setDetectorRules(List<DetectionRule> detectorRules) {
            this.detectorRules = detectorRules;
        }

        public void setDetectorIndex(int detectorIndex) {
            this.detectorIndex = detectorIndex;
        }

        public Detector build() {
            String function;
            String[] fields;
            boolean emptyField = Strings.isEmpty((CharSequence)this.fieldName);
            boolean emptyByField = Strings.isEmpty((CharSequence)this.byFieldName);
            boolean emptyOverField = Strings.isEmpty((CharSequence)this.overFieldName);
            boolean emptyPartitionField = Strings.isEmpty((CharSequence)this.partitionFieldName);
            if (!ANALYSIS_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Unknown function ''{0}''", this.function), new Object[0]);
            }
            if (emptyField && emptyByField && emptyOverField && !COUNT_WITHOUT_FIELD_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Unless the function is 'count' one of field_name, by_field_name or over_field_name must be set"), new Object[0]);
            }
            if (emptyField && FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("field_name must be set when the ''{0}'' function is used", this.function), new Object[0]);
            }
            if (!emptyField && !FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("field_name cannot be used with function ''{0}''", this.function), new Object[0]);
            }
            if (emptyByField && BY_FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("by_field_name must be set when the ''{0}'' function is used", this.function), new Object[0]);
            }
            if (!emptyByField && NO_BY_FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("by_field_name cannot be used with function ''{0}''", this.function), new Object[0]);
            }
            if (emptyOverField && OVER_FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("over_field_name must be set when the ''{0}'' function is used", this.function), new Object[0]);
            }
            if (!emptyOverField && NO_OVER_FIELD_NAME_FUNCTIONS.contains(this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("over_field_name cannot be used with function ''{0}''", this.function), new Object[0]);
            }
            for (String field : fields = new String[]{this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName}) {
                Builder.verifyFieldName(field);
            }
            String string = function = this.function == null ? Detector.METRIC : this.function;
            if (!this.detectorRules.isEmpty()) {
                if (FUNCTIONS_WITHOUT_RULE_SUPPORT.contains(function)) {
                    String msg = Messages.getMessage("Invalid detector rule: function {0} does not support rules", function);
                    throw ExceptionsHelper.badRequestException(msg, new Object[0]);
                }
                for (DetectionRule rule : this.detectorRules) {
                    this.checkScoping(rule);
                }
            }
            if (!emptyPartitionField) {
                if (this.partitionFieldName.equals(this.byFieldName)) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", PARTITION_FIELD_NAME_FIELD.getPreferredName(), BY_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName), new Object[0]);
                }
                if (this.partitionFieldName.equals(this.overFieldName)) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", PARTITION_FIELD_NAME_FIELD.getPreferredName(), OVER_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName), new Object[0]);
                }
            }
            if (!emptyByField && this.byFieldName.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", BY_FIELD_NAME_FIELD.getPreferredName(), OVER_FIELD_NAME_FIELD.getPreferredName(), this.byFieldName), new Object[0]);
            }
            if (Detector.COUNT.equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''count'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.COUNT.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''count'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.BY.equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''by'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.BY.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''by'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.OVER.equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''over'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.OVER.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''over'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            return new Detector(this.detectorDescription, function, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.detectorRules, this.detectorIndex);
        }

        public List<String> extractAnalysisFields() {
            List<String> analysisFields = Arrays.asList(this.byFieldName, this.overFieldName, this.partitionFieldName);
            return analysisFields.stream().filter(item -> item != null).collect(Collectors.toList());
        }

        public static void verifyFieldName(String field) throws ElasticsearchParseException {
            if (field != null && Builder.containsInvalidChar(field)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid field name ''{0}''. Field names including over, by and partition fields cannot contain any of these characters: {1}", field, PROHIBITED), new Object[0]);
            }
            if (".".equals(field)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid field name ''{0}''. Field names including over, by and partition fields cannot be ''{1}''", field, "."), new Object[0]);
            }
        }

        private static boolean containsInvalidChar(String field) {
            for (Character ch : PROHIBITED_FIELDNAME_CHARACTERS) {
                if (field.indexOf(ch.charValue()) < 0) continue;
                return true;
            }
            return field.chars().anyMatch(Character::isISOControl);
        }

        private void checkScoping(DetectionRule rule) throws ElasticsearchParseException {
            String targetFieldName = rule.getTargetFieldName();
            this.checkTargetFieldNameIsValid(this.extractAnalysisFields(), targetFieldName);
            List<String> validOptions = this.getValidFieldNameOptions(rule);
            for (RuleCondition condition : rule.getRuleConditions()) {
                if (validOptions.contains(condition.getFieldName())) continue;
                String msg = Messages.getMessage("Invalid detector rule: field_name has to be one of {0}; actual was ''{1}''", validOptions, condition.getFieldName());
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
        }

        private void checkTargetFieldNameIsValid(List<String> analysisFields, String targetFieldName) throws ElasticsearchParseException {
            if (targetFieldName != null && !analysisFields.contains(targetFieldName)) {
                String msg = Messages.getMessage("Invalid detector rule: target_field_name has to be one of {0}; actual was ''{1}''", analysisFields, targetFieldName);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
        }

        private List<String> getValidFieldNameOptions(DetectionRule rule) {
            List<String> result = new ArrayList<String>();
            if (this.overFieldName != null) {
                result.add(this.byFieldName == null ? this.overFieldName : this.byFieldName);
            } else if (this.byFieldName != null) {
                result.add(this.byFieldName);
            }
            if (rule.getTargetFieldName() != null) {
                ScopingLevel targetLevel = ScopingLevel.from(this, rule.getTargetFieldName());
                result = result.stream().filter(field -> targetLevel.isHigherThan(ScopingLevel.from(this, field))).collect(Collectors.toList());
            }
            if (this.isEmptyFieldNameAllowed(rule)) {
                result.add(null);
            }
            return result;
        }

        private boolean isEmptyFieldNameAllowed(DetectionRule rule) {
            List<String> analysisFields = this.extractAnalysisFields();
            return analysisFields.isEmpty() || rule.getTargetFieldName() != null && analysisFields.size() == 1;
        }

        static enum ScopingLevel {
            PARTITION(3),
            OVER(2),
            BY(1);

            int level;

            private ScopingLevel(int level) {
                this.level = level;
            }

            boolean isHigherThan(ScopingLevel other) {
                return this.level > other.level;
            }

            static ScopingLevel from(Builder detector, String fieldName) {
                if (fieldName.equals(detector.partitionFieldName)) {
                    return PARTITION;
                }
                if (fieldName.equals(detector.overFieldName)) {
                    return OVER;
                }
                if (fieldName.equals(detector.byFieldName)) {
                    return BY;
                }
                throw ExceptionsHelper.badRequestException("fieldName '" + fieldName + "' does not match an analysis field", new Object[0]);
            }
        }
    }

    public static enum ExcludeFrequent implements Writeable
    {
        ALL,
        NONE,
        BY,
        OVER;


        public static ExcludeFrequent forString(String value) {
            return ExcludeFrequent.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static ExcludeFrequent readFromStream(StreamInput in) throws IOException {
            return (ExcludeFrequent)in.readEnum(ExcludeFrequent.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

