/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.time.DateTimeFormatterTimestampConverter;

public class DataDescription
extends ToXContentToBytes
implements Writeable {
    private static final ParseField DATA_DESCRIPTION_FIELD = new ParseField("data_description", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField TIME_FIELD_NAME_FIELD = new ParseField("time_field", new String[0]);
    private static final ParseField TIME_FORMAT_FIELD = new ParseField("time_format", new String[0]);
    private static final ParseField FIELD_DELIMITER_FIELD = new ParseField("field_delimiter", new String[0]);
    private static final ParseField QUOTE_CHARACTER_FIELD = new ParseField("quote_character", new String[0]);
    public static final String EPOCH = "epoch";
    public static final String EPOCH_MS = "epoch_ms";
    public static final String DEFAULT_TIME_FIELD = "time";
    public static final char DEFAULT_DELIMITER = '\t';
    public static final char LINE_ENDING = '\n';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    private final DataFormat dataFormat;
    private final String timeFieldName;
    private final String timeFormat;
    private final Character fieldDelimiter;
    private final Character quoteCharacter;
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(DATA_DESCRIPTION_FIELD.getPreferredName(), Builder::new);

    public DataDescription(DataFormat dataFormat, String timeFieldName, String timeFormat, Character fieldDelimiter, Character quoteCharacter) {
        this.dataFormat = dataFormat;
        this.timeFieldName = timeFieldName;
        this.timeFormat = timeFormat;
        this.fieldDelimiter = fieldDelimiter;
        this.quoteCharacter = quoteCharacter;
    }

    public DataDescription(StreamInput in) throws IOException {
        this.dataFormat = DataFormat.readFromStream(in);
        this.timeFieldName = in.readString();
        this.timeFormat = in.readString();
        this.fieldDelimiter = in.readBoolean() ? Character.valueOf((char)in.read()) : null;
        this.quoteCharacter = in.readBoolean() ? Character.valueOf((char)in.read()) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.dataFormat.writeTo(out);
        out.writeString(this.timeFieldName);
        out.writeString(this.timeFormat);
        if (this.fieldDelimiter != null) {
            out.writeBoolean(true);
            out.write((int)this.fieldDelimiter.charValue());
        } else {
            out.writeBoolean(false);
        }
        if (this.quoteCharacter != null) {
            out.writeBoolean(true);
            out.write((int)this.quoteCharacter.charValue());
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.dataFormat != DataFormat.XCONTENT) {
            builder.field(FORMAT_FIELD.getPreferredName(), (Object)this.dataFormat);
        }
        builder.field(TIME_FIELD_NAME_FIELD.getPreferredName(), this.timeFieldName);
        builder.field(TIME_FORMAT_FIELD.getPreferredName(), this.timeFormat);
        if (this.fieldDelimiter != null) {
            builder.field(FIELD_DELIMITER_FIELD.getPreferredName(), String.valueOf(this.fieldDelimiter));
        }
        if (this.quoteCharacter != null) {
            builder.field(QUOTE_CHARACTER_FIELD.getPreferredName(), String.valueOf(this.quoteCharacter));
        }
        builder.endObject();
        return builder;
    }

    public DataFormat getFormat() {
        return this.dataFormat;
    }

    public String getTimeField() {
        return this.timeFieldName;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Character getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public Character getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public boolean transform() {
        return this.dataFormat == DataFormat.XCONTENT || this.isTransformTime();
    }

    public boolean isTransformTime() {
        return this.timeFormat != null && !EPOCH.equals(this.timeFormat);
    }

    public boolean isEpochMs() {
        return EPOCH_MS.equals(this.timeFormat);
    }

    private static Character extractChar(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            String charStr = parser.text();
            if (charStr.length() != 1) {
                throw new IllegalArgumentException("String must be a single character, found [" + charStr + "]");
            }
            return Character.valueOf(charStr.charAt(0));
        }
        throw new IllegalArgumentException("Unsupported token [" + parser.currentToken() + "]");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataDescription)) {
            return false;
        }
        DataDescription that = (DataDescription)((Object)other);
        return this.dataFormat == that.dataFormat && Objects.equals(this.quoteCharacter, that.quoteCharacter) && Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.timeFormat, that.timeFormat) && Objects.equals(this.fieldDelimiter, that.fieldDelimiter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataFormat, this.quoteCharacter, this.timeFieldName, this.timeFormat, this.fieldDelimiter});
    }

    static {
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setFormat(x$0), FORMAT_FIELD);
        PARSER.declareString(Builder::setTimeField, TIME_FIELD_NAME_FIELD);
        PARSER.declareString(Builder::setTimeFormat, TIME_FORMAT_FIELD);
        PARSER.declareField(Builder::setFieldDelimiter, DataDescription::extractChar, FIELD_DELIMITER_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(Builder::setQuoteCharacter, DataDescription::extractChar, QUOTE_CHARACTER_FIELD, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private DataFormat dataFormat = DataFormat.XCONTENT;
        private String timeFieldName = "time";
        private String timeFormat = "epoch_ms";
        private Character fieldDelimiter;
        private Character quoteCharacter;

        public void setFormat(DataFormat format) {
            this.dataFormat = ExceptionsHelper.requireNonNull(format, FORMAT_FIELD.getPreferredName() + " must not be null");
        }

        private void setFormat(String format) {
            this.setFormat(DataFormat.forString(format));
        }

        public void setTimeField(String fieldName) {
            this.timeFieldName = ExceptionsHelper.requireNonNull(fieldName, TIME_FIELD_NAME_FIELD.getPreferredName() + " must not be null");
        }

        public void setTimeFormat(String format) {
            ExceptionsHelper.requireNonNull(format, TIME_FORMAT_FIELD.getPreferredName() + " must not be null");
            switch (format) {
                case "epoch": 
                case "epoch_ms": {
                    break;
                }
                default: {
                    try {
                        DateTimeFormatterTimestampConverter.ofPattern(format, ZoneOffset.UTC);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid Time format string ''{0}''", format), new Object[0]);
                    }
                }
            }
            this.timeFormat = format;
        }

        public void setFieldDelimiter(Character delimiter) {
            this.fieldDelimiter = delimiter;
        }

        public void setQuoteCharacter(Character value) {
            this.quoteCharacter = value;
        }

        public DataDescription build() {
            if (this.dataFormat == DataFormat.DELIMITED) {
                if (this.fieldDelimiter == null) {
                    this.fieldDelimiter = Character.valueOf('\t');
                }
                if (this.quoteCharacter == null) {
                    this.quoteCharacter = Character.valueOf('\"');
                }
            }
            return new DataDescription(this.dataFormat, this.timeFieldName, this.timeFormat, this.fieldDelimiter, this.quoteCharacter);
        }
    }

    public static enum DataFormat implements Writeable
    {
        XCONTENT,
        DELIMITED;

        private static final String DEPRECATED_DELINEATED = "DELINEATED";

        public static DataFormat forString(String value) {
            String valueUpperCase = value.toUpperCase(Locale.ROOT);
            return DEPRECATED_DELINEATED.equals(valueUpperCase) ? DELIMITED : DataFormat.valueOf(valueUpperCase);
        }

        public static DataFormat readFromStream(StreamInput in) throws IOException {
            return (DataFormat)in.readEnum(DataFormat.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

