/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.Operator;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class Condition
extends ToXContentToBytes
implements Writeable {
    public static final ParseField CONDITION_FIELD = new ParseField("condition", new String[0]);
    public static final ParseField FILTER_VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<Condition, Void> PARSER = new ConstructingObjectParser(CONDITION_FIELD.getPreferredName(), a -> new Condition((Operator)((Object)((Object)a[0])), (String)a[1]));
    private final Operator op;
    private final String filterValue;

    public Condition(StreamInput in) throws IOException {
        this.op = Operator.readFromStream(in);
        this.filterValue = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.op.writeTo(out);
        out.writeOptionalString(this.filterValue);
    }

    public Condition(Operator op, String filterValue) {
        if (filterValue == null) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid condition: the value field cannot be null"), new Object[0]);
        }
        if (op.expectsANumericArgument()) {
            try {
                Double.parseDouble(filterValue);
            }
            catch (NumberFormatException nfe) {
                String msg = Messages.getMessage("Invalid condition value: cannot parse a double from string ''{0}''", filterValue);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
        }
        try {
            Pattern.compile(filterValue);
        }
        catch (PatternSyntaxException e) {
            String msg = Messages.getMessage("Invalid condition value: ''{0}'' is not a valid regular expression", filterValue);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
        this.op = op;
        this.filterValue = filterValue;
    }

    public Operator getOperator() {
        return this.op;
    }

    public String getValue() {
        return this.filterValue;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Operator.OPERATOR_FIELD.getPreferredName(), (Object)this.op);
        builder.field(FILTER_VALUE_FIELD.getPreferredName(), this.filterValue);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.filterValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)((Object)obj);
        return Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.filterValue, other.filterValue);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Operator.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, Operator.OPERATOR_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, FILTER_VALUE_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
    }
}

