/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class AnalysisLimits
extends ToXContentToBytes
implements Writeable {
    public static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    public static final ParseField CATEGORIZATION_EXAMPLES_LIMIT = new ParseField("categorization_examples_limit", new String[0]);
    public static final ConstructingObjectParser<AnalysisLimits, Void> PARSER = new ConstructingObjectParser("analysis_limits", a -> new AnalysisLimits((Long)a[0], (Long)a[1]));
    private final Long modelMemoryLimit;
    private final Long categorizationExamplesLimit;

    public AnalysisLimits(Long modelMemoryLimit, Long categorizationExamplesLimit) {
        this.modelMemoryLimit = modelMemoryLimit;
        if (categorizationExamplesLimit != null && categorizationExamplesLimit < 0L) {
            String msg = Messages.getMessage("{0} cannot be less than {1,number}. Value = {2,number}", CATEGORIZATION_EXAMPLES_LIMIT, 0, categorizationExamplesLimit);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
        this.categorizationExamplesLimit = categorizationExamplesLimit;
    }

    public AnalysisLimits(StreamInput in) throws IOException {
        this(in.readOptionalLong(), in.readOptionalLong());
    }

    @Nullable
    public Long getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Long getCategorizationExamplesLimit() {
        return this.categorizationExamplesLimit;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalLong(this.modelMemoryLimit);
        out.writeOptionalLong(this.categorizationExamplesLimit);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelMemoryLimit != null) {
            builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit);
        }
        if (this.categorizationExamplesLimit != null) {
            builder.field(CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), this.categorizationExamplesLimit);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalysisLimits)) {
            return false;
        }
        AnalysisLimits that = (AnalysisLimits)((Object)other);
        return Objects.equals(this.modelMemoryLimit, that.modelMemoryLimit) && Objects.equals(this.categorizationExamplesLimit, that.categorizationExamplesLimit);
    }

    public int hashCode() {
        return Objects.hash(this.modelMemoryLimit, this.categorizationExamplesLimit);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MODEL_MEMORY_LIMIT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CATEGORIZATION_EXAMPLES_LIMIT);
    }
}

