/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;

public class ValidateJobConfigAction
extends Action<Request, Response, RequestBuilder> {
    public static final ValidateJobConfigAction INSTANCE = new ValidateJobConfigAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/validate";

    protected ValidateJobConfigAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, ValidateJobConfigAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            listener.onResponse((Object)new Response(true));
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class Request
    extends ActionRequest {
        private Job job;

        public static Request parseRequest(XContentParser parser) {
            Job.Builder job;
            job.setId((job = (Job.Builder)Job.PARSER.apply(parser, null)).getId() != null ? job.getId() : "ok");
            List<String> invalidJobCreationSettings = job.invalidCreateTimeSettings();
            if (!invalidJobCreationSettings.isEmpty()) {
                throw new IllegalArgumentException(Messages.getMessage("The job is configured with fields [{0}] that are illegal to set at job creation", String.join((CharSequence)",", invalidJobCreationSettings)));
            }
            return new Request(job.build(new Date()));
        }

        Request() {
            this.job = null;
        }

        public Request(Job job) {
            this.job = job;
        }

        public Job getJob() {
            return this.job;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.job.writeTo(out);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.job = new Job(in);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.job});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.job, (Object)other.job);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, ValidateJobConfigAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

