/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.security.InternalClient;

public class RevertModelSnapshotAction
extends Action<Request, Response, RequestBuilder> {
    public static final RevertModelSnapshotAction INSTANCE = new RevertModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/revert";

    private RevertModelSnapshotAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final Client client;
        private final JobManager jobManager;
        private final JobProvider jobProvider;
        private final JobDataCountsPersister jobDataCountsPersister;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, JobProvider jobProvider, ClusterService clusterService, InternalClient client, JobDataCountsPersister jobDataCountsPersister) {
            super(settings, RevertModelSnapshotAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.client = client;
            this.jobManager = jobManager;
            this.jobProvider = jobProvider;
            this.jobDataCountsPersister = jobDataCountsPersister;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            this.logger.debug("Received request to revert to snapshot id '{}' for job '{}', deleting intervening results: {}", (Object)request.getSnapshotId(), (Object)request.getJobId(), (Object)request.getDeleteInterveningResults());
            QueryPage<Job> job = this.jobManager.getJob(request.getJobId(), this.clusterService.state());
            JobState jobState = this.jobManager.getJobState(request.getJobId());
            if (job.count() > 0L && !jobState.equals((Object)JobState.CLOSED)) {
                throw ExceptionsHelper.conflictStatusException(Messages.getMessage("Can only revert to a model snapshot when the job is closed."), new Object[0]);
            }
            this.getModelSnapshot(request, this.jobProvider, modelSnapshot -> {
                ActionListener<Response> wrappedListener = listener;
                if (request.getDeleteInterveningResults()) {
                    wrappedListener = this.wrapDeleteOldDataListener(wrappedListener, (ModelSnapshot)((Object)modelSnapshot), request.getJobId());
                    wrappedListener = this.wrapRevertDataCountsListener(wrappedListener, (ModelSnapshot)((Object)modelSnapshot), request.getJobId());
                }
                this.jobManager.revertSnapshot(request, wrappedListener, (ModelSnapshot)((Object)modelSnapshot));
            }, arg_0 -> listener.onFailure(arg_0));
        }

        private void getModelSnapshot(Request request, JobProvider provider, Consumer<ModelSnapshot> handler, Consumer<Exception> errorHandler) {
            this.logger.info("Reverting to snapshot '" + request.getSnapshotId() + "'");
            provider.getModelSnapshot(request.getJobId(), request.getSnapshotId(), (Result<ModelSnapshot> modelSnapshot) -> {
                if (modelSnapshot == null) {
                    throw new ResourceNotFoundException(Messages.getMessage("No model snapshot with id [{0}] exists for job [{1}]", request.getSnapshotId(), request.getJobId()), new Object[0]);
                }
                handler.accept((ModelSnapshot)((Object)modelSnapshot.result));
            }, errorHandler);
        }

        private ActionListener<Response> wrapDeleteOldDataListener(final ActionListener<Response> listener, ModelSnapshot modelSnapshot, String jobId) {
            return ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    Date deleteAfter = modelSnapshot.getLatestResultTimeStamp();
                    this.logger.debug("Removing intervening records: last record: " + deleteAfter + ", last result: " + modelSnapshot.getLatestResultTimeStamp());
                    this.logger.info("Deleting results after '" + deleteAfter + "'");
                    JobDataDeleter dataDeleter = new JobDataDeleter(this.client, jobId);
                    dataDeleter.deleteResultsFromTime(deleteAfter.getTime() + 1L, new ActionListener<Boolean>(){

                        public void onResponse(Boolean success) {
                            listener.onResponse((Object)response);
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    });
                }
            }, arg_0 -> listener.onFailure(arg_0));
        }

        private ActionListener<Response> wrapRevertDataCountsListener(final ActionListener<Response> listener, ModelSnapshot modelSnapshot, String jobId) {
            return ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.jobProvider.dataCounts(jobId, counts -> {
                        counts.setLatestRecordTimeStamp(modelSnapshot.getLatestRecordTimeStamp());
                        this.jobDataCountsPersister.persistDataCounts(jobId, (DataCounts)((Object)((Object)counts)), new ActionListener<Boolean>(){

                            public void onResponse(Boolean aBoolean) {
                                listener.onResponse((Object)response);
                            }

                            public void onFailure(Exception e) {
                                listener.onFailure(e);
                            }
                        });
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                }
            }, arg_0 -> listener.onFailure(arg_0));
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Response
    extends AcknowledgedResponse
    implements StatusToXContentObject {
        private static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
        private static final ParseField MODEL = new ParseField("model", new String[0]);
        private ModelSnapshot model;

        Response() {
        }

        public Response(ModelSnapshot modelSnapshot) {
            super(true);
            this.model = modelSnapshot;
        }

        public ModelSnapshot getModel() {
            return this.model;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
            this.model = new ModelSnapshot(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
            this.model.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.OK;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ACKNOWLEDGED.getPreferredName(), true);
            builder.field(MODEL.getPreferredName());
            builder = this.model.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.model});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.model, (Object)other.model);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        public static final ParseField DELETE_INTERVENING = new ParseField("delete_intervening_results", new String[0]);
        private static ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/model_snapshots/revert", Request::new);
        private String jobId;
        private String snapshotId;
        private boolean deleteInterveningResults;

        public static Request parseRequest(String jobId, String snapshotId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            if (snapshotId != null) {
                request.snapshotId = snapshotId;
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, SNAPSHOT_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public boolean getDeleteInterveningResults() {
            return this.deleteInterveningResults;
        }

        public void setDeleteInterveningResults(boolean deleteInterveningResults) {
            this.deleteInterveningResults = deleteInterveningResults;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.deleteInterveningResults = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeBoolean(this.deleteInterveningResults);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
            builder.field(DELETE_INTERVENING.getPreferredName(), this.deleteInterveningResults);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.deleteInterveningResults);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.deleteInterveningResults, other.deleteInterveningResults);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString((request, snapshotId) -> {
                request.snapshotId = snapshotId;
            }, SNAPSHOT_ID);
            PARSER.declareBoolean(Request::setDeleteInterveningResults, DELETE_INTERVENING);
        }
    }
}

