/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.support.Exceptions;

public class PutDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final PutDatafeedAction INSTANCE = new PutDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/put";

    private PutDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final XPackLicenseState licenseState;
        private final Client client;
        private final boolean securityEnabled;
        private final SecurityContext securityContext;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, @Nullable CryptoService cryptoService) {
            super(settings, PutDatafeedAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.licenseState = licenseState;
            this.client = client;
            this.securityEnabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
            this.securityContext = this.securityEnabled ? new SecurityContext(settings, threadPool.getThreadContext(), cryptoService) : null;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            if (this.securityEnabled) {
                String username = this.securityContext.getUser().principal();
                ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)((Object)r), listener), arg_0 -> listener.onFailure(arg_0));
                HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
                privRequest.username(username);
                privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
                privRequest.indexPrivileges(RoleDescriptor.IndicesPrivileges.builder().indices(request.getDatafeed().getIndices().toArray(new String[0])).privileges("indices:data/read/search").build());
                this.client.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
            } else {
                this.putDatafeed(request, listener);
            }
        }

        private void handlePrivsResponse(String username, Request request, HasPrivilegesResponse response, ActionListener<Response> listener) throws IOException {
            if (response.isCompleteMatch()) {
                this.putDatafeed(request, listener);
            } else {
                XContentBuilder builder = JsonXContent.contentBuilder();
                builder.startObject();
                for (HasPrivilegesResponse.IndexPrivileges index : response.getIndexPrivileges()) {
                    builder.field(index.getIndex());
                    builder.map(index.getPrivileges());
                }
                builder.endObject();
                listener.onFailure((Exception)((Object)Exceptions.authorizationError("Cannot create datafeed [{}] because user {} lacks permissions on the indices to be searched: {}", request.getDatafeed().getId(), username, builder.string())));
            }
        }

        private void putDatafeed(final Request request, ActionListener<Response> listener) {
            this.clusterService.submitStateUpdateTask("put-datafeed-" + request.getDatafeed().getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Response>((AckedRequest)request, listener){

                protected Response newResponse(boolean acknowledged) {
                    if (acknowledged) {
                        logger.info("Created datafeed [{}]", (Object)request.getDatafeed().getId());
                    }
                    return new Response(acknowledged, request.getDatafeed());
                }

                public ClusterState execute(ClusterState currentState) throws Exception {
                    return this.putDatafeed(request, currentState);
                }
            });
        }

        private ClusterState putDatafeed(Request request, ClusterState clusterState) {
            MlMetadata currentMetadata = (MlMetadata)clusterState.getMetaData().custom("ml");
            MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).putDatafeed(request.getDatafeed()).build();
            return ClusterState.builder((ClusterState)clusterState).metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            if (this.licenseState.isMachineLearningAllowed()) {
                super.doExecute(task, (MasterNodeRequest)request, listener);
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("ml")));
            }
        }
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        private DatafeedConfig datafeed;

        public Response(boolean acked, DatafeedConfig datafeed) {
            super(acked);
            this.datafeed = datafeed;
        }

        Response() {
        }

        public DatafeedConfig getResponse() {
            return this.datafeed;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
            this.datafeed = new DatafeedConfig(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
            this.datafeed.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.datafeed.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals((Object)this.datafeed, (Object)response.datafeed);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.datafeed});
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, PutDatafeedAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        private DatafeedConfig datafeed;

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            DatafeedConfig.Builder datafeed = (DatafeedConfig.Builder)DatafeedConfig.PARSER.apply(parser, null);
            datafeed.setId(datafeedId);
            return new Request(datafeed.build());
        }

        public Request(DatafeedConfig datafeed) {
            this.datafeed = datafeed;
        }

        Request() {
        }

        public DatafeedConfig getDatafeed() {
            return this.datafeed;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeed = new DatafeedConfig(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.datafeed.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.datafeed.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals((Object)this.datafeed, (Object)request.datafeed);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.datafeed});
        }
    }
}

