/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.action.DeleteExpiredDataAction;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class MlDailyMaintenanceService
implements Releasable {
    private static final Logger LOGGER = Loggers.getLogger(MlDailyMaintenanceService.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final Supplier<TimeValue> schedulerProvider;
    private volatile ScheduledFuture<?> future;

    MlDailyMaintenanceService(ThreadPool threadPool, Client client, Supplier<TimeValue> scheduleProvider) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(client);
        this.schedulerProvider = Objects.requireNonNull(scheduleProvider);
    }

    public MlDailyMaintenanceService(ThreadPool threadPool, Client client) {
        this(threadPool, client, MlDailyMaintenanceService.createAfterMidnightScheduleProvider());
    }

    private static Supplier<TimeValue> createAfterMidnightScheduleProvider() {
        return () -> {
            DateTime now = DateTime.now((Chronology)ISOChronology.getInstance());
            DateTime next = now.plusDays(1).withTimeAtStartOfDay().plusMinutes(30);
            return TimeValue.timeValueMillis((long)(next.getMillis() - now.getMillis()));
        };
    }

    public void start() {
        LOGGER.debug("Starting ML daily maintenance service");
        this.scheduleNext();
    }

    public void stop() {
        LOGGER.debug("Stopping ML daily maintenance service");
        if (this.future != null && !this.future.isCancelled()) {
            FutureUtils.cancel(this.future);
        }
    }

    public boolean isStarted() {
        return this.future != null;
    }

    public void close() {
        this.stop();
    }

    private void scheduleNext() {
        try {
            this.future = this.threadPool.schedule(this.schedulerProvider.get(), "generic", this::triggerTasks);
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                LOGGER.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    private void triggerTasks() {
        LOGGER.info("triggering scheduled [ML] maintenance tasks");
        try {
            this.client.execute((Action)DeleteExpiredDataAction.INSTANCE, (ActionRequest)new DeleteExpiredDataAction.Request());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during maintenance tasks execution", (Throwable)e);
        }
        this.scheduleNext();
    }
}

