/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.http.auth.HttpAuth;
import org.elasticsearch.xpack.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.WatcherUtils;

public class HttpRequest
implements ToXContentObject {
    final String host;
    final int port;
    final Scheme scheme;
    final HttpMethod method;
    @Nullable
    final String path;
    final Map<String, String> params;
    final Map<String, String> headers;
    @Nullable
    final HttpAuth auth;
    @Nullable
    final String body;
    @Nullable
    final TimeValue connectionTimeout;
    @Nullable
    final TimeValue readTimeout;
    @Nullable
    final HttpProxy proxy;

    public HttpRequest(String host, int port, @Nullable Scheme scheme, @Nullable HttpMethod method, @Nullable String path, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable HttpAuth auth, @Nullable String body, @Nullable TimeValue connectionTimeout, @Nullable TimeValue readTimeout, @Nullable HttpProxy proxy) {
        this.host = host;
        this.port = port;
        this.scheme = scheme != null ? scheme : Scheme.HTTP;
        this.method = method != null ? method : HttpMethod.GET;
        this.path = path;
        this.params = params != null ? params : Collections.emptyMap();
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.auth = auth;
        this.body = body;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HttpMethod method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public HttpAuth auth() {
        return this.auth;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String body() {
        return this.body;
    }

    public TimeValue connectionTimeout() {
        return this.connectionTimeout;
    }

    public TimeValue readTimeout() {
        return this.readTimeout;
    }

    public HttpProxy proxy() {
        return this.proxy;
    }

    public static String encodeUrl(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("failed to URL encode text [" + text + "]", e);
        }
    }

    public static String decodeUrl(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("failed to URL decode text [" + text + "]", e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.HOST.getPreferredName(), this.host);
        builder.field(Field.PORT.getPreferredName(), this.port);
        builder.field(Field.SCHEME.getPreferredName(), (ToXContent)this.scheme, params);
        builder.field(Field.METHOD.getPreferredName(), (ToXContent)this.method, params);
        if (this.path != null) {
            builder.field(Field.PATH.getPreferredName(), this.path);
        }
        if (!this.params.isEmpty()) {
            builder.field(Field.PARAMS.getPreferredName(), this.params);
        }
        if (!this.headers.isEmpty()) {
            builder.field(Field.HEADERS.getPreferredName(), this.headers);
        }
        if (this.auth != null) {
            builder.startObject(Field.AUTH.getPreferredName()).field(this.auth.type(), (ToXContent)this.auth, params).endObject();
        }
        if (this.body != null) {
            builder.field(Field.BODY.getPreferredName(), this.body);
        }
        if (this.connectionTimeout != null) {
            builder.timeValueField(Field.CONNECTION_TIMEOUT.getPreferredName(), Field.CONNECTION_TIMEOUT_HUMAN.getPreferredName(), this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.timeValueField(Field.READ_TIMEOUT.getPreferredName(), Field.READ_TIMEOUT_HUMAN.getPreferredName(), this.readTimeout);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (this.port != that.port) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (this.scheme != that.scheme) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (!this.params.equals(that.params)) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.connectionTimeout != null ? !this.connectionTimeout.equals((Object)that.connectionTimeout) : that.connectionTimeout != null) {
            return false;
        }
        if (this.readTimeout != null ? !this.readTimeout.equals((Object)that.readTimeout) : that.readTimeout != null) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        return !(this.body == null ? that.body != null : !this.body.equals(that.body));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.scheme, this.method, this.path, this.params, this.headers, this.auth, this.connectionTimeout, this.readTimeout, this.body, this.proxy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("method=[").append((Object)this.method).append("], ");
        sb.append("scheme=[").append((Object)this.scheme).append("], ");
        sb.append("host=[").append(this.host).append("], ");
        sb.append("port=[").append(this.port).append("], ");
        sb.append("path=[").append(this.path).append("], ");
        if (!this.headers.isEmpty()) {
            sb.append(", headers=[");
            boolean first = true;
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("[").append(header.getKey()).append(": ").append(header.getValue()).append("]");
                first = false;
            }
            sb.append("], ");
        }
        if (this.auth != null) {
            sb.append("auth=[").append(this.auth.type()).append("], ");
        }
        sb.append("connection_timeout=[").append(this.connectionTimeout).append("], ");
        sb.append("read_timeout=[").append(this.readTimeout).append("], ");
        if (this.proxy != null) {
            sb.append("proxy=[").append(this.proxy).append("], ");
        }
        sb.append("body=[").append(this.body).append("], ");
        return sb.toString();
    }

    public static Builder builder(String host, int port) {
        return new Builder(host, port);
    }

    static Builder builder() {
        return new Builder();
    }

    public static interface Field {
        public static final ParseField SCHEME = new ParseField("scheme", new String[0]);
        public static final ParseField HOST = new ParseField("host", new String[0]);
        public static final ParseField PORT = new ParseField("port", new String[0]);
        public static final ParseField METHOD = new ParseField("method", new String[0]);
        public static final ParseField PATH = new ParseField("path", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
        public static final ParseField HEADERS = new ParseField("headers", new String[0]);
        public static final ParseField AUTH = new ParseField("auth", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
        public static final ParseField CONNECTION_TIMEOUT = new ParseField("connection_timeout_in_millis", new String[0]);
        public static final ParseField CONNECTION_TIMEOUT_HUMAN = new ParseField("connection_timeout", new String[0]);
        public static final ParseField READ_TIMEOUT = new ParseField("read_timeout_millis", new String[0]);
        public static final ParseField READ_TIMEOUT_HUMAN = new ParseField("read_timeout", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
        public static final ParseField URL = new ParseField("url", new String[0]);
    }

    public static class Builder {
        private String host;
        private int port = -1;
        private Scheme scheme;
        private HttpMethod method;
        private String path;
        private Map<String, String> params = new HashMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();
        private HttpAuth auth;
        private String body;
        private TimeValue connectionTimeout;
        private TimeValue readTimeout;
        private HttpProxy proxy;

        private Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private Builder() {
        }

        public Builder scheme(Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            if (this.params == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.params.putAll(params);
            return this;
        }

        public Builder setParam(String key, String value) {
            if (this.params == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.params.put(key, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            if (this.headers == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.headers.putAll(headers);
            return this;
        }

        public Builder setHeader(String key, String value) {
            if (this.headers == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder auth(HttpAuth auth) {
            this.auth = auth;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder jsonBody(ToXContent xContent) {
            return this.body(XContentHelper.toString((ToXContent)xContent)).setHeader("Content-Type", XContentType.JSON.mediaType());
        }

        public Builder connectionTimeout(TimeValue timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder readTimeout(TimeValue timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder proxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpRequest build() {
            HttpRequest request = new HttpRequest(this.host, this.port, this.scheme, this.method, this.path, Collections.unmodifiableMap(this.params), Collections.unmodifiableMap(this.headers), this.auth, this.body, this.connectionTimeout, this.readTimeout, this.proxy);
            this.params = null;
            this.headers = null;
            return request;
        }

        public Builder fromUrl(String supposedUrl) {
            if (!Strings.hasLength((String)supposedUrl)) {
                throw new ElasticsearchParseException("Configured URL is empty, please configure a valid URL", new Object[0]);
            }
            try {
                String rawQuery;
                URI uri = new URI(supposedUrl);
                if (!Strings.hasLength((String)uri.getScheme())) {
                    throw new ElasticsearchParseException("URL [{}] does not contain a scheme", new Object[]{uri});
                }
                this.scheme = Scheme.parse(uri.getScheme());
                this.port = uri.getPort() > 0 ? uri.getPort() : this.scheme.defaultPort();
                this.host = uri.getHost();
                if (Strings.hasLength((String)uri.getPath())) {
                    this.path = uri.getPath();
                }
                if (Strings.hasLength((String)(rawQuery = uri.getRawQuery()))) {
                    RestUtils.decodeQueryString((String)rawQuery, (int)0, this.params);
                }
            }
            catch (URISyntaxException e) {
                throw new ElasticsearchParseException("Malformed URL [{}]", new Object[]{supposedUrl});
            }
            return this;
        }
    }

    public static class Parser {
        private final HttpAuthRegistry httpAuthRegistry;

        public Parser(HttpAuthRegistry httpAuthRegistry) {
            this.httpAuthRegistry = httpAuthRegistry;
        }

        public HttpRequest parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.PROXY.match(currentFieldName)) {
                    try {
                        builder.proxy(HttpProxy.parse(parser));
                        continue;
                    }
                    catch (Exception e) {
                        throw new ElasticsearchParseException("could not parse http request. could not parse [{}] field", new Object[]{currentFieldName});
                    }
                }
                if (Field.AUTH.match(currentFieldName)) {
                    builder.auth(this.httpAuthRegistry.parse(parser));
                    continue;
                }
                if (Field.CONNECTION_TIMEOUT.match(currentFieldName)) {
                    builder.connectionTimeout(TimeValue.timeValueMillis((long)parser.longValue()));
                    continue;
                }
                if (Field.CONNECTION_TIMEOUT_HUMAN.match(currentFieldName)) {
                    try {
                        builder.connectionTimeout(WatcherDateTimeUtils.parseTimeValue(parser, Field.CONNECTION_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (Field.READ_TIMEOUT.match(currentFieldName)) {
                    builder.readTimeout(TimeValue.timeValueMillis((long)parser.longValue()));
                    continue;
                }
                if (Field.READ_TIMEOUT_HUMAN.match(currentFieldName)) {
                    try {
                        builder.readTimeout(WatcherDateTimeUtils.parseTimeValue(parser, Field.READ_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (Field.HEADERS.match(currentFieldName)) {
                        builder.setHeaders(WatcherUtils.flattenModel(parser.map()));
                        continue;
                    }
                    if (Field.PARAMS.match(currentFieldName)) {
                        builder.setParams(WatcherUtils.flattenModel(parser.map()));
                        continue;
                    }
                    if (Field.BODY.match(currentFieldName)) {
                        builder.body(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected object field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (Field.SCHEME.match(currentFieldName)) {
                        builder.scheme(Scheme.parse(parser.text()));
                        continue;
                    }
                    if (Field.METHOD.match(currentFieldName)) {
                        builder.method(HttpMethod.parse(parser.text()));
                        continue;
                    }
                    if (Field.HOST.match(currentFieldName)) {
                        builder.host = parser.text();
                        continue;
                    }
                    if (Field.PATH.match(currentFieldName)) {
                        builder.path(parser.text());
                        continue;
                    }
                    if (Field.BODY.match(currentFieldName)) {
                        builder.body(parser.text());
                        continue;
                    }
                    if (Field.URL.match(currentFieldName)) {
                        builder.fromUrl(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected string field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (Field.PORT.match(currentFieldName)) {
                        builder.port = parser.intValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected numeric field [{}]", new Object[]{currentFieldName});
                }
                throw new ElasticsearchParseException("could not parse http request. unexpected token [{}]", new Object[]{token});
            }
            if (builder.host == null) {
                throw new ElasticsearchParseException("could not parse http request. missing required [{}] field", new Object[]{Field.HOST.getPreferredName()});
            }
            if (builder.port < 0) {
                throw new ElasticsearchParseException("could not parse http request. missing required [{}] field", new Object[]{Field.PORT.getPreferredName()});
            }
            return builder.build();
        }
    }
}

