/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.CryptUtils;
import org.elasticsearch.license.License;

class TrialLicense {
    TrialLicense() {
    }

    public static License create(License.Builder specBuilder) {
        String signature;
        License spec = specBuilder.type("trial").issuer("elasticsearch").version(3).build();
        try {
            XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            spec.toXContent(contentBuilder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("license_spec_view", "true")));
            byte[] encrypt = CryptUtils.encrypt(BytesReference.toBytes((BytesReference)contentBuilder.bytes()));
            byte[] bytes = new byte[8 + encrypt.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(-3).putInt(encrypt.length).put(encrypt);
            signature = Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return License.builder().fromLicenseSpec(spec, signature).build();
    }

    public static boolean verify(License license) {
        try {
            License expectedLicense;
            byte[] signatureBytes = Base64.getDecoder().decode(license.signature());
            ByteBuffer byteBuffer = ByteBuffer.wrap(signatureBytes);
            int version = byteBuffer.getInt();
            int contentLen = byteBuffer.getInt();
            byte[] content = new byte[contentLen];
            byteBuffer.get(content);
            try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, CryptUtils.decrypt(content));){
                parser.nextToken();
                expectedLicense = License.builder().fromLicenseSpec(License.fromXContent(parser), license.signature()).version(-version).build();
            }
            return license.equals(expectedLicense);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

