/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentParser;

public final class XContentFilterKeysUtils {
    private XContentFilterKeysUtils() {
    }

    public static Map<String, Object> filterMapOrdered(Set<String> keys, XContentParser parser) throws IOException {
        try {
            if (parser.currentToken() != null) {
                throw new IllegalArgumentException("Parser already started");
            }
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Content should start with START_OBJECT");
            }
            State state = new State(new ArrayList<String>(keys));
            return XContentFilterKeysUtils.parse(parser, state);
        }
        catch (IOException e) {
            throw new IOException("could not build a filtered payload out of xcontent", e);
        }
    }

    private static Map<String, Object> parse(XContentParser parser, State state) throws IOException {
        return XContentFilterKeysUtils.parse(parser, state, true);
    }

    private static Map<String, Object> parse(XContentParser parser, State state, boolean isOutsideOfArray) throws IOException {
        if (state.includeLeaf) {
            return parser.map();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    state.nextField(parser.currentName());
                    break;
                }
                case START_OBJECT: {
                    String fieldName;
                    if (state.includeKey) {
                        fieldName = state.currentFieldName();
                        Map<String, Object> nestedData = XContentFilterKeysUtils.parse(parser, state, isOutsideOfArray);
                        data.put(fieldName, nestedData);
                    } else {
                        parser.skipChildren();
                    }
                    if (!isOutsideOfArray) break;
                    state.previousField();
                    break;
                }
                case START_ARRAY: {
                    String fieldName;
                    if (state.includeKey) {
                        fieldName = state.currentFieldName();
                        List<Object> arrayData = XContentFilterKeysUtils.arrayParsing(parser, state);
                        data.put(fieldName, arrayData);
                    } else {
                        parser.skipChildren();
                    }
                    state.previousField();
                    break;
                }
                case VALUE_STRING: {
                    if (state.includeKey) {
                        data.put(state.currentFieldName(), parser.text());
                    }
                    if (!isOutsideOfArray) break;
                    state.previousField();
                    break;
                }
                case VALUE_NUMBER: {
                    if (state.includeKey) {
                        data.put(state.currentFieldName(), parser.numberValue());
                    }
                    if (!isOutsideOfArray) break;
                    state.previousField();
                    break;
                }
                case VALUE_BOOLEAN: {
                    if (state.includeKey) {
                        data.put(state.currentFieldName(), parser.booleanValue());
                    }
                    if (!isOutsideOfArray) break;
                    state.previousField();
                }
            }
            token = parser.nextToken();
        }
        return data;
    }

    private static List<Object> arrayParsing(XContentParser parser, State state) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            switch (token) {
                case START_OBJECT: {
                    values.add(XContentFilterKeysUtils.parse(parser, state, false));
                    break;
                }
                case VALUE_STRING: {
                    values.add(parser.text());
                    break;
                }
                case VALUE_NUMBER: {
                    values.add(parser.numberValue());
                    break;
                }
                case VALUE_BOOLEAN: {
                    values.add(parser.booleanValue());
                }
            }
            token = parser.nextToken();
        }
        return values;
    }

    private static final class State {
        final List<String> extractPaths;
        StringBuilder currentPath = new StringBuilder();
        boolean includeLeaf;
        boolean includeKey;
        String currentFieldName;

        private State(List<String> extractPaths) {
            this.extractPaths = extractPaths;
        }

        void nextField(String fieldName) {
            this.currentFieldName = fieldName;
            if (this.currentPath.length() != 0) {
                this.currentPath.append('.');
            }
            this.currentPath = this.currentPath.append(fieldName);
            String path = this.currentPath.toString();
            for (String extractPath : this.extractPaths) {
                if (path.equals(extractPath)) {
                    this.includeKey = true;
                    this.includeLeaf = true;
                    return;
                }
                if (!extractPath.startsWith(path)) continue;
                this.includeKey = true;
                return;
            }
            this.includeKey = false;
            this.includeLeaf = false;
        }

        String currentFieldName() {
            return this.currentFieldName;
        }

        void previousField() {
            int start = this.currentPath.lastIndexOf(this.currentFieldName);
            this.currentPath = this.currentPath.delete(start, this.currentPath.length());
            if (this.currentPath.length() > 0 && this.currentPath.charAt(this.currentPath.length() - 1) == '.') {
                this.currentPath = this.currentPath.deleteCharAt(this.currentPath.length() - 1);
            }
            this.currentFieldName = this.currentPath.toString();
            this.includeKey = false;
            this.includeLeaf = false;
        }
    }
}

