/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.xpack.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.ExecutionPhase;
import org.elasticsearch.xpack.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionResult;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionSnapshot;
import org.elasticsearch.xpack.watcher.execution.Wid;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.input.Input;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.joda.time.DateTime;

public abstract class WatchExecutionContext {
    private final Wid id;
    private final Watch watch;
    private final DateTime executionTime;
    private final TriggerEvent triggerEvent;
    private final TimeValue defaultThrottlePeriod;
    private ExecutionPhase phase = ExecutionPhase.AWAITS_EXECUTION;
    private long startTimestamp;
    private Payload payload;
    private Map<String, Object> vars = new HashMap<String, Object>();
    private Input.Result inputResult;
    private Condition.Result conditionResult;
    private Transform.Result transformResult;
    private ConcurrentMap<String, ActionWrapper.Result> actionsResults = ConcurrentCollections.newConcurrentMap();

    public WatchExecutionContext(Watch watch, DateTime executionTime, TriggerEvent triggerEvent, TimeValue defaultThrottlePeriod) {
        this.id = new Wid(watch.id(), executionTime);
        this.watch = watch;
        this.executionTime = executionTime;
        this.triggerEvent = triggerEvent;
        this.defaultThrottlePeriod = defaultThrottlePeriod;
    }

    public abstract boolean knownWatch();

    public abstract boolean simulateAction(String var1);

    public abstract boolean skipThrottling(String var1);

    public abstract boolean recordExecution();

    public Wid id() {
        return this.id;
    }

    public Watch watch() {
        return this.watch;
    }

    public DateTime executionTime() {
        return this.executionTime;
    }

    public TimeValue defaultThrottlePeriod() {
        return this.defaultThrottlePeriod;
    }

    public boolean overrideRecordOnConflict() {
        return false;
    }

    public TriggerEvent triggerEvent() {
        return this.triggerEvent;
    }

    public Payload payload() {
        return this.payload;
    }

    public Map<String, Object> vars() {
        return this.vars;
    }

    public ExecutionPhase executionPhase() {
        return this.phase;
    }

    public void start() {
        assert (this.phase == ExecutionPhase.AWAITS_EXECUTION);
        this.startTimestamp = System.currentTimeMillis();
        this.phase = ExecutionPhase.STARTED;
    }

    public void beforeInput() {
        assert (this.phase == ExecutionPhase.STARTED);
        this.phase = ExecutionPhase.INPUT;
    }

    public void onInputResult(Input.Result inputResult) {
        assert (!this.phase.sealed());
        this.inputResult = inputResult;
        if (inputResult.status() == Input.Result.Status.SUCCESS) {
            this.payload = inputResult.payload();
        }
    }

    public Input.Result inputResult() {
        return this.inputResult;
    }

    public void beforeCondition() {
        assert (this.phase == ExecutionPhase.INPUT);
        this.phase = ExecutionPhase.CONDITION;
    }

    public void onConditionResult(Condition.Result conditionResult) {
        assert (!this.phase.sealed());
        this.conditionResult = conditionResult;
        this.watch.status().onCheck(conditionResult.met(), this.executionTime);
    }

    public Condition.Result conditionResult() {
        return this.conditionResult;
    }

    public void beforeWatchTransform() {
        assert (this.phase == ExecutionPhase.CONDITION);
        this.phase = ExecutionPhase.WATCH_TRANSFORM;
    }

    public void onWatchTransformResult(Transform.Result result) {
        assert (!this.phase.sealed());
        this.transformResult = result;
        if (result.status() == Transform.Result.Status.SUCCESS) {
            this.payload = result.payload();
        }
    }

    public Transform.Result transformResult() {
        return this.transformResult;
    }

    public void beforeActions() {
        assert (this.phase == ExecutionPhase.CONDITION || this.phase == ExecutionPhase.WATCH_TRANSFORM);
        this.phase = ExecutionPhase.ACTIONS;
    }

    public void onActionResult(ActionWrapper.Result result) {
        assert (!this.phase.sealed());
        this.actionsResults.put(result.id(), result);
        this.watch.status().onActionResult(result.id(), this.executionTime, result.action());
    }

    public Map<String, ActionWrapper.Result> actionsResults() {
        return Collections.unmodifiableMap(this.actionsResults);
    }

    public WatchRecord abortBeforeExecution(ExecutionState state, String message) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        return new WatchRecord.MessageWatchRecord(this.id, this.triggerEvent, state, message);
    }

    public WatchRecord abortFailedExecution(String message) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        long executionFinishMs = System.currentTimeMillis();
        WatchExecutionResult result = new WatchExecutionResult(this, executionFinishMs - this.startTimestamp);
        return new WatchRecord.MessageWatchRecord(this, result, message);
    }

    public WatchRecord abortFailedExecution(Exception e) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        long executionFinishMs = System.currentTimeMillis();
        WatchExecutionResult result = new WatchExecutionResult(this, executionFinishMs - this.startTimestamp);
        return new WatchRecord.ExceptionWatchRecord(this, result, e);
    }

    public WatchRecord finish() {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.FINISHED;
        long executionFinishMs = System.currentTimeMillis();
        WatchExecutionResult result = new WatchExecutionResult(this, executionFinishMs - this.startTimestamp);
        return new WatchRecord.MessageWatchRecord(this, result);
    }

    public WatchExecutionSnapshot createSnapshot(Thread executionThread) {
        return new WatchExecutionSnapshot(this, executionThread.getStackTrace());
    }
}

