/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.role.PutRoleRequestBuilder;
import org.elasticsearch.xpack.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class RestPutRoleAction
extends BaseRestHandler {
    public RestPutRoleAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/role/{name}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/role/{name}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/role/{name}", (RestHandler)this, "[POST /_shield/role/{name}] is deprecated! Use [POST /_xpack/security/role/{name}] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_shield/role/{name}", (RestHandler)this, "[PUT /_shield/role/{name}] is deprecated! Use [PUT /_xpack/security/role/{name}] instead.", this.deprecationLogger);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutRoleRequestBuilder requestBuilder = (PutRoleRequestBuilder)new SecurityClient((ElasticsearchClient)client).preparePutRole(request.param("name"), request.content(), request.getXContentType()).setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutRoleResponse>(channel){

            public RestResponse buildResponse(PutRoleResponse putRoleResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("role", (ToXContent)putRoleResponse).endObject());
            }
        });
    }
}

