/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class IndicesStatsResolver
extends MonitoringIndexNameResolver.Timestamped<IndicesStatsMonitoringDoc> {
    public static final String TYPE = "indices_stats";
    static final Set<String> FILTERS;

    public IndicesStatsResolver(MonitoredSystem id, Settings settings) {
        super(id, settings);
    }

    @Override
    public Set<String> filters() {
        return FILTERS;
    }

    @Override
    protected void buildXContent(IndicesStatsMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        IndicesStatsResponse indicesStats = document.getIndicesStats();
        if (indicesStats != null) {
            indicesStats.toXContent(builder, params);
        }
        builder.endObject();
    }

    static {
        HashSet filters = Sets.newHashSet((Object[])new String[]{"cluster_uuid", "timestamp", "source_node", "indices_stats._all.primaries.docs.count", "indices_stats._all.primaries.indexing.index_time_in_millis", "indices_stats._all.primaries.indexing.index_total", "indices_stats._all.primaries.indexing.is_throttled", "indices_stats._all.primaries.indexing.throttle_time_in_millis", "indices_stats._all.primaries.search.query_time_in_millis", "indices_stats._all.primaries.search.query_total", "indices_stats._all.primaries.store.size_in_bytes", "indices_stats._all.total.docs.count", "indices_stats._all.total.indexing.index_time_in_millis", "indices_stats._all.total.indexing.index_total", "indices_stats._all.total.indexing.is_throttled", "indices_stats._all.total.indexing.throttle_time_in_millis", "indices_stats._all.total.search.query_time_in_millis", "indices_stats._all.total.search.query_total", "indices_stats._all.total.store.size_in_bytes"});
        FILTERS = Collections.unmodifiableSet(filters);
    }

    static final class Fields {
        static final String INDICES_STATS = "indices_stats";

        Fields() {
        }
    }
}

