/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class ClusterAlertHttpResource
extends PublishableHttpResource {
    private static final Logger logger = Loggers.getLogger(ClusterAlertHttpResource.class);
    private final XPackLicenseState licenseState;
    private final Supplier<String> watchId;
    private final Supplier<String> watch;

    public ClusterAlertHttpResource(String resourceOwnerName, XPackLicenseState licenseState, Supplier<String> watchId, Supplier<String> watch) {
        super(resourceOwnerName, null, PublishableHttpResource.NO_BODY_PARAMETERS);
        this.licenseState = Objects.requireNonNull(licenseState);
        this.watchId = Objects.requireNonNull(watchId);
        this.watch = Objects.requireNonNull(watch);
    }

    @Override
    protected PublishableHttpResource.CheckResponse doCheck(RestClient client) {
        if (this.licenseState.isMonitoringClusterAlertsAllowed()) {
            return this.simpleCheckForResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster");
        }
        boolean deleted = this.deleteResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster");
        return deleted ? PublishableHttpResource.CheckResponse.EXISTS : PublishableHttpResource.CheckResponse.ERROR;
    }

    @Override
    protected boolean doPublish(RestClient client) {
        return this.putResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), this::watchToHttpEntity, "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster");
    }

    HttpEntity watchToHttpEntity() {
        return new StringEntity(this.watch.get(), ContentType.APPLICATION_JSON);
    }
}

