/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public class MonitoringDoc {
    @Deprecated
    private final String monitoringId;
    @Deprecated
    private final String monitoringVersion;
    private final String type;
    private final String id;
    private final String clusterUUID;
    private final long timestamp;
    private final Node sourceNode;
    private final BytesReference source;
    private final XContentType sourceXContentType;

    protected MonitoringDoc(String monitoringId, String monitoringVersion, String type, @Nullable String id, String clusterUUID, long timestamp, Node node, BytesReference source, XContentType sourceXContentType) {
        this.monitoringId = monitoringId;
        this.monitoringVersion = monitoringVersion;
        this.type = type;
        this.id = Strings.isNullOrEmpty((String)id) ? null : id;
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.sourceNode = node;
        this.source = source;
        this.sourceXContentType = sourceXContentType;
    }

    public MonitoringDoc(String monitoringId, String monitoringVersion, String type, String id, String clusterUUID, long timestamp, Node node) {
        this(monitoringId, monitoringVersion, type, id, clusterUUID, timestamp, node, null, null);
    }

    public MonitoringDoc(String monitoringId, String monitoringVersion, String type, String id, String clusterUUID, long timestamp, DiscoveryNode discoveryNode) {
        this(monitoringId, monitoringVersion, type, id, clusterUUID, timestamp, Node.fromDiscoveryNode(discoveryNode));
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    @Deprecated
    public String getMonitoringId() {
        return this.monitoringId;
    }

    @Deprecated
    public String getMonitoringVersion() {
        return this.monitoringVersion;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.sourceXContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringDoc that = (MonitoringDoc)o;
        return this.timestamp == that.timestamp && Objects.equals(this.monitoringId, that.monitoringId) && Objects.equals(this.monitoringVersion, that.monitoringVersion) && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.clusterUUID, that.clusterUUID) && Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.sourceXContentType, that.sourceXContentType);
    }

    public int hashCode() {
        return Objects.hash(this.monitoringId, this.monitoringVersion, this.type, this.id, this.clusterUUID, this.timestamp, this.sourceNode, this.source, this.sourceXContentType);
    }

    public static class Node
    implements Writeable,
    ToXContent {
        private String uuid;
        private String host;
        private String transportAddress;
        private String ip;
        private String name;
        private Map<String, String> attributes;

        public Node(String uuid, String host, String transportAddress, String ip, String name, Map<String, String> attributes) {
            this.uuid = uuid;
            this.host = host;
            this.transportAddress = transportAddress;
            this.ip = ip;
            this.name = name;
            this.attributes = attributes == null ? new HashMap<String, String>() : Collections.unmodifiableMap(attributes);
        }

        public Node(StreamInput in) throws IOException {
            this.uuid = in.readOptionalString();
            this.host = in.readOptionalString();
            this.transportAddress = in.readOptionalString();
            this.ip = in.readOptionalString();
            this.name = in.readOptionalString();
            int size = in.readVInt();
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                this.attributes.put(in.readString(), in.readString());
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.uuid);
            out.writeOptionalString(this.host);
            out.writeOptionalString(this.transportAddress);
            out.writeOptionalString(this.ip);
            out.writeOptionalString(this.name);
            if (this.attributes != null) {
                out.writeVInt(this.attributes.size());
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    out.writeString(entry.getKey());
                    out.writeString(entry.getValue());
                }
            } else {
                out.writeVInt(0);
            }
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getHost() {
            return this.host;
        }

        public String getTransportAddress() {
            return this.transportAddress;
        }

        public String getIp() {
            return this.ip;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("uuid", this.getUUID());
            builder.field("host", this.getHost());
            builder.field("transport_address", this.getTransportAddress());
            builder.field("ip", this.getIp());
            builder.field("name", this.getName());
            builder.startObject("attributes");
            for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.uuid, node.uuid) && Objects.equals(this.host, node.host) && Objects.equals(this.transportAddress, node.transportAddress) && Objects.equals(this.ip, node.ip) && Objects.equals(this.name, node.name) && Objects.equals(this.attributes, node.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.host, this.transportAddress, this.ip, this.name, this.attributes);
        }

        static Node fromDiscoveryNode(@Nullable DiscoveryNode discoveryNode) {
            Node node = null;
            if (discoveryNode != null) {
                node = new Node(discoveryNode.getId(), discoveryNode.getHostName(), discoveryNode.getAddress().toString(), discoveryNode.getHostAddress(), discoveryNode.getName(), discoveryNode.getAttributes());
            }
            return node;
        }

        static final class Fields {
            static final String UUID = "uuid";
            static final String HOST = "host";
            static final String TRANSPORT_ADDRESS = "transport_address";
            static final String IP = "ip";
            static final String NAME = "name";
            static final String ATTRIBUTES = "attributes";

            Fields() {
            }
        }
    }
}

