/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class IndicesStatsCollector
extends Collector {
    private final Client client;

    public IndicesStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client) {
        super(settings, "indices-stats", clusterService, monitoringSettings, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect() {
        return super.shouldCollect() && this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        IndicesStatsResponse indicesStats = (IndicesStatsResponse)((IndicesStatsRequestBuilder)((IndicesStatsRequestBuilder)this.client.admin().indices().prepareStats(new String[0]).setIndices(this.monitoringSettings.indices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).clear().setDocs(true).setIndexing(true).setSearch(true).setStore(true).get(this.monitoringSettings.indicesStatsTimeout());
        IndicesStatsMonitoringDoc indicesStatsDoc = new IndicesStatsMonitoringDoc(IndicesStatsCollector.monitoringId(), IndicesStatsCollector.monitoringVersion(), this.clusterUUID(), System.currentTimeMillis(), this.localNode(), indicesStats);
        return Collections.singletonList(indicesStatsDoc);
    }
}

