/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.ml.action.util.PageParams;
import org.elasticsearch.xpack.ml.job.config.Job;

public class RestGetCategoriesAction
extends BaseRestHandler {
    public RestGetCategoriesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCategoriesAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String categoryId = restRequest.param(GetCategoriesAction.Request.CATEGORY_ID.getPreferredName());
        BytesReference bodyBytes = restRequest.content();
        if (bodyBytes != null && bodyBytes.length() > 0) {
            XContentParser parser = restRequest.contentParser();
            request = GetCategoriesAction.Request.parseRequest(jobId, parser);
            if (!Strings.isNullOrEmpty((String)categoryId)) {
                request.setCategoryId(categoryId);
            }
        } else {
            request = new GetCategoriesAction.Request(jobId);
            if (!Strings.isNullOrEmpty((String)categoryId)) {
                request.setCategoryId(categoryId);
            }
            if (restRequest.hasParam(GetCategoriesAction.Request.FROM.getPreferredName()) || restRequest.hasParam(GetCategoriesAction.Request.SIZE.getPreferredName()) || Strings.isNullOrEmpty((String)categoryId)) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(GetCategoriesAction.Request.FROM.getPreferredName(), 0), restRequest.paramAsInt(GetCategoriesAction.Request.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((Action)GetCategoriesAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

