/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.bulk.byscroll.DeleteByQueryRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.common.action.XPackDeleteByQueryAction;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class ExpiredResultsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = Loggers.getLogger(ExpiredResultsRemover.class);
    private final Client client;
    private final Auditor auditor;

    public ExpiredResultsRemover(Client client, ClusterService clusterService, Auditor auditor) {
        super(clusterService);
        this.client = Objects.requireNonNull(client);
        this.auditor = Objects.requireNonNull(auditor);
    }

    @Override
    protected Long getRetentionDays(Job job) {
        return job.getResultsRetentionDays();
    }

    @Override
    protected void removeDataBefore(final Job job, final long cutoffEpochMs, final Runnable onFinish) {
        LOGGER.info("Removing results of job [{}] that have a timestamp before [{}]", (Object)job.getId(), (Object)cutoffEpochMs);
        DeleteByQueryRequest request = this.createDBQRequest(job, cutoffEpochMs);
        this.client.execute((Action)XPackDeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    ExpiredResultsRemover.this.auditResultsWereDeleted(job.getId(), cutoffEpochMs);
                    onFinish.run();
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Failed to remove expired results for job [" + job.getId() + "]", (Throwable)e);
                onFinish.run();
            }
        });
    }

    private DeleteByQueryRequest createDBQRequest(Job job, long cutoffEpochMs) {
        SearchRequest searchRequest = new SearchRequest();
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        request.setSlices(5);
        searchRequest.indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName(job.getId())});
        searchRequest.types(new String[]{Result.TYPE.getPreferredName()});
        TermQueryBuilder excludeFilter = QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats");
        BoolQueryBuilder query = ExpiredResultsRemover.createQuery(job.getId(), cutoffEpochMs).mustNot((QueryBuilder)excludeFilter);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        return request;
    }

    private void auditResultsWereDeleted(String jobId, long cutoffEpochMs) {
        Instant instant = Instant.ofEpochMilli(cutoffEpochMs);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneOffset.systemDefault());
        String formatted = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
        String msg = Messages.getMessage("Deleted results prior to {1}", formatted);
        this.auditor.info(jobId, msg);
    }
}

