/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class PerPartitionMaxProbabilities
extends ToXContentToBytes
implements Writeable {
    public static final String RESULT_TYPE_VALUE = "partition_normalized_probs";
    public static final ParseField PER_PARTITION_MAX_PROBABILITIES = new ParseField("per_partition_max_probabilities", new String[0]);
    public static final ParseField MAX_RECORD_SCORE = new ParseField("max_record_score", new String[0]);
    public static final ConstructingObjectParser<PerPartitionMaxProbabilities, Void> PARSER = new ConstructingObjectParser("partition_normalized_probs", a -> new PerPartitionMaxProbabilities((String)a[0], (Date)a[1], (Long)a[2], (List)a[3]));
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private final List<PartitionProbability> perPartitionMaxProbabilities;

    public PerPartitionMaxProbabilities(String jobId, Date timestamp, long bucketSpan, List<PartitionProbability> partitionProbabilities) {
        this.jobId = jobId;
        this.timestamp = timestamp;
        this.bucketSpan = bucketSpan;
        this.perPartitionMaxProbabilities = partitionProbabilities;
    }

    public PerPartitionMaxProbabilities(List<AnomalyRecord> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException("PerPartitionMaxProbabilities cannot be created from an empty list of records");
        }
        this.jobId = records.get(0).getJobId();
        this.timestamp = records.get(0).getTimestamp();
        this.bucketSpan = records.get(0).getBucketSpan();
        this.perPartitionMaxProbabilities = this.calcMaxRecordScorePerPartition(records);
    }

    public PerPartitionMaxProbabilities(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.bucketSpan = in.readLong();
        this.perPartitionMaxProbabilities = in.readList(PartitionProbability::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.timestamp.getTime());
        out.writeLong(this.bucketSpan);
        out.writeList(this.perPartitionMaxProbabilities);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_" + this.timestamp.getTime() + "_" + this.bucketSpan + "_" + RESULT_TYPE_VALUE;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<PartitionProbability> getPerPartitionMaxProbabilities() {
        return this.perPartitionMaxProbabilities;
    }

    public double getMaxProbabilityForPartition(String partitionValue) {
        Optional<PartitionProbability> first = this.perPartitionMaxProbabilities.stream().filter(pp -> partitionValue.equals(pp.getPartitionValue())).findFirst();
        return first.isPresent() ? first.get().getMaxRecordScore() : 0.0;
    }

    private List<PartitionProbability> calcMaxRecordScorePerPartition(List<AnomalyRecord> anomalyRecords) {
        Map<String, Double> maxValueByPartition = anomalyRecords.stream().collect(Collectors.groupingBy(AnomalyRecord::getPartitionFieldValue, Collector.of(() -> new DoubleMaxBox(), (m, ar) -> m.accept(ar.getRecordScore()), DoubleMaxBox::combine, DoubleMaxBox::value, new Collector.Characteristics[0])));
        ArrayList<PartitionProbability> pProbs = new ArrayList<PartitionProbability>();
        for (Map.Entry<String, Double> entry : maxValueByPartition.entrySet()) {
            pProbs.add(new PartitionProbability(entry.getKey(), entry.getValue()));
        }
        return pProbs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.dateField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(Bucket.BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(PER_PARTITION_MAX_PROBABILITIES.getPreferredName(), this.perPartitionMaxProbabilities);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.perPartitionMaxProbabilities, this.bucketSpan);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PerPartitionMaxProbabilities)) {
            return false;
        }
        PerPartitionMaxProbabilities that = (PerPartitionMaxProbabilities)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.bucketSpan == that.bucketSpan && Objects.equals(this.perPartitionMaxProbabilities, that.perPartitionMaxProbabilities);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + Result.TIMESTAMP.getPreferredName() + "]");
        }, Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), Bucket.BUCKET_SPAN);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), PartitionProbability.PARSER, PER_PARTITION_MAX_PROBABILITIES);
        PARSER.declareString((p, s) -> {}, Result.RESULT_TYPE);
    }

    public static class PartitionProbability
    extends ToXContentToBytes
    implements Writeable {
        public static final ConstructingObjectParser<PartitionProbability, Void> PARSER = new ConstructingObjectParser("partitionProbability", a -> new PartitionProbability((String)a[0], (Double)a[1]));
        private final String partitionValue;
        private final double maxRecordScore;

        PartitionProbability(String partitionName, double maxRecordScore) {
            this.partitionValue = partitionName;
            this.maxRecordScore = maxRecordScore;
        }

        public PartitionProbability(StreamInput in) throws IOException {
            this.partitionValue = in.readString();
            this.maxRecordScore = in.readDouble();
        }

        public String getPartitionValue() {
            return this.partitionValue;
        }

        public double getMaxRecordScore() {
            return this.maxRecordScore;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.partitionValue);
            out.writeDouble(this.maxRecordScore);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), this.partitionValue).field(MAX_RECORD_SCORE.getPreferredName(), this.maxRecordScore).endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.partitionValue, this.maxRecordScore);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PartitionProbability)) {
                return false;
            }
            PartitionProbability that = (PartitionProbability)((Object)other);
            return Objects.equals(this.partitionValue, that.partitionValue) && this.maxRecordScore == that.maxRecordScore;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), AnomalyRecord.PARTITION_FIELD_VALUE);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), MAX_RECORD_SCORE);
        }
    }

    private final class DoubleMaxBox {
        private double value = 0.0;

        DoubleMaxBox() {
        }

        public void accept(double d) {
            if (d > this.value) {
                this.value = d;
            }
        }

        public DoubleMaxBox combine(DoubleMaxBox other) {
            return this.value > other.value ? this : other;
        }

        public Double value() {
            return this.value;
        }
    }
}

