/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.BatchedDocumentsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobRenormalizedResultsPersister;
import org.elasticsearch.xpack.ml.job.process.normalizer.BucketNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.InfluencerNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizer;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.RecordNormalizable;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.PerPartitionMaxProbabilities;

public class ScoresUpdater {
    private static final Logger LOGGER = Loggers.getLogger(ScoresUpdater.class);
    private static final int TARGET_RECORDS_TO_RENORMALIZE = 100000;
    private static final long DEFAULT_RENORMALIZATION_WINDOW_MS = 2592000000L;
    private static final int DEFAULT_BUCKETS_IN_RENORMALIZATION_WINDOW = 100;
    private static final long SECONDS_IN_DAY = 86400L;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private final Job job;
    private final JobProvider jobProvider;
    private final JobRenormalizedResultsPersister updatesPersister;
    private final NormalizerFactory normalizerFactory;
    private int bucketSpan;
    private long normalizationWindow;
    private boolean perPartitionNormalization;

    public ScoresUpdater(Job job, JobProvider jobProvider, JobRenormalizedResultsPersister jobRenormalizedResultsPersister, NormalizerFactory normalizerFactory) {
        this.job = job;
        this.jobProvider = Objects.requireNonNull(jobProvider);
        this.updatesPersister = Objects.requireNonNull(jobRenormalizedResultsPersister);
        this.normalizerFactory = Objects.requireNonNull(normalizerFactory);
        this.bucketSpan = Long.valueOf(job.getAnalysisConfig().getBucketSpan().seconds()).intValue();
        this.normalizationWindow = this.getNormalizationWindowOrDefault(job);
        this.perPartitionNormalization = ScoresUpdater.getPerPartitionNormalizationOrDefault(job.getAnalysisConfig());
    }

    private long getNormalizationWindowOrDefault(Job job) {
        if (job.getRenormalizationWindowDays() != null) {
            return job.getRenormalizationWindowDays() * 86400L * 1000L;
        }
        return Math.max(2592000000L, (long)(100 * this.bucketSpan) * 1000L);
    }

    private static boolean getPerPartitionNormalizationOrDefault(AnalysisConfig analysisConfig) {
        return analysisConfig != null && analysisConfig.getUsePerPartitionNormalization();
    }

    public void update(String quantilesState, long endBucketEpochMs, long windowExtensionMs, boolean perPartitionNormalization) {
        Normalizer normalizer = this.normalizerFactory.create(this.job.getId());
        int[] counts = new int[]{0, 0};
        this.updateBuckets(normalizer, quantilesState, endBucketEpochMs, windowExtensionMs, counts, perPartitionNormalization);
        this.updateInfluencers(normalizer, quantilesState, endBucketEpochMs, windowExtensionMs, counts);
        LOGGER.debug("[{}] Normalization resulted in: {} updates, {} no-ops", (Object)this.job.getId(), (Object)counts[0], (Object)counts[1]);
    }

    private void updateBuckets(Normalizer normalizer, String quantilesState, long endBucketEpochMs, long windowExtensionMs, int[] counts, boolean perPartitionNormalization) {
        Deque<BatchedResultsIterator.ResultWithIndex<Bucket>> buckets;
        BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<Bucket>> bucketsIterator = this.jobProvider.newBatchedBucketsIterator(this.job.getId()).timeRange(this.calcNormalizationWindowStart(endBucketEpochMs, windowExtensionMs), endBucketEpochMs);
        ArrayList<BucketNormalizable> bucketsToRenormalize = new ArrayList<BucketNormalizable>();
        int batchRecordCount = 0;
        int skipped = 0;
        while (bucketsIterator.hasNext() && !(buckets = bucketsIterator.next()).isEmpty()) {
            while (!buckets.isEmpty()) {
                BatchedResultsIterator.ResultWithIndex<Bucket> current = buckets.removeFirst();
                Bucket currentBucket = (Bucket)((Object)current.result);
                if (currentBucket.isNormalizable()) {
                    BucketNormalizable bucketNormalizable = new BucketNormalizable((Bucket)((Object)current.result), current.indexName);
                    List<RecordNormalizable> recordNormalizables = this.bucketRecordsAsNormalizables(currentBucket.getTimestamp().getTime());
                    batchRecordCount += recordNormalizables.size();
                    bucketNormalizable.setRecords(recordNormalizables);
                    bucketsToRenormalize.add(bucketNormalizable);
                } else {
                    ++skipped;
                }
                if (batchRecordCount < 100000) continue;
                this.normalizeBuckets(normalizer, bucketsToRenormalize, quantilesState, batchRecordCount, skipped, counts, perPartitionNormalization);
                bucketsToRenormalize = new ArrayList();
                batchRecordCount = 0;
                skipped = 0;
            }
        }
        if (!bucketsToRenormalize.isEmpty()) {
            this.normalizeBuckets(normalizer, bucketsToRenormalize, quantilesState, batchRecordCount, skipped, counts, perPartitionNormalization);
        }
    }

    private List<RecordNormalizable> bucketRecordsAsNormalizables(long bucketTimeStamp) {
        BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<AnomalyRecord>> recordsIterator = this.jobProvider.newBatchedRecordsIterator(this.job.getId()).timeRange(bucketTimeStamp, bucketTimeStamp + 1L);
        ArrayList<RecordNormalizable> recordNormalizables = new ArrayList<RecordNormalizable>();
        while (recordsIterator.hasNext()) {
            for (BatchedResultsIterator.ResultWithIndex<AnomalyRecord> record : recordsIterator.next()) {
                recordNormalizables.add(new RecordNormalizable((AnomalyRecord)((Object)record.result), record.indexName));
            }
        }
        return recordNormalizables;
    }

    private long calcNormalizationWindowStart(long endEpochMs, long windowExtensionMs) {
        return Math.max(0L, endEpochMs - this.normalizationWindow - windowExtensionMs);
    }

    private void normalizeBuckets(Normalizer normalizer, List<BucketNormalizable> normalizableBuckets, String quantilesState, int recordCount, int skipped, int[] counts, boolean perPartitionNormalization) {
        LOGGER.debug("[{}] Will renormalize a batch of {} buckets with {} records ({} empty buckets skipped)", (Object)this.job.getId(), (Object)normalizableBuckets.size(), (Object)recordCount, (Object)skipped);
        List<Normalizable> asNormalizables = normalizableBuckets.stream().map(Function.identity()).collect(Collectors.toList());
        normalizer.normalize(this.bucketSpan, perPartitionNormalization, asNormalizables, quantilesState);
        for (BucketNormalizable bn : normalizableBuckets) {
            this.updateSingleBucket(counts, bn);
        }
        this.updatesPersister.executeRequest(this.job.getId());
    }

    private void updateSingleBucket(int[] counts, BucketNormalizable bucketNormalizable) {
        if (bucketNormalizable.hadBigNormalizedUpdate()) {
            if (this.perPartitionNormalization) {
                List<AnomalyRecord> anomalyRecords = bucketNormalizable.getRecords().stream().map(RecordNormalizable::getRecord).collect(Collectors.toList());
                PerPartitionMaxProbabilities ppProbs = new PerPartitionMaxProbabilities(anomalyRecords);
                this.updatesPersister.updateResult(ppProbs.getId(), bucketNormalizable.getOriginatingIndex(), (ToXContent)ppProbs);
            }
            this.updatesPersister.updateBucket(bucketNormalizable);
            counts[0] = counts[0] + 1;
        } else {
            counts[1] = counts[1] + 1;
        }
        this.persistChanged(counts, bucketNormalizable.getRecords());
    }

    private void updateInfluencers(Normalizer normalizer, String quantilesState, long endBucketEpochMs, long windowExtensionMs, int[] counts) {
        BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<Influencer>> influencersIterator = this.jobProvider.newBatchedInfluencersIterator(this.job.getId()).timeRange(this.calcNormalizationWindowStart(endBucketEpochMs, windowExtensionMs), endBucketEpochMs);
        while (influencersIterator.hasNext()) {
            Deque<BatchedResultsIterator.ResultWithIndex<Influencer>> influencers = influencersIterator.next();
            if (influencers.isEmpty()) {
                LOGGER.debug("[{}] No influencers to renormalize for job", (Object)this.job.getId());
                break;
            }
            LOGGER.debug("[{}] Will renormalize a batch of {} influencers", (Object)this.job.getId(), (Object)influencers.size());
            List<Normalizable> asNormalizables = influencers.stream().map(influencerResultIndex -> new InfluencerNormalizable((Influencer)((Object)((Object)influencerResultIndex.result)), influencerResultIndex.indexName)).collect(Collectors.toList());
            normalizer.normalize(this.bucketSpan, this.perPartitionNormalization, asNormalizables, quantilesState);
            this.persistChanged(counts, asNormalizables);
        }
        this.updatesPersister.executeRequest(this.job.getId());
    }

    private void persistChanged(int[] counts, List<? extends Normalizable> asNormalizables) {
        List<Normalizable> toUpdate = asNormalizables.stream().filter(n -> n.hadBigNormalizedUpdate()).collect(Collectors.toList());
        counts[0] = counts[0] + toUpdate.size();
        counts[1] = counts[1] + (asNormalizables.size() - toUpdate.size());
        if (!toUpdate.isEmpty()) {
            this.updatesPersister.updateResults(toUpdate);
        }
    }
}

