/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CsvDataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DataToProcessWriter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.JsonDataToProcessWriter;

public final class DataToProcessWriterFactory {
    private DataToProcessWriterFactory() {
    }

    public static DataToProcessWriter create(boolean includeControlField, AutodetectProcess autodetectProcess, DataDescription dataDescription, AnalysisConfig analysisConfig, DataCountsReporter dataCountsReporter, NamedXContentRegistry xContentRegistry) {
        switch (dataDescription.getFormat()) {
            case XCONTENT: {
                return new JsonDataToProcessWriter(includeControlField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter, xContentRegistry);
            }
            case DELIMITED: {
                return new CsvDataToProcessWriter(includeControlField, autodetectProcess, dataDescription, analysisConfig, dataCountsReporter);
            }
        }
        throw new IllegalArgumentException();
    }
}

