/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class ModelSnapshot
extends ToXContentToBytes
implements Writeable {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
    public static final ParseField SNAPSHOT_DOC_COUNT = new ParseField("snapshot_doc_count", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_time_stamp", new String[0]);
    public static final ParseField LATEST_RESULT_TIME = new ParseField("latest_result_time_stamp", new String[0]);
    public static final ParseField RETAIN = new ParseField("retain", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("model_snapshots", new String[0]);
    public static final ParseField TYPE = new ParseField("model_snapshot", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(TYPE.getPreferredName(), Builder::new);
    private final String jobId;
    private final Date timestamp;
    private final String description;
    private final String snapshotId;
    private final int snapshotDocCount;
    private final ModelSizeStats modelSizeStats;
    private final Date latestRecordTimeStamp;
    private final Date latestResultTimeStamp;
    private final Quantiles quantiles;
    private final boolean retain;

    private ModelSnapshot(String jobId, Date timestamp, String description, String snapshotId, int snapshotDocCount, ModelSizeStats modelSizeStats, Date latestRecordTimeStamp, Date latestResultTimeStamp, Quantiles quantiles, boolean retain) {
        this.jobId = jobId;
        this.timestamp = timestamp;
        this.description = description;
        this.snapshotId = snapshotId;
        this.snapshotDocCount = snapshotDocCount;
        this.modelSizeStats = modelSizeStats;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.latestResultTimeStamp = latestResultTimeStamp;
        this.quantiles = quantiles;
        this.retain = retain;
    }

    public ModelSnapshot(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.description = in.readOptionalString();
        this.snapshotId = in.readOptionalString();
        this.snapshotDocCount = in.readInt();
        this.modelSizeStats = (ModelSizeStats)in.readOptionalWriteable(ModelSizeStats::new);
        this.latestRecordTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.latestResultTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.quantiles = (Quantiles)in.readOptionalWriteable(Quantiles::new);
        this.retain = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        if (this.timestamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.timestamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.snapshotId);
        out.writeInt(this.snapshotDocCount);
        out.writeOptionalWriteable((Writeable)this.modelSizeStats);
        if (this.latestRecordTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestRecordTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.latestResultTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestResultTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.quantiles);
        out.writeBoolean(this.retain);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.timestamp != null) {
            builder.dateField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.snapshotId != null) {
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        }
        builder.field(SNAPSHOT_DOC_COUNT.getPreferredName(), this.snapshotDocCount);
        if (this.modelSizeStats != null) {
            builder.field(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName(), (ToXContent)this.modelSizeStats);
        }
        if (this.latestRecordTimeStamp != null) {
            builder.dateField(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.latestResultTimeStamp != null) {
            builder.dateField(LATEST_RESULT_TIME.getPreferredName(), LATEST_RESULT_TIME.getPreferredName() + "_string", this.latestResultTimeStamp.getTime());
        }
        if (this.quantiles != null) {
            builder.field(Quantiles.TYPE.getPreferredName(), (ToXContent)this.quantiles);
        }
        builder.field(RETAIN.getPreferredName(), this.retain);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getSnapshotDocCount() {
        return this.snapshotDocCount;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public Date getLatestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.timestamp, this.description, this.snapshotId, this.quantiles, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.retain});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSnapshot)) {
            return false;
        }
        ModelSnapshot that = (ModelSnapshot)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.description, that.description) && Objects.equals(this.snapshotId, that.snapshotId) && this.snapshotDocCount == that.snapshotDocCount && Objects.equals((Object)this.modelSizeStats, (Object)that.modelSizeStats) && Objects.equals((Object)this.quantiles, (Object)that.quantiles) && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.latestResultTimeStamp, that.latestResultTimeStamp) && this.retain == that.retain;
    }

    public static String documentId(ModelSnapshot snapshot) {
        return ModelSnapshot.documentId(snapshot.getJobId(), snapshot.getSnapshotId());
    }

    public static String documentId(String jobId, String snapshotId) {
        return jobId + "-" + snapshotId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModelSnapshot fromJson(BytesReference bytesReference) {
        try (XContentParser parser = XContentFactory.xContent((BytesReference)bytesReference).createParser(NamedXContentRegistry.EMPTY, bytesReference);){
            ModelSnapshot modelSnapshot = ((Builder)PARSER.apply(parser, null)).build();
            return modelSnapshot;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse modelSnapshot", (Throwable)e, new Object[0]);
        }
    }

    static {
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareField(Builder::setTimestamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + TIMESTAMP.getPreferredName() + "]");
        }, TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareString(Builder::setDescription, DESCRIPTION);
        PARSER.declareString(Builder::setSnapshotId, SNAPSHOT_ID);
        PARSER.declareInt(Builder::setSnapshotDocCount, SNAPSHOT_DOC_COUNT);
        PARSER.declareObject(Builder::setModelSizeStats, ModelSizeStats.PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        PARSER.declareField(Builder::setLatestRecordTimeStamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LATEST_RECORD_TIME.getPreferredName() + "]");
        }, LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setLatestResultTimeStamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LATEST_RESULT_TIME.getPreferredName() + "]");
        }, LATEST_RESULT_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(Builder::setQuantiles, Quantiles.PARSER, Quantiles.TYPE);
        PARSER.declareBoolean(Builder::setRetain, RETAIN);
    }

    public static class Builder {
        private String jobId;
        private Date timestamp;
        private String description;
        private String snapshotId;
        private int snapshotDocCount;
        private ModelSizeStats modelSizeStats;
        private Date latestRecordTimeStamp;
        private Date latestResultTimeStamp;
        private Quantiles quantiles;
        private boolean retain;

        public Builder() {
        }

        public Builder(String jobId) {
            this();
            this.jobId = jobId;
        }

        public Builder(ModelSnapshot modelSnapshot) {
            this.jobId = modelSnapshot.jobId;
            this.timestamp = modelSnapshot.timestamp;
            this.description = modelSnapshot.description;
            this.snapshotId = modelSnapshot.snapshotId;
            this.snapshotDocCount = modelSnapshot.snapshotDocCount;
            this.modelSizeStats = modelSnapshot.modelSizeStats;
            this.latestRecordTimeStamp = modelSnapshot.latestRecordTimeStamp;
            this.latestResultTimeStamp = modelSnapshot.latestResultTimeStamp;
            this.quantiles = modelSnapshot.quantiles;
            this.retain = modelSnapshot.retain;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setSnapshotDocCount(int snapshotDocCount) {
            this.snapshotDocCount = snapshotDocCount;
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats.Builder modelSizeStats) {
            this.modelSizeStats = modelSizeStats.build();
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats modelSizeStats) {
            this.modelSizeStats = modelSizeStats;
            return this;
        }

        public Builder setLatestRecordTimeStamp(Date latestRecordTimeStamp) {
            this.latestRecordTimeStamp = latestRecordTimeStamp;
            return this;
        }

        public Builder setLatestResultTimeStamp(Date latestResultTimeStamp) {
            this.latestResultTimeStamp = latestResultTimeStamp;
            return this;
        }

        public Builder setQuantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Builder setRetain(boolean value) {
            this.retain = value;
            return this;
        }

        public ModelSnapshot build() {
            return new ModelSnapshot(this.jobId, this.timestamp, this.description, this.snapshotId, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.quantiles, this.retain);
        }
    }
}

