/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.action.PutJobAction;
import org.elasticsearch.xpack.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushListener;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.process.normalizer.Renormalizer;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.PerPartitionMaxProbabilities;

public class AutoDetectResultProcessor {
    private static final Logger LOGGER = Loggers.getLogger(AutoDetectResultProcessor.class);
    private final Client client;
    private final String jobId;
    private final Renormalizer renormalizer;
    private final JobResultsPersister persister;
    final CountDownLatch completionLatch = new CountDownLatch(1);
    final Semaphore updateModelSnapshotIdSemaphore = new Semaphore(1);
    private final FlushListener flushListener;
    private volatile ModelSizeStats latestModelSizeStats;

    public AutoDetectResultProcessor(Client client, String jobId, Renormalizer renormalizer, JobResultsPersister persister, ModelSizeStats latestModelSizeStats) {
        this(client, jobId, renormalizer, persister, latestModelSizeStats, new FlushListener());
    }

    AutoDetectResultProcessor(Client client, String jobId, Renormalizer renormalizer, JobResultsPersister persister, ModelSizeStats latestModelSizeStats, FlushListener flushListener) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
        this.renormalizer = Objects.requireNonNull(renormalizer);
        this.persister = Objects.requireNonNull(persister);
        this.flushListener = Objects.requireNonNull(flushListener);
        this.latestModelSizeStats = Objects.requireNonNull(latestModelSizeStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(AutodetectProcess process, boolean isPerPartitionNormalization) {
        Context context = new Context(this.jobId, isPerPartitionNormalization, this.persister.bulkPersisterBuilder(this.jobId));
        try {
            int bucketCount = 0;
            Iterator<AutodetectResult> iterator = process.readAutodetectResults();
            while (iterator.hasNext()) {
                try {
                    AutodetectResult result = iterator.next();
                    this.processResult(context, result);
                    if (result.getBucket() == null) continue;
                    LOGGER.trace("[{}] Bucket number {} parsed from output", (Object)this.jobId, (Object)(++bucketCount));
                }
                catch (Exception e) {
                    LOGGER.warn((Message)new ParameterizedMessage("[{}] Error processing autodetect result", (Object)this.jobId), (Throwable)e);
                }
            }
            try {
                context.bulkResultsPersister.executeRequest();
            }
            catch (Exception e) {
                LOGGER.warn((Message)new ParameterizedMessage("[{}] Error persisting autodetect results", (Object)this.jobId), (Throwable)e);
            }
            LOGGER.info("[{}] {} buckets parsed from autodetect output", (Object)this.jobId, (Object)bucketCount);
            return;
        }
        catch (Exception e) {
            LOGGER.error((Message)new ParameterizedMessage("[{}] error parsing autodetect output", (Object)this.jobId), (Throwable)e);
            return;
        }
        finally {
            try {
                this.waitUntilRenormalizerIsIdle();
                this.persister.commitResultWrites(this.jobId);
                this.persister.commitStateWrites(this.jobId);
            }
            catch (IndexNotFoundException e) {
                LOGGER.error("[{}] Error while closing: no such index [{}]", (Object)this.jobId, (Object)e.getIndex().getName());
            }
            finally {
                this.flushListener.clear();
                this.completionLatch.countDown();
            }
        }
    }

    void processResult(Context context, AutodetectResult result) {
        FlushAcknowledgement flushAcknowledgement;
        Quantiles quantiles;
        ModelSnapshot modelSnapshot;
        ModelSizeStats modelSizeStats;
        ModelPlot modelPlot;
        CategoryDefinition categoryDefinition;
        List<Influencer> influencers;
        List<AnomalyRecord> records;
        Bucket bucket = result.getBucket();
        if (bucket != null) {
            if (context.deleteInterimRequired) {
                LOGGER.trace("[{}] Deleting interim results", (Object)context.jobId);
                this.persister.deleteInterimResults(context.jobId);
                context.deleteInterimRequired = false;
            }
            context.bulkResultsPersister.persistBucket(bucket).executeRequest();
        }
        if ((records = result.getRecords()) != null && !records.isEmpty()) {
            context.bulkResultsPersister.persistRecords(records);
            if (context.isPerPartitionNormalization) {
                context.bulkResultsPersister.persistPerPartitionMaxProbabilities(new PerPartitionMaxProbabilities(records));
            }
        }
        if ((influencers = result.getInfluencers()) != null && !influencers.isEmpty()) {
            context.bulkResultsPersister.persistInfluencers(influencers);
        }
        if ((categoryDefinition = result.getCategoryDefinition()) != null) {
            this.persister.persistCategoryDefinition(categoryDefinition);
        }
        if ((modelPlot = result.getModelPlot()) != null) {
            this.persister.persistModelPlot(modelPlot);
        }
        if ((modelSizeStats = result.getModelSizeStats()) != null) {
            LOGGER.trace("[{}] Parsed ModelSizeStats: {} / {} / {} / {} / {} / {}", (Object)context.jobId, (Object)modelSizeStats.getModelBytes(), (Object)modelSizeStats.getTotalByFieldCount(), (Object)modelSizeStats.getTotalOverFieldCount(), (Object)modelSizeStats.getTotalPartitionFieldCount(), (Object)modelSizeStats.getBucketAllocationFailuresCount(), (Object)modelSizeStats.getMemoryStatus());
            this.latestModelSizeStats = modelSizeStats;
            this.persister.persistModelSizeStats(modelSizeStats);
        }
        if ((modelSnapshot = result.getModelSnapshot()) != null) {
            this.persister.persistModelSnapshot(modelSnapshot);
            this.updateModelSnapshotIdOnJob(modelSnapshot);
        }
        if ((quantiles = result.getQuantiles()) != null) {
            this.persister.persistQuantiles(quantiles);
            context.bulkResultsPersister.executeRequest();
            this.persister.commitResultWrites(context.jobId);
            LOGGER.debug("[{}] Quantiles parsed from output - will trigger renormalization of scores", (Object)context.jobId);
            this.renormalizer.renormalize(quantiles);
        }
        if ((flushAcknowledgement = result.getFlushAcknowledgement()) != null) {
            LOGGER.debug("[{}] Flush acknowledgement parsed from output for ID {}", (Object)context.jobId, (Object)flushAcknowledgement.getId());
            context.bulkResultsPersister.executeRequest();
            this.persister.commitResultWrites(context.jobId);
            this.flushListener.acknowledgeFlush(flushAcknowledgement.getId());
            context.deleteInterimRequired = true;
        }
    }

    protected void updateModelSnapshotIdOnJob(final ModelSnapshot modelSnapshot) {
        JobUpdate update = new JobUpdate.Builder(this.jobId).setModelSnapshotId(modelSnapshot.getSnapshotId()).build();
        UpdateJobAction.Request updateRequest = new UpdateJobAction.Request(this.jobId, update);
        try {
            this.updateModelSnapshotIdSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("[{}] Interrupted acquiring update model snapshot semaphore", (Object)this.jobId);
            return;
        }
        this.client.execute((Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)new ActionListener<PutJobAction.Response>(){

            public void onResponse(PutJobAction.Response response) {
                AutoDetectResultProcessor.this.updateModelSnapshotIdSemaphore.release();
                LOGGER.debug("[{}] Updated job with model snapshot id [{}]", (Object)AutoDetectResultProcessor.this.jobId, (Object)modelSnapshot.getSnapshotId());
            }

            public void onFailure(Exception e) {
                AutoDetectResultProcessor.this.updateModelSnapshotIdSemaphore.release();
                LOGGER.error("[" + AutoDetectResultProcessor.this.jobId + "] Failed to update job with new model snapshot id [" + modelSnapshot.getSnapshotId() + "]", (Throwable)e);
            }
        });
    }

    public void awaitCompletion() throws TimeoutException {
        try {
            if (!this.completionLatch.await(MachineLearning.STATE_PERSIST_RESTORE_TIMEOUT.getMinutes(), TimeUnit.MINUTES)) {
                throw new TimeoutException("Timed out waiting for results processor to complete for job " + this.jobId);
            }
            this.updateModelSnapshotIdSemaphore.acquire();
            this.updateModelSnapshotIdSemaphore.release();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("[{}] Interrupted waiting for results processor to complete", (Object)this.jobId);
        }
    }

    public boolean waitForFlushAcknowledgement(String flushId, Duration timeout) {
        return this.flushListener.waitForFlush(flushId, timeout);
    }

    public void clearAwaitingFlush(String flushId) {
        this.flushListener.clear(flushId);
    }

    public void waitUntilRenormalizerIsIdle() {
        this.renormalizer.waitUntilIdle();
    }

    public ModelSizeStats modelSizeStats() {
        return this.latestModelSizeStats;
    }

    static class Context {
        private final String jobId;
        private final boolean isPerPartitionNormalization;
        private JobResultsPersister.Builder bulkResultsPersister;
        boolean deleteInterimRequired;

        Context(String jobId, boolean isPerPartitionNormalization, JobResultsPersister.Builder bulkResultsPersister) {
            this.jobId = jobId;
            this.isPerPartitionNormalization = isPerPartitionNormalization;
            this.deleteInterimRequired = true;
            this.bulkResultsPersister = bulkResultsPersister;
        }
    }
}

