/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ml.job.process.ProcessPipes;
import org.elasticsearch.xpack.ml.job.process.logging.CppLogMessageHandler;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeController {
    private static final Logger LOGGER = Loggers.getLogger(NativeController.class);
    private static final Duration CONTROLLER_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private static final String START_COMMAND = "start";
    public static final Map<String, Object> UNKNOWN_NATIVE_CODE_INFO;
    private final CppLogMessageHandler cppLogHandler;
    private final OutputStream commandStream;
    private Thread logTailThread;

    NativeController(Environment env, NamedPipeHelper namedPipeHelper) throws IOException {
        ProcessPipes processPipes = new ProcessPipes(env, namedPipeHelper, "controller", null, true, true, false, false, false, false);
        processPipes.connectStreams(CONTROLLER_CONNECT_TIMEOUT);
        this.cppLogHandler = new CppLogMessageHandler(null, processPipes.getLogStream().get());
        this.commandStream = processPipes.getCommandStream().get();
    }

    void tailLogsInThread() {
        this.logTailThread = new Thread(() -> {
            try {
                this.cppLogHandler.tailStream();
                this.cppLogHandler.close();
            }
            catch (IOException e) {
                LOGGER.error("Error tailing C++ controller logs", (Throwable)e);
            }
            LOGGER.info("Native controller process has stopped - no new native processes can be started");
        });
        this.logTailThread.start();
    }

    public long getPid() throws TimeoutException {
        return this.cppLogHandler.getPid(CONTROLLER_CONNECT_TIMEOUT);
    }

    public Map<String, Object> getNativeCodeInfo() throws TimeoutException {
        String copyrightMessage = this.cppLogHandler.getCppCopyright(CONTROLLER_CONNECT_TIMEOUT);
        Matcher matcher = Pattern.compile("Version (.+) \\(Build ([^)]+)\\) Copyright ").matcher(copyrightMessage);
        if (matcher.find()) {
            HashMap<String, Object> info = new HashMap<String, Object>(2);
            info.put("version", matcher.group(1));
            info.put("build_hash", matcher.group(2));
            return info;
        }
        String msg = "Unexpected native controller process copyright format: " + copyrightMessage;
        LOGGER.error(msg);
        throw new ElasticsearchException(msg, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(List<String> command) throws IOException {
        for (String arg : command) {
            if (arg.contains("\t")) {
                throw new IllegalArgumentException("argument contains a tab character: " + arg + " in " + command);
            }
            if (!arg.contains("\n")) continue;
            throw new IllegalArgumentException("argument contains a newline character: " + arg + " in " + command);
        }
        OutputStream outputStream = this.commandStream;
        synchronized (outputStream) {
            LOGGER.debug("Starting process with command: " + command);
            this.commandStream.write(START_COMMAND.getBytes(StandardCharsets.UTF_8));
            for (String arg : command) {
                this.commandStream.write(9);
                this.commandStream.write(arg.getBytes(StandardCharsets.UTF_8));
            }
            this.commandStream.write(10);
        }
    }

    public void stop() throws IOException {
        this.commandStream.close();
    }

    static {
        HashMap<String, String> unknownInfo = new HashMap<String, String>(2);
        unknownInfo.put("version", "N/A");
        unknownInfo.put("build_hash", "N/A");
        UNKNOWN_NATIVE_CODE_INFO = Collections.unmodifiableMap(unknownInfo);
    }
}

