/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.bulk.byscroll.DeleteByQueryRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.common.action.XPackDeleteByQueryAction;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;

public class JobStorageDeletionTask
extends Task {
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());

    public JobStorageDeletionTask(long id, String type, String action, String description, TaskId parentTask) {
        super(id, type, action, description, parentTask);
    }

    public void delete(String jobId, Client client, ClusterState state, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        String indexName = AnomalyDetectorsIndex.getPhysicalIndexFromState(state, jobId);
        String indexPattern = indexName + "-*";
        String aliasName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        ActionListener deleteAliasHandler = ActionListener.wrap(finishedHandler, failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                this.logger.warn("[{}] DeleteByQuery for indices [{}, {}] timed out.", (Object)jobId, (Object)indexName, (Object)indexPattern);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                this.logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}, {}].", (Object)jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)indexName, (Object)indexPattern);
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    this.logger.warn("DBQ failure: " + failure);
                }
            }
            this.deleteAlias(jobId, aliasName, indexName, client, (ActionListener<Boolean>)deleteAliasHandler);
        }, failureHandler);
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> {
            this.logger.info("Running DBQ on [" + indexName + "," + indexPattern + "] for job [" + jobId + "]");
            SearchRequest searchRequest = new SearchRequest(new String[]{indexName, indexPattern});
            DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
            ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
            searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
            searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
            request.setSlices(5);
            request.setAbortOnVersionConflict(false);
            request.setRefresh(true);
            client.execute((Action)XPackDeleteByQueryAction.INSTANCE, (ActionRequest)request, dbqHandler);
        }, failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(jobId, client, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(jobId, client, (ActionListener<DeleteResponse>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(jobId, client, (ActionListener<BulkResponse>)deleteStateHandler);
    }

    private void deleteQuantiles(String jobId, Client client, ActionListener<DeleteResponse> finishedHandler) {
        client.prepareDelete(AnomalyDetectorsIndex.jobStateIndexName(), Quantiles.TYPE.getPreferredName(), Quantiles.documentId(jobId)).execute(finishedHandler);
    }

    private void deleteModelState(String jobId, Client client, ActionListener<BulkResponse> listener) {
        JobProvider jobProvider = new JobProvider(client, Settings.EMPTY);
        jobProvider.modelSnapshots(jobId, 0, 10000, page -> {
            List deleteCandidates = page.results();
            JobDataDeleter deleter = new JobDataDeleter(client, jobId);
            for (ModelSnapshot deleteCandidate : deleteCandidates) {
                deleter.deleteModelSnapshot(deleteCandidate);
            }
            deleter.commit(listener, true);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteCategorizerState(final String jobId, Client client, final ActionListener<Boolean> finishedHandler) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        request.setSlices(5);
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        WildcardQueryBuilder query = new WildcardQueryBuilder("_uid", Uid.createUid((String)"categorizer_state", (String)(jobId + "#*")));
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        client.execute((Action)XPackDeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                finishedHandler.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                JobStorageDeletionTask.this.logger.error("[" + jobId + "] Failed to delete categorizer state for job.", (Throwable)e);
                finishedHandler.onFailure(e);
            }
        });
    }

    private void deleteAlias(String jobId, String aliasName, String indexName, Client client, ActionListener<Boolean> finishedHandler) {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().alias(aliasName).index(indexName));
        client.admin().indices().aliases(request, ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), e -> {
            if (e instanceof AliasesNotFoundException || e instanceof IndexNotFoundException) {
                this.logger.warn("[{}] Alias [{}] not found. Continuing to delete job.", (Object)jobId, (Object)aliasName);
                finishedHandler.onResponse((Object)true);
            } else {
                this.logger.error("[" + jobId + "] Failed to delete alias [" + aliasName + "].", (Throwable)e);
                finishedHandler.onFailure(e);
            }
        }));
    }
}

