/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.BatchedBucketsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedDocumentsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedInfluencersIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedRecordsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.ml.job.persistence.InfluencersQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.RecordsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.security.support.Exceptions;

public class JobProvider {
    private static final Logger LOGGER = Loggers.getLogger(JobProvider.class);
    private static final List<String> SECONDARY_SORT = Arrays.asList(AnomalyRecord.RECORD_SCORE.getPreferredName(), AnomalyRecord.OVER_FIELD_VALUE.getPreferredName(), AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), AnomalyRecord.BY_FIELD_VALUE.getPreferredName(), AnomalyRecord.FIELD_NAME.getPreferredName(), AnomalyRecord.FUNCTION.getPreferredName());
    private static final int RECORDS_SIZE_PARAM = 10000;
    private final Client client;
    private final Settings settings;

    public JobProvider(Client client, Settings settings) {
        this.client = Objects.requireNonNull(client);
        this.settings = settings;
    }

    public void createJobResultIndex(Job job, ClusterState state, ActionListener<Boolean> finalListener) {
        List<String> termFields = job.getAnalysisConfig() != null ? job.getAnalysisConfig().termFields() : Collections.emptyList();
        String aliasName = AnomalyDetectorsIndex.jobResultsAliasedName(job.getId());
        String indexName = job.getResultsIndexName();
        ActionListener createAliasListener = ActionListener.wrap(success -> this.client.admin().indices().prepareAliases().addAlias(indexName, aliasName, (QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).execute(ActionListener.wrap(r -> finalListener.onResponse((Object)true), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        if (!state.getMetaData().hasIndex(indexName)) {
            LOGGER.trace("ES API CALL: create index {}", (Object)indexName);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            String type = Result.TYPE.getPreferredName();
            createIndexRequest.mapping(type, ElasticsearchMappings.termFieldsMapping(type, termFields));
            this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)r.isAcknowledged()), e -> {
                if (e instanceof ResourceAlreadyExistsException) {
                    LOGGER.info("Index already exists");
                    createAliasListener.onResponse((Object)true);
                } else {
                    finalListener.onFailure(e);
                }
            }));
        } else {
            long fieldCountLimit = (Long)MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.get(this.settings);
            if (JobProvider.violatedFieldCountLimit(indexName, termFields.size(), fieldCountLimit, state)) {
                String message = "Cannot create job in index '" + indexName + "' as the " + MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey() + " setting will be violated";
                finalListener.onFailure((Exception)new IllegalArgumentException(message));
            } else {
                this.updateIndexMappingWithTermFields(indexName, termFields, (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> ((ActionListener)createAliasListener).onResponse(arg_0), arg_0 -> finalListener.onFailure(arg_0)));
            }
        }
    }

    static boolean violatedFieldCountLimit(String indexName, long additionalFieldCount, long fieldCountLimit, ClusterState clusterState) {
        long numFields = 0L;
        IndexMetaData indexMetaData = clusterState.metaData().index(indexName);
        Iterator mappings = indexMetaData.getMappings().valuesIt();
        while (mappings.hasNext()) {
            MappingMetaData mapping = (MappingMetaData)mappings.next();
            try {
                numFields += (long)JobProvider.countFields(mapping.sourceAsMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return numFields + additionalFieldCount > fieldCountLimit;
    }

    static int countFields(Map<String, Object> mapping) {
        Object propertiesNode = mapping.get("properties");
        if (propertiesNode == null || !(propertiesNode instanceof Map)) {
            return 0;
        }
        mapping = (Map)propertiesNode;
        int count = 0;
        for (Map.Entry entry : mapping.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map fieldMapping = (Map)entry.getValue();
                count += JobProvider.countFields(fieldMapping);
            }
            ++count;
        }
        return count;
    }

    private void updateIndexMappingWithTermFields(String indexName, Collection<String> termFields, final ActionListener<Boolean> listener) {
        this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType(Result.TYPE.getPreferredName()).setSource(ElasticsearchMappings.termFieldsMapping(null, termFields)).execute((ActionListener)new ActionListener<PutMappingResponse>(){

            public void onResponse(PutMappingResponse putMappingResponse) {
                listener.onResponse((Object)putMappingResponse.isAcknowledged());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void dataCounts(String jobId, Consumer<DataCounts> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        this.get(indexName, DataCounts.TYPE.getPreferredName(), DataCounts.documentId(jobId), handler, errorHandler, (BiFunction)DataCounts.PARSER, () -> new DataCounts(jobId));
    }

    public void getAutodetectParams(Job job, Consumer<AutodetectParams> consumer, Consumer<Exception> errorHandler) {
        AutodetectParams.Builder paramsBuilder = new AutodetectParams.Builder(job.getId());
        String jobId = job.getId();
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        String stateIndex = AnomalyDetectorsIndex.jobStateIndexName();
        MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(this.createDocIdSearch(resultsIndex, DataCounts.TYPE.getPreferredName(), DataCounts.documentId(jobId))).add(this.createDocIdSearch(resultsIndex, Result.TYPE.getPreferredName(), ModelSizeStats.documentId(jobId))).add(this.createDocIdSearch(resultsIndex, ModelSnapshot.TYPE.getPreferredName(), ModelSnapshot.documentId(jobId, job.getModelSnapshotId()))).add(this.createDocIdSearch(stateIndex, Quantiles.TYPE.getPreferredName(), Quantiles.documentId(jobId)));
        for (String filterId : job.getAnalysisConfig().extractReferencedFilters()) {
            msearch.add(this.createDocIdSearch(".ml-meta", MlFilter.TYPE.getPreferredName(), filterId));
        }
        msearch.execute(ActionListener.wrap(response -> {
            for (int i = 0; i < response.getResponses().length; ++i) {
                MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                if (itemResponse.isFailure()) {
                    errorHandler.accept(itemResponse.getFailure());
                    continue;
                }
                SearchResponse searchResponse = itemResponse.getResponse();
                Object[] shardFailures = searchResponse.getShardFailures();
                int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
                if (shardFailures != null && shardFailures.length > 0) {
                    LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
                    errorHandler.accept((Exception)new ElasticsearchException(ExceptionsHelper.shardFailuresToErrorMsg(jobId, (ShardSearchFailure[])shardFailures), new Object[0]));
                    continue;
                }
                if (unavailableShards > 0) {
                    errorHandler.accept((Exception)new ElasticsearchException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards", new Object[0]));
                    continue;
                }
                SearchHits hits = searchResponse.getHits();
                long totalHits = hits.getTotalHits();
                if (totalHits == 0L) {
                    SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                    LOGGER.debug("Found 0 hits for [{}/{}]", (Object)searchRequest.indices(), (Object)searchRequest.types());
                    continue;
                }
                if (totalHits == 1L) {
                    this.parseAutodetectParamSearchHit(paramsBuilder, hits.getAt(0), errorHandler);
                    continue;
                }
                if (totalHits <= 1L) continue;
                errorHandler.accept(new IllegalStateException("Expected total hits 0 or 1, but got [" + totalHits + "] total hits"));
            }
            consumer.accept(paramsBuilder.build());
        }, errorHandler));
    }

    private SearchRequestBuilder createDocIdSearch(String index, String type, String id) {
        return this.client.prepareSearch(new String[]{index}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{type}).addIds(new String[]{id})).setRouting(id);
    }

    private void parseAutodetectParamSearchHit(AutodetectParams.Builder paramsBuilder, SearchHit hit, Consumer<Exception> errorHandler) {
        String type = hit.getType();
        if (DataCounts.TYPE.getPreferredName().equals(type)) {
            paramsBuilder.setDataCounts((DataCounts)((Object)this.parseSearchHit(hit, (BiFunction)DataCounts.PARSER, errorHandler)));
        } else if (Result.TYPE.getPreferredName().equals(type)) {
            ModelSizeStats.Builder modelSizeStats = (ModelSizeStats.Builder)this.parseSearchHit(hit, (BiFunction)ModelSizeStats.PARSER, errorHandler);
            paramsBuilder.setModelSizeStats(modelSizeStats == null ? null : modelSizeStats.build());
        } else if (ModelSnapshot.TYPE.getPreferredName().equals(type)) {
            ModelSnapshot.Builder modelSnapshot = (ModelSnapshot.Builder)this.parseSearchHit(hit, (BiFunction)ModelSnapshot.PARSER, errorHandler);
            paramsBuilder.setModelSnapshot(modelSnapshot == null ? null : modelSnapshot.build());
        } else if (Quantiles.TYPE.getPreferredName().equals(type)) {
            paramsBuilder.setQuantiles((Quantiles)((Object)this.parseSearchHit(hit, (BiFunction)Quantiles.PARSER, errorHandler)));
        } else if (MlFilter.TYPE.getPreferredName().equals(type)) {
            paramsBuilder.addFilter((MlFilter)((Object)this.parseSearchHit(hit, (BiFunction)MlFilter.PARSER, errorHandler)));
        } else {
            errorHandler.accept(new IllegalStateException("Unexpected type [" + type + "]"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, U> T parseSearchHit(SearchHit hit, BiFunction<XContentParser, U, T> objectParser, Consumer<Exception> errorHandler) {
        BytesReference source = hit.getSourceRef();
        try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
            XContentParser t = objectParser.apply(parser, null);
            return (T)t;
        }
        catch (IOException e) {
            errorHandler.accept((Exception)new ElasticsearchParseException("failed to parse " + hit.getType(), (Throwable)e, new Object[0]));
            return null;
        }
    }

    private <T, U> void get(String indexName, String type, String id, Consumer<T> handler, Consumer<Exception> errorHandler, BiFunction<XContentParser, U, T> objectParser, Supplier<T> notFoundSupplier) {
        GetRequest getRequest = new GetRequest(indexName, type, id);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (!response.isExists()) {
                handler.accept(notFoundSupplier.get());
            } else {
                BytesReference source = response.getSourceAsBytesRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    handler.accept(objectParser.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse " + type, (Throwable)e, new Object[0]);
                }
            }
        }, error -> {
            if (!(error instanceof IndexNotFoundException)) {
                errorHandler.accept((Exception)error);
            } else {
                handler.accept(notFoundSupplier.get());
            }
        }));
    }

    public static IndicesOptions addIgnoreUnavailable(IndicesOptions indicesOptions) {
        return IndicesOptions.fromOptions((boolean)true, (boolean)indicesOptions.allowNoIndices(), (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed(), (IndicesOptions)indicesOptions);
    }

    public void bucketsViaInternalClient(String jobId, BucketsQueryBuilder.BucketsQuery query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler) throws ResourceNotFoundException {
        this.buckets(jobId, query, handler, errorHandler, this.client);
    }

    public void buckets(String jobId, BucketsQueryBuilder.BucketsQuery query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) throws ResourceNotFoundException {
        ResultsFilterBuilder rfb = new ResultsFilterBuilder();
        if (query.getTimestamp() != null) {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), query.getTimestamp());
        } else {
            rfb.timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Bucket.ANOMALY_SCORE.getPreferredName(), query.getAnomalyScoreFilter()).interim(Bucket.IS_INTERIM.getPreferredName(), query.isIncludeInterim());
        }
        SortBuilder sortBuilder = new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        BoolQueryBuilder boolQuery = new BoolQueryBuilder().filter(rfb.build()).filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"bucket"));
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{Result.TYPE.getPreferredName()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.from(query.getFrom());
        searchSourceBuilder.size(query.getSize());
        searchRequest.source(searchSourceBuilder);
        MultiSearchRequest mrequest = new MultiSearchRequest();
        mrequest.indicesOptions(JobProvider.addIgnoreUnavailable(mrequest.indicesOptions()));
        mrequest.add(searchRequest);
        if (Strings.hasLength((String)query.getPartitionValue())) {
            mrequest.add(this.createPartitionMaxNormailizedProbabilitiesRequest(jobId, query.getStart(), query.getEnd(), query.getPartitionValue()));
        }
        client.multiSearch(mrequest, ActionListener.wrap(mresponse -> {
            MultiSearchResponse.Item item1 = mresponse.getResponses()[0];
            if (item1.isFailure()) {
                errorHandler.accept(JobProvider.mapAuthFailure(item1.getFailure(), jobId, "cluster:monitor/xpack/ml/job/results/buckets/get"));
                return;
            }
            SearchResponse searchResponse = item1.getResponse();
            SearchHits hits = searchResponse.getHits();
            if (query.getTimestamp() != null) {
                if (hits.getTotalHits() == 0L) {
                    throw QueryPage.emptyQueryPage(Bucket.RESULTS_FIELD);
                }
                if (hits.getTotalHits() > 1L) {
                    LOGGER.error("Found more than one bucket with timestamp [{}] from index {}", (Object)query.getTimestamp(), (Object)indexName);
                }
            }
            ArrayList<Bucket> results = new ArrayList<Bucket>();
            for (SearchHit hit : hits.getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    Bucket bucket2 = (Bucket)((Object)((Object)Bucket.PARSER.apply(parser, null)));
                    if (!query.isIncludeInterim() && bucket2.isInterim()) continue;
                    results.add(bucket2);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
                }
            }
            if (query.getTimestamp() != null && results.isEmpty()) {
                throw QueryPage.emptyQueryPage(Bucket.RESULTS_FIELD);
            }
            QueryPage<Bucket> buckets = new QueryPage<Bucket>(results, searchResponse.getHits().getTotalHits(), Bucket.RESULTS_FIELD);
            if (Strings.hasLength((String)query.getPartitionValue())) {
                MultiSearchResponse.Item item2 = mresponse.getResponses()[1];
                if (item2.isFailure()) {
                    errorHandler.accept(item2.getFailure());
                    return;
                }
                if (query.isExpand()) {
                    Iterator<Bucket> bucketsToExpand = buckets.results().stream().filter(bucket -> bucket.getRecordCount() > 0).iterator();
                    this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
                    return;
                }
            } else if (query.isExpand()) {
                Iterator<Bucket> bucketsToExpand = buckets.results().stream().filter(bucket -> bucket.getRecordCount() > 0).iterator();
                this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
                return;
            }
            handler.accept(buckets);
        }, errorHandler));
    }

    private void expandBuckets(String jobId, BucketsQueryBuilder.BucketsQuery query, QueryPage<Bucket> buckets, Iterator<Bucket> bucketsToExpand, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) {
        if (bucketsToExpand.hasNext()) {
            Consumer<Integer> c = i -> this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
            this.expandBucket(jobId, query.isIncludeInterim(), bucketsToExpand.next(), query.getPartitionValue(), c, errorHandler, client);
        } else {
            handler.accept(buckets);
        }
    }

    private SearchRequest createPartitionMaxNormailizedProbabilitiesRequest(String jobId, Object epochStart, Object epochEnd, String partitionFieldValue) {
        QueryBuilder timeRangeQuery = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), epochStart, epochEnd).build();
        BoolQueryBuilder boolQuery = new BoolQueryBuilder().filter(timeRangeQuery).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"partition_normalized_probs"})).filter((QueryBuilder)new TermsQueryBuilder(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), new String[]{partitionFieldValue}));
        FieldSortBuilder sb = (FieldSortBuilder)new FieldSortBuilder(Result.TIMESTAMP.getPreferredName()).order(SortOrder.ASC);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.sort((SortBuilder)sb);
        sourceBuilder.query((QueryBuilder)boolQuery);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        return searchRequest;
    }

    public BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<Bucket>> newBatchedBucketsIterator(String jobId) {
        return new BatchedBucketsIterator(this.client, jobId);
    }

    public BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<AnomalyRecord>> newBatchedRecordsIterator(String jobId) {
        return new BatchedRecordsIterator(this.client, jobId);
    }

    public void expandBucket(String jobId, boolean includeInterim, Bucket bucket, String partitionFieldValue, Consumer<Integer> consumer, Consumer<Exception> errorHandler, Client client) {
        Consumer<QueryPage<AnomalyRecord>> h = page -> {
            bucket.getRecords().addAll(page.results());
            if (partitionFieldValue != null) {
                bucket.setAnomalyScore(bucket.partitionAnomalyScore(partitionFieldValue));
            }
            consumer.accept(bucket.getRecords().size());
        };
        this.bucketRecords(jobId, bucket, 0, 10000, includeInterim, AnomalyRecord.PROBABILITY.getPreferredName(), false, partitionFieldValue, h, errorHandler, client);
    }

    void bucketRecords(String jobId, Bucket bucket, int from, int size, boolean includeInterim, String sortField, boolean descending, String partitionFieldValue, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        TermQueryBuilder recordFilter = QueryBuilders.termQuery((String)Result.TIMESTAMP.getPreferredName(), (long)bucket.getTimestamp().getTime());
        ResultsFilterBuilder builder = new ResultsFilterBuilder((QueryBuilder)recordFilter).interim(AnomalyRecord.IS_INTERIM.getPreferredName(), includeInterim);
        if (partitionFieldValue != null) {
            builder.term(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), partitionFieldValue);
        }
        recordFilter = builder.build();
        FieldSortBuilder sb = null;
        if (sortField != null) {
            sb = (FieldSortBuilder)new FieldSortBuilder(sortField).missing((Object)"_last").order(descending ? SortOrder.DESC : SortOrder.ASC);
        }
        this.records(jobId, from, size, (QueryBuilder)recordFilter, sb, SECONDARY_SORT, descending, handler, errorHandler, client);
    }

    public void categoryDefinitions(String jobId, String categoryId, Integer from, Integer size, Consumer<QueryPage<CategoryDefinition>> handler, Consumer<Exception> errorHandler, Client client) {
        if (categoryId != null && (from != null || size != null)) {
            throw new IllegalStateException("Both categoryId and pageParams are specified");
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search all of type {} from index {} sort ascending {} from {} size {}", (Object)CategoryDefinition.TYPE.getPreferredName(), (Object)indexName, (Object)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (categoryId != null) {
            String documentId = CategoryDefinition.documentId(jobId, categoryId);
            String uid = Uid.createUid((String)CategoryDefinition.TYPE.getPreferredName(), (String)documentId);
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_uid", (String)uid));
            searchRequest.routing(documentId);
        } else if (from != null && size != null) {
            searchRequest.types(new String[]{CategoryDefinition.TYPE.getPreferredName()});
            sourceBuilder.from(from.intValue()).size(size.intValue()).sort(new FieldSortBuilder(CategoryDefinition.CATEGORY_ID.getPreferredName()).order(SortOrder.ASC));
        } else {
            throw new IllegalStateException("Both categoryId and pageParams are not specified");
        }
        searchRequest.source(sourceBuilder);
        client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            SearchHit[] hits = searchResponse.getHits().getHits();
            ArrayList<CategoryDefinition> results = new ArrayList<CategoryDefinition>(hits.length);
            for (SearchHit hit : hits) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    CategoryDefinition categoryDefinition = (CategoryDefinition)((Object)((Object)CategoryDefinition.PARSER.apply(parser, null)));
                    results.add(categoryDefinition);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse category definition", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits(), CategoryDefinition.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/categories/get"))));
    }

    public void records(String jobId, RecordsQueryBuilder.RecordsQuery query, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(AnomalyRecord.RECORD_SCORE.getPreferredName(), query.getRecordScoreThreshold()).interim(AnomalyRecord.IS_INTERIM.getPreferredName(), query.isIncludeInterim()).term(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), query.getPartitionFieldValue()).build();
        FieldSortBuilder sb = null;
        if (query.getSortField() != null) {
            sb = (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).missing((Object)"_last").order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        }
        this.records(jobId, query.getFrom(), query.getSize(), fb, sb, SECONDARY_SORT, query.isSortDescending(), handler, errorHandler, client);
    }

    private void records(String jobId, int from, int size, QueryBuilder recordFilter, FieldSortBuilder sb, List<String> secondarySort, boolean descending, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        recordFilter = new BoolQueryBuilder().filter(recordFilter).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"record"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.types(new String[]{Result.TYPE.getPreferredName()});
        searchRequest.source(new SearchSourceBuilder().from(from).size(size).query(recordFilter).sort((SortBuilder)(sb == null ? SortBuilders.fieldSort((String)"_doc") : sb)).fetchSource(true));
        for (String sortField : secondarySort) {
            searchRequest.source().sort(sortField, descending ? SortOrder.DESC : SortOrder.ASC);
        }
        LOGGER.trace("ES API CALL: search all of result type {} from index {}{}{} with filter after sort from {} size {}", (Object)"record", (Object)indexName, (Object)(sb != null ? " with sort" : ""), (Object)(secondarySort.isEmpty() ? "" : " with secondary sort"), (Object)from, (Object)size);
        client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            ArrayList<Object> results = new ArrayList<Object>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    results.add(AnomalyRecord.PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse records", (Throwable)e, new Object[0]);
                }
            }
            QueryPage queryPage = new QueryPage(results, searchResponse.getHits().getTotalHits(), AnomalyRecord.RESULTS_FIELD);
            handler.accept(queryPage);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/records/get"))));
    }

    public void influencers(String jobId, InfluencersQueryBuilder.InfluencersQuery query, Consumer<QueryPage<Influencer>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Influencer.INFLUENCER_SCORE.getPreferredName(), query.getInfluencerScoreFilter()).interim(Bucket.IS_INTERIM.getPreferredName(), query.isIncludeInterim()).build();
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[5];
        supplierArray[0] = () -> "influencer";
        supplierArray[1] = () -> indexName;
        supplierArray[2] = () -> query.getSortField() != null ? " with sort " + (query.isSortDescending() ? "descending" : "ascending") + " on field " + query.getSortField() : "";
        supplierArray[3] = query::getFrom;
        supplierArray[4] = query::getSize;
        LOGGER.trace("ES API CALL: search all of result type {} from index {}{}  with filter from {} size {}", supplierArray);
        BoolQueryBuilder qb = new BoolQueryBuilder().filter(fb).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"influencer"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.types(new String[]{Result.TYPE.getPreferredName()});
        FieldSortBuilder sb = query.getSortField() == null ? SortBuilders.fieldSort((String)"_doc") : (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)qb).from(query.getFrom()).size(query.getSize()).sort((SortBuilder)sb));
        client.search(searchRequest, ActionListener.wrap(response -> {
            ArrayList<Object> influencers = new ArrayList<Object>();
            for (SearchHit hit : response.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                    influencers.add(Influencer.PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse influencer", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(influencers, response.getHits().getTotalHits(), Influencer.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/influencers/get"))));
    }

    public BatchedDocumentsIterator<BatchedResultsIterator.ResultWithIndex<Influencer>> newBatchedInfluencersIterator(String jobId) {
        return new BatchedInfluencersIterator(this.client, jobId);
    }

    public void getModelSnapshot(String jobId, @Nullable String modelSnapshotId, Consumer<ModelSnapshot> handler, Consumer<Exception> errorHandler) {
        if (modelSnapshotId == null) {
            handler.accept(null);
            return;
        }
        this.get(AnomalyDetectorsIndex.jobResultsAliasedName(jobId), ModelSnapshot.TYPE.getPreferredName(), ModelSnapshot.documentId(jobId, modelSnapshotId), handler, errorHandler, (parser, context) -> ((ModelSnapshot.Builder)ModelSnapshot.PARSER.apply(parser, null)).build(), () -> null);
    }

    public void modelSnapshots(String jobId, int from, int size, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        this.modelSnapshots(jobId, from, size, null, true, (QueryBuilder)QueryBuilders.matchAllQuery(), handler, errorHandler);
    }

    public void modelSnapshots(String jobId, int from, int size, String startEpochMs, String endEpochMs, String sortField, boolean sortDescending, String snapshotId, String description, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        ResultsFilterBuilder fb;
        boolean haveDescription;
        boolean haveId = snapshotId != null && !snapshotId.isEmpty();
        boolean bl = haveDescription = description != null && !description.isEmpty();
        if (haveId || haveDescription) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            if (haveId) {
                query.filter((QueryBuilder)QueryBuilders.termQuery((String)ModelSnapshot.SNAPSHOT_ID.getPreferredName(), (String)snapshotId));
            }
            if (haveDescription) {
                query.filter((QueryBuilder)QueryBuilders.termQuery((String)ModelSnapshot.DESCRIPTION.getPreferredName(), (String)description));
            }
            fb = new ResultsFilterBuilder((QueryBuilder)query);
        } else {
            fb = new ResultsFilterBuilder();
        }
        QueryBuilder qb = fb.timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs).build();
        this.modelSnapshots(jobId, from, size, sortField, sortDescending, qb, handler, errorHandler);
    }

    private void modelSnapshots(String jobId, int from, int size, String sortField, boolean sortDescending, QueryBuilder qb, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (Strings.isEmpty((CharSequence)sortField)) {
            sortField = ModelSnapshot.TIMESTAMP.getPreferredName();
        }
        FieldSortBuilder sb = (FieldSortBuilder)new FieldSortBuilder(sortField).order(sortDescending ? SortOrder.DESC : SortOrder.ASC);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search all of type {} from index {} sort ascending {} with filter after sort from {} size {}", (Object)ModelSnapshot.TYPE, (Object)indexName, (Object)sortField, (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.types(new String[]{ModelSnapshot.TYPE.getPreferredName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.sort((SortBuilder)sb);
        sourceBuilder.query(qb);
        sourceBuilder.from(from);
        sourceBuilder.size(size);
        searchRequest.source(sourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            ArrayList<ModelSnapshot> results = new ArrayList<ModelSnapshot>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                results.add(ModelSnapshot.fromJson(hit.getSourceRef()));
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits(), ModelSnapshot.RESULTS_FIELD);
            handler.accept(result);
        }, errorHandler));
    }

    public void restoreStateToStream(String jobId, ModelSnapshot modelSnapshot, OutputStream restoreStream) throws IOException {
        GetResponse stateResponse;
        String docId;
        int docNum;
        String indexName = AnomalyDetectorsIndex.jobStateIndexName();
        int numDocs = modelSnapshot.getSnapshotDocCount();
        for (docNum = 1; docNum <= numDocs; ++docNum) {
            docId = String.format(Locale.ROOT, "%s#%d", ModelSnapshot.documentId(modelSnapshot), docNum);
            LOGGER.trace("ES API CALL: get ID {} type {} from index {}", (Object)docId, (Object)ModelState.TYPE, (Object)indexName);
            stateResponse = (GetResponse)this.client.prepareGet(indexName, ModelState.TYPE.getPreferredName(), docId).get();
            if (!stateResponse.isExists()) {
                LOGGER.error("Expected {} documents for model state for {} snapshot {} but failed to find {}", (Object)numDocs, (Object)jobId, (Object)modelSnapshot.getSnapshotId(), (Object)docId);
                break;
            }
            this.writeStateToStream(stateResponse.getSourceAsBytesRef(), restoreStream);
        }
        docNum = 0;
        while (true) {
            docId = CategorizerState.categorizerStateDocId(jobId, ++docNum);
            LOGGER.trace("ES API CALL: get ID {} type {} from index {}", (Object)docId, (Object)"categorizer_state", (Object)indexName);
            stateResponse = (GetResponse)this.client.prepareGet(indexName, "categorizer_state", docId).get();
            if (!stateResponse.isExists()) break;
            this.writeStateToStream(stateResponse.getSourceAsBytesRef(), restoreStream);
        }
    }

    private void writeStateToStream(BytesReference source, OutputStream stream) throws IOException {
        BytesRefIterator iterator = source.iterator();
        BytesRef ref = iterator.next();
        while (ref != null) {
            int length;
            for (length = ref.bytes.length; length > 0 && ref.bytes[length - 1] == 0; --length) {
            }
            if (length > 0) {
                stream.write(ref.bytes, 0, length);
            }
            ref = iterator.next();
        }
        stream.write(0);
    }

    public QueryPage<ModelPlot> modelPlot(String jobId, int from, int size) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        LOGGER.trace("ES API CALL: search result type {} from index {} from {}, size {}", (Object)"model_plot", (Object)indexName, (Object)from, (Object)size);
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setIndicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).setTypes(new String[]{Result.TYPE.getPreferredName()}).setQuery((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_plot"})).setFrom(from).setSize(size).get();
        ArrayList<ModelPlot> results = new ArrayList<ModelPlot>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            BytesReference source = hit.getSourceRef();
            try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);){
                ModelPlot modelPlot = (ModelPlot)((Object)ModelPlot.PARSER.apply(parser, null));
                results.add(modelPlot);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse modelPlot", (Throwable)e, new Object[0]);
            }
        }
        return new QueryPage<ModelPlot>(results, searchResponse.getHits().getTotalHits(), ModelPlot.RESULTS_FIELD);
    }

    public void modelSizeStats(String jobId, Consumer<ModelSizeStats> handler, Consumer<Exception> errorHandler) {
        LOGGER.trace("ES API CALL: get result type {} ID {} for job {}", (Object)"model_size_stats", (Object)ModelSizeStats.RESULT_TYPE_FIELD, (Object)jobId);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        this.get(indexName, Result.TYPE.getPreferredName(), ModelSizeStats.documentId(jobId), handler, errorHandler, (parser, context) -> ((ModelSizeStats.Builder)ModelSizeStats.PARSER.apply(parser, null)).build(), () -> {
            LOGGER.trace("No memory usage details for job with id {}", (Object)jobId);
            return new ModelSizeStats.Builder(jobId).build();
        });
    }

    static Exception mapAuthFailure(Exception e, String jobId, String mappedActionName) {
        if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).status() == RestStatus.FORBIDDEN) {
            e = Exceptions.authorizationError(e.getMessage().replaceFirst("action \\[.*?\\]", "action [" + mappedActionName + "]") + " for job [{}]", jobId);
        }
        return e;
    }
}

