/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Result;

public class JobDataDeleter {
    private static final Logger LOGGER = Loggers.getLogger(JobDataDeleter.class);
    private static final int SCROLL_SIZE = 1000;
    private static final String SCROLL_CONTEXT_DURATION = "5m";
    private final Client client;
    private final String jobId;
    private final BulkRequestBuilder bulkRequestBuilder;
    private long deletedResultCount;
    private long deletedModelSnapshotCount;
    private long deletedModelStateCount;
    private boolean quiet;

    public JobDataDeleter(Client client, String jobId) {
        this(client, jobId, false);
    }

    public JobDataDeleter(Client client, String jobId, boolean quiet) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
        this.bulkRequestBuilder = client.prepareBulk();
        this.deletedResultCount = 0L;
        this.deletedModelSnapshotCount = 0L;
        this.deletedModelStateCount = 0L;
        this.quiet = quiet;
    }

    public void deleteResultsFromTime(long cutoffEpochMs, ActionListener<Boolean> listener) {
        String index = AnomalyDetectorsIndex.jobResultsAliasedName(this.jobId);
        RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName());
        timeRange.gte((Object)cutoffEpochMs);
        RepeatingSearchScrollListener scrollSearchListener = new RepeatingSearchScrollListener(index, listener);
        this.client.prepareSearch(new String[]{index}).setTypes(new String[]{Result.TYPE.getPreferredName()}).setFetchSource(false).setQuery((QueryBuilder)timeRange).setScroll(SCROLL_CONTEXT_DURATION).setSize(1000).execute((ActionListener)scrollSearchListener);
    }

    private void addDeleteRequestForSearchHits(SearchHits hits, String index) {
        for (SearchHit hit : hits.hits()) {
            LOGGER.trace("Search hit for result: {}", (Object)hit.getId());
            this.addDeleteRequest(hit, index);
        }
        this.deletedResultCount = hits.getTotalHits();
    }

    private void addDeleteRequest(SearchHit hit, String index) {
        DeleteRequestBuilder deleteRequest = ((DeleteRequestBuilder)DeleteAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.client).setIndex(index)).setType(hit.getType()).setId(hit.getId());
        this.bulkRequestBuilder.add(deleteRequest);
    }

    public void deleteModelSnapshot(ModelSnapshot modelSnapshot) {
        String snapshotDocId = ModelSnapshot.documentId(modelSnapshot);
        int docCount = modelSnapshot.getSnapshotDocCount();
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexName();
        for (int i = 1; i <= docCount; ++i) {
            String stateId = snapshotDocId + '#' + i;
            this.bulkRequestBuilder.add(this.client.prepareDelete(stateIndexName, ModelState.TYPE.getPreferredName(), stateId));
            ++this.deletedModelStateCount;
        }
        this.bulkRequestBuilder.add(this.client.prepareDelete(AnomalyDetectorsIndex.jobResultsAliasedName(modelSnapshot.getJobId()), ModelSnapshot.TYPE.getPreferredName(), snapshotDocId));
        ++this.deletedModelSnapshotCount;
    }

    public void deleteInterimResults() {
        String index = AnomalyDetectorsIndex.jobResultsAliasedName(this.jobId);
        TermQueryBuilder qb = QueryBuilders.termQuery((String)Bucket.IS_INTERIM.getPreferredName(), (boolean)true);
        SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{index}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{Result.TYPE.getPreferredName()}).setQuery((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)qb)).setFetchSource(false).setScroll(SCROLL_CONTEXT_DURATION).setSize(1000).get();
        long totalHits = searchResponse.getHits().getTotalHits();
        long totalDeletedCount = 0L;
        while (totalDeletedCount < totalHits) {
            for (SearchHit hit : searchResponse.getHits()) {
                LOGGER.trace("Search hit for result: {}", (Object)hit.getId());
                ++totalDeletedCount;
                this.addDeleteRequest(hit, index);
                ++this.deletedResultCount;
            }
            searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(SCROLL_CONTEXT_DURATION).get();
        }
        this.clearScroll(searchResponse.getScrollId());
    }

    private void clearScroll(String scrollId) {
        try {
            this.client.prepareClearScroll().addScrollId(scrollId).get();
        }
        catch (Exception e) {
            LOGGER.warn("[{}] Error while clearing scroll with id [{}]", (Object)this.jobId, (Object)scrollId);
        }
    }

    public void commit(ActionListener<BulkResponse> listener, boolean refresh) {
        if (this.bulkRequestBuilder.numberOfActions() == 0) {
            listener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
            return;
        }
        Level logLevel = this.quiet ? Level.DEBUG : Level.INFO;
        LOGGER.log(logLevel, "Requesting deletion of {} results, {} model snapshots and {} model state documents", (Object)this.deletedResultCount, (Object)this.deletedModelSnapshotCount, (Object)this.deletedModelStateCount);
        if (refresh) {
            this.bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        try {
            this.bulkRequestBuilder.execute(listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void commit(boolean refresh) {
        BulkResponse response;
        if (this.bulkRequestBuilder.numberOfActions() == 0) {
            return;
        }
        Level logLevel = this.quiet ? Level.DEBUG : Level.INFO;
        LOGGER.log(logLevel, "Requesting deletion of {} results, {} model snapshots and {} model state documents", (Object)this.deletedResultCount, (Object)this.deletedModelSnapshotCount, (Object)this.deletedModelStateCount);
        if (refresh) {
            this.bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        if ((response = (BulkResponse)this.bulkRequestBuilder.get()).hasFailures()) {
            LOGGER.debug("Bulk request has failures. {}", (Object)response.buildFailureMessage());
        }
    }

    private class RepeatingSearchScrollListener
    implements ActionListener<SearchResponse> {
        private final AtomicLong totalDeletedCount = new AtomicLong(0L);
        private final String index;
        private final ActionListener<Boolean> scrollFinishedListener;

        RepeatingSearchScrollListener(String index, ActionListener<Boolean> scrollFinishedListener) {
            this.index = index;
            this.scrollFinishedListener = scrollFinishedListener;
        }

        public void onResponse(SearchResponse searchResponse) {
            JobDataDeleter.this.addDeleteRequestForSearchHits(searchResponse.getHits(), this.index);
            this.totalDeletedCount.addAndGet(searchResponse.getHits().hits().length);
            if (this.totalDeletedCount.get() < searchResponse.getHits().totalHits()) {
                JobDataDeleter.this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(JobDataDeleter.SCROLL_CONTEXT_DURATION).execute((ActionListener)this);
            } else {
                JobDataDeleter.this.clearScroll(searchResponse.getScrollId());
                this.scrollFinishedListener.onResponse((Object)true);
            }
        }

        public void onFailure(Exception e) {
            this.scrollFinishedListener.onFailure(e);
        }
    }
}

