/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;

public class JobDataCountsPersister
extends AbstractComponent {
    private final Client client;

    public JobDataCountsPersister(Settings settings, Client client) {
        super(settings);
        this.client = client;
    }

    private XContentBuilder serialiseCounts(DataCounts counts) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return counts.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public void persistDataCounts(String jobId, DataCounts counts, final ActionListener<Boolean> listener) {
        try {
            XContentBuilder content = this.serialiseCounts(counts);
            this.client.prepareIndex(AnomalyDetectorsIndex.jobResultsAliasedName(jobId), DataCounts.TYPE.getPreferredName(), DataCounts.documentId(jobId)).setSource(content).execute((ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    listener.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (IOException ioe) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] Error serialising DataCounts stats", (Object)jobId), (Throwable)ioe);
        }
    }
}

