/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.results.Influencer;

class BatchedInfluencersIterator
extends BatchedResultsIterator<Influencer> {
    BatchedInfluencersIterator(Client client, String jobId) {
        super(client, jobId, "influencer");
    }

    @Override
    protected BatchedResultsIterator.ResultWithIndex<Influencer> map(SearchHit hit) {
        XContentParser parser;
        BytesReference source = hit.getSourceRef();
        try {
            parser = XContentFactory.xContent((BytesReference)source).createParser(NamedXContentRegistry.EMPTY, source);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parser influencer", (Throwable)e, new Object[0]);
        }
        Influencer influencer = (Influencer)((Object)Influencer.PARSER.apply(parser, null));
        return new BatchedResultsIterator.ResultWithIndex<Influencer>(hit.getIndex(), influencer);
    }
}

