/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ModelPlotConfig
extends ToXContentToBytes
implements Writeable {
    private static final ParseField TYPE_FIELD = new ParseField("model_plot_config", new String[0]);
    private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    public static final ConstructingObjectParser<ModelPlotConfig, Void> PARSER = new ConstructingObjectParser(TYPE_FIELD.getPreferredName(), a -> new ModelPlotConfig((Boolean)a[0], (String)a[1]));
    private final boolean enabled;
    private final String terms;

    public ModelPlotConfig() {
        this(true, null);
    }

    public ModelPlotConfig(boolean enabled) {
        this(false, null);
    }

    public ModelPlotConfig(boolean enabled, String terms) {
        this.enabled = enabled;
        this.terms = terms;
    }

    public ModelPlotConfig(StreamInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.terms = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeOptionalString(this.terms);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTerms() {
        return this.terms;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelPlotConfig)) {
            return false;
        }
        ModelPlotConfig that = (ModelPlotConfig)((Object)other);
        return this.enabled == that.enabled && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.terms);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TERMS_FIELD);
    }
}

