/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum JobState implements ToXContent,
Writeable
{
    CLOSING,
    CLOSED,
    OPENED,
    FAILED;


    public static JobState fromString(String name) {
        return JobState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static JobState fromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= JobState.values().length) {
            throw new IOException("Unknown public enum JobState {\n ordinal [" + ordinal + "]");
        }
        return JobState.values()[ordinal];
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.value(this.name().toLowerCase(Locale.ROOT));
        return builder;
    }

    public boolean isFragment() {
        return true;
    }

    public boolean isAnyOf(JobState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

