/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorFactory;
import org.elasticsearch.xpack.ml.job.config.Job;

public interface DataExtractorFactory {
    public DataExtractor newExtractor(long var1, long var3);

    public static DataExtractorFactory create(Client client, DatafeedConfig datafeedConfig, Job job) {
        boolean isScrollSearch = !datafeedConfig.hasAggregations();
        DataExtractorFactory dataExtractorFactory = isScrollSearch ? new ScrollDataExtractorFactory(client, datafeedConfig, job) : new AggregationDataExtractorFactory(client, datafeedConfig, job);
        return datafeedConfig.getChunkingConfig().isEnabled() ? new ChunkedDataExtractorFactory(client, datafeedConfig, job, dataExtractorFactory) : dataExtractorFactory;
    }
}

