/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class UpdateModelSnapshotAction
extends Action<Request, Response, RequestBuilder> {
    public static final UpdateModelSnapshotAction INSTANCE = new UpdateModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/update";

    private UpdateModelSnapshotAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final JobManager jobManager;
        private final JobProvider jobProvider;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, JobProvider jobProvider) {
            super(settings, UpdateModelSnapshotAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.jobManager = jobManager;
            this.jobProvider = jobProvider;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            this.logger.debug("Received request to update model snapshot [{}] for job [{}]", (Object)request.getSnapshotId(), (Object)request.getJobId());
            this.getChangeCandidates(request, changeCandidates -> this.checkForClashes(request, aVoid -> {
                if (changeCandidates.size() > 1) {
                    this.logger.warn("More than one model found for [{}: {}, {}: {}] tuple.", (Object)Job.ID.getPreferredName(), (Object)request.getJobId(), (Object)ModelSnapshot.SNAPSHOT_ID.getPreferredName(), (Object)request.getSnapshotId());
                }
                ModelSnapshot updatedSnapshot = TransportAction.applyUpdate(request, (ModelSnapshot)((Object)((Object)((Object)changeCandidates.get(0)))));
                this.jobManager.updateModelSnapshot(updatedSnapshot, b -> listener.onResponse((Object)new Response(new ModelSnapshot.Builder(updatedSnapshot).setQuantiles(null).build())), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0));
        }

        private void getChangeCandidates(Request request, Consumer<List<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
            this.getModelSnapshots(request.getJobId(), request.getSnapshotId(), null, changeCandidates -> {
                if (changeCandidates == null || changeCandidates.isEmpty()) {
                    errorHandler.accept((Exception)new ResourceNotFoundException(Messages.getMessage("No model snapshot with id [{0}] exists for job [{1}]", request.getSnapshotId(), request.getJobId()), new Object[0]));
                } else {
                    handler.accept((List<ModelSnapshot>)changeCandidates);
                }
            }, errorHandler);
        }

        private void checkForClashes(Request request, Consumer<Void> handler, Consumer<Exception> errorHandler) {
            if (request.getDescription() == null) {
                handler.accept(null);
                return;
            }
            this.getModelSnapshots(request.getJobId(), null, request.getDescription(), clashCandidates -> {
                if (clashCandidates != null && !clashCandidates.isEmpty()) {
                    errorHandler.accept(new IllegalArgumentException(Messages.getMessage("Model snapshot description ''{0}'' has already been used for job ''{1}''", request.getDescription(), request.getJobId())));
                } else {
                    handler.accept(null);
                }
            }, errorHandler);
        }

        private void getModelSnapshots(String jobId, String snapshotId, String description, Consumer<List<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
            this.jobProvider.modelSnapshots(jobId, 0, 1, null, null, null, true, snapshotId, description, page -> handler.accept(page.results()), errorHandler);
        }

        private static ModelSnapshot applyUpdate(Request request, ModelSnapshot target) {
            ModelSnapshot.Builder updatedSnapshotBuilder = new ModelSnapshot.Builder(target);
            if (request.getDescription() != null) {
                updatedSnapshotBuilder.setDescription(request.getDescription());
            }
            if (request.getRetain() != null) {
                updatedSnapshotBuilder.setRetain(request.getRetain());
            }
            return updatedSnapshotBuilder.build();
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, UpdateModelSnapshotAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends ActionResponse
    implements StatusToXContentObject {
        private static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
        private static final ParseField MODEL = new ParseField("model", new String[0]);
        private ModelSnapshot model;

        Response() {
        }

        public Response(ModelSnapshot modelSnapshot) {
            this.model = modelSnapshot;
        }

        public ModelSnapshot getModel() {
            return this.model;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.model = new ModelSnapshot(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.model.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.OK;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ACKNOWLEDGED.getPreferredName(), true);
            builder.field(MODEL.getPreferredName());
            builder = this.model.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.model});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.model, (Object)other.model);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContent {
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/model_snapshots/update", Request::new);
        private String jobId;
        private String snapshotId;
        private String description;
        private Boolean retain;

        public static Request parseRequest(String jobId, String snapshotId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            if (snapshotId != null) {
                request.snapshotId = snapshotId;
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, ModelSnapshot.SNAPSHOT_ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getRetain() {
            return this.retain;
        }

        public void setRetain(Boolean retain) {
            this.retain = retain;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.description = in.readOptionalString();
            this.retain = in.readOptionalBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeOptionalString(this.description);
            out.writeOptionalBoolean(this.retain);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(ModelSnapshot.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
            if (this.description != null) {
                builder.field(ModelSnapshot.DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.retain != null) {
                builder.field(ModelSnapshot.RETAIN.getPreferredName(), this.retain);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.description, this.retain);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.description, other.description) && Objects.equals(this.retain, other.retain);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString((request, snapshotId) -> {
                request.snapshotId = snapshotId;
            }, ModelSnapshot.SNAPSHOT_ID);
            PARSER.declareString(Request::setDescription, ModelSnapshot.DESCRIPTION);
            PARSER.declareBoolean(Request::setRetain, ModelSnapshot.RETAIN);
        }
    }
}

