/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.ssl.SSLClientAuth;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.ssl.VerificationMode;

public class XPackSettings {
    private static final List<Setting<?>> ALL_SETTINGS = new ArrayList();
    public static final Setting<Boolean> SECURITY_ENABLED = XPackSettings.enabledSetting("security", true);
    public static final Setting<Boolean> MONITORING_ENABLED = XPackSettings.enabledSetting("monitoring", s -> String.valueOf(!XPackPlugin.isTribeNode(s) && !XPackPlugin.isTribeClientNode(s)));
    public static final Setting<Boolean> WATCHER_ENABLED = XPackSettings.enabledSetting("watcher", true);
    public static final Setting<Boolean> GRAPH_ENABLED = XPackSettings.enabledSetting("graph", true);
    public static final Setting<Boolean> MACHINE_LEARNING_ENABLED = XPackSettings.enabledSetting("ml", true);
    public static final Setting<Boolean> AUDIT_ENABLED = XPackSettings.enabledSetting("security.audit", false);
    public static final Setting<Boolean> DLS_FLS_ENABLED = XPackSettings.enabledSetting("security.dls_fls", true);
    public static final Setting<Boolean> TRANSPORT_SSL_ENABLED = XPackSettings.enabledSetting("security.transport.ssl", false);
    public static final Setting<Boolean> HTTP_SSL_ENABLED = XPackSettings.enabledSetting("security.http.ssl", false);
    public static final Setting<Boolean> RESERVED_REALM_ENABLED_SETTING = XPackSettings.enabledSetting("security.authc.reserved_realm", true);
    public static final List<String> DEFAULT_CIPHERS = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA");
    public static final List<String> DEFAULT_SUPPORTED_PROTOCOLS = Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1");
    public static final SSLClientAuth CLIENT_AUTH_DEFAULT = SSLClientAuth.REQUIRED;
    public static final SSLClientAuth HTTP_CLIENT_AUTH_DEFAULT = SSLClientAuth.NONE;
    public static final VerificationMode VERIFICATION_MODE_DEFAULT = VerificationMode.FULL;
    public static final String GLOBAL_SSL_PREFIX = "xpack.ssl.";
    private static final SSLConfigurationSettings GLOBAL_SSL = SSLConfigurationSettings.withPrefix("xpack.ssl.");
    public static final String HTTP_SSL_PREFIX = Security.setting("http.ssl.");
    private static final SSLConfigurationSettings HTTP_SSL = SSLConfigurationSettings.withPrefix(HTTP_SSL_PREFIX);
    public static final String TRANSPORT_SSL_PREFIX = Security.setting("transport.ssl.");
    private static final SSLConfigurationSettings TRANSPORT_SSL = SSLConfigurationSettings.withPrefix(TRANSPORT_SSL_PREFIX);

    private static Setting<Boolean> enabledSetting(String featureName, boolean defaultValue) {
        return XPackSettings.enabledSetting(featureName, s -> String.valueOf(defaultValue));
    }

    private static Setting<Boolean> enabledSetting(String featureName, Function<Settings, String> defaultValueFn) {
        String fallbackName = featureName + ".enabled";
        Setting fallback = Setting.boolSetting((String)fallbackName, defaultValueFn, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
        String settingName = XPackPlugin.featureSettingPrefix(featureName) + ".enabled";
        Setting setting = Setting.boolSetting((String)settingName, (Setting)fallback, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        ALL_SETTINGS.add(setting);
        return setting;
    }

    static List<Setting<?>> getAllSettings() {
        return Collections.unmodifiableList(ALL_SETTINGS);
    }

    static {
        ALL_SETTINGS.addAll(GLOBAL_SSL.getAllSettings());
        ALL_SETTINGS.addAll(HTTP_SSL.getAllSettings());
        ALL_SETTINGS.addAll(TRANSPORT_SSL.getAllSettings());
    }
}

