/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.license.LicensingClient;
import org.elasticsearch.license.XPackInfoResponse;
import org.elasticsearch.xpack.action.XPackInfoAction;
import org.elasticsearch.xpack.action.XPackInfoRequest;
import org.elasticsearch.xpack.action.XPackInfoRequestBuilder;
import org.elasticsearch.xpack.ml.client.MachineLearningClient;
import org.elasticsearch.xpack.monitoring.client.MonitoringClient;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.watcher.client.WatcherClient;

public class XPackClient {
    private final Client client;
    private final LicensingClient licensingClient;
    private final MonitoringClient monitoringClient;
    private final SecurityClient securityClient;
    private final WatcherClient watcherClient;
    private final MachineLearningClient machineLearning;

    public XPackClient(Client client) {
        this.client = client;
        this.licensingClient = new LicensingClient((ElasticsearchClient)client);
        this.monitoringClient = new MonitoringClient(client);
        this.securityClient = new SecurityClient((ElasticsearchClient)client);
        this.watcherClient = new WatcherClient(client);
        this.machineLearning = new MachineLearningClient((ElasticsearchClient)client);
    }

    public Client es() {
        return this.client;
    }

    public LicensingClient licensing() {
        return this.licensingClient;
    }

    public MonitoringClient monitoring() {
        return this.monitoringClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public MachineLearningClient machineLearning() {
        return this.machineLearning;
    }

    public XPackClient withHeaders(Map<String, String> headers) {
        return new XPackClient(this.client.filterWithHeader(headers));
    }

    public XPackClient withAuth(String username, char[] passwd) {
        return this.withHeaders(Collections.singletonMap("Authorization", UsernamePasswordToken.basicAuthHeaderValue(username, new SecuredString(passwd))));
    }

    public XPackInfoRequestBuilder prepareInfo() {
        return new XPackInfoRequestBuilder((ElasticsearchClient)this.client);
    }

    public void info(XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        this.client.execute((Action)XPackInfoAction.INSTANCE, (ActionRequest)request, listener);
    }
}

