/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.tool;

import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.xpack.watcher.trigger.schedule.Cron;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CronEvalTool
extends Command {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss");
    private final OptionSpec<String> countOption;
    private final OptionSpec<String> arguments;

    public static void main(String[] args) throws Exception {
        CronEvalTool.exit((int)new CronEvalTool().main(args, Terminal.DEFAULT));
    }

    CronEvalTool() {
        super("Validates and evaluates a cron expression");
        this.countOption = this.parser.acceptsAll(Arrays.asList("c", "count"), "The number of future times this expression will be triggered").withRequiredArg().defaultsTo((Object)"10", (Object[])new String[0]);
        this.arguments = this.parser.nonOptions("expression");
    }

    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        int count = Integer.parseInt((String)this.countOption.value(options));
        List args = this.arguments.values(options);
        if (args.size() != 1) {
            throw new UserException(64, "expecting a single argument that is the cron expression to evaluate");
        }
        this.execute(terminal, (String)args.get(0), count);
    }

    void execute(Terminal terminal, String expression, int count) throws Exception {
        Cron.validate(expression);
        terminal.println("Valid!");
        DateTime date = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        terminal.println("Now is [" + formatter.print((ReadableInstant)date) + "]");
        terminal.println("Here are the next " + count + " times this cron expression will trigger:");
        Cron cron = new Cron(expression);
        long time = date.getMillis();
        for (int i = 0; i < count; ++i) {
            long prevTime = time;
            if ((time = cron.getNextValidTimeAfter(time)) < 0L) {
                throw new UserException(0, i + 1 + ".\t Could not compute future times since [" + formatter.print(prevTime) + "] (perhaps the cron expression only points to times in the past?)");
            }
            terminal.println(i + 1 + ".\t" + formatter.print(time));
        }
    }
}

