/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ScriptTransform
implements Transform {
    public static final String TYPE = "script";
    private final Script script;

    public ScriptTransform(Script script) {
        this.script = script;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public Script getScript() {
        return this.script;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptTransform that = (ScriptTransform)o;
        return this.script.equals((Object)that.script);
    }

    public int hashCode() {
        return this.script.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.script.toXContent(builder, params);
    }

    public static ScriptTransform parse(String watchId, XContentParser parser, boolean upgradeSource, String defaultLegacyScriptLanguage) throws IOException {
        try {
            Script script = upgradeSource ? Script.parse((XContentParser)parser, (ParseFieldMatcher)ParseFieldMatcher.EMPTY, (String)defaultLegacyScriptLanguage) : Script.parse((XContentParser)parser, (ParseFieldMatcher)ParseFieldMatcher.EMPTY);
            return new ScriptTransform(script);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. failed to parse script", (Throwable)pe, new Object[]{TYPE, watchId});
        }
    }

    public static Builder builder(Script script) {
        return new Builder(script);
    }

    public static class Builder
    implements Transform.Builder<ScriptTransform> {
        private final Script script;

        public Builder(Script script) {
            this.script = script;
        }

        @Override
        public ScriptTransform build() {
            return new ScriptTransform(this.script);
        }
    }

    public static class Result
    extends Transform.Result {
        public Result(Payload payload) {
            super(ScriptTransform.TYPE, payload);
        }

        public Result(Exception e) {
            super(ScriptTransform.TYPE, e);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

