/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class ExecutableHttpInput
extends ExecutableInput<HttpInput, HttpInput.Result> {
    private final HttpClient client;
    private final TextTemplateEngine templateEngine;

    public ExecutableHttpInput(HttpInput input, Logger logger, HttpClient client, TextTemplateEngine templateEngine) {
        super(input, logger);
        this.client = client;
        this.templateEngine = templateEngine;
    }

    @Override
    public HttpInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        HttpRequest request = null;
        try {
            Map<String, Object> model = Variables.createCtxModel(ctx, payload);
            request = ((HttpInput)this.input).getRequest().render(this.templateEngine, model);
            ExecutableHttpInput.checkUrlDepreciation(ctx.watch(), "http input", request, this.logger);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for watch [{}], reason [{}]", (Object)"http", (Object)ctx.watch().id(), (Object)e.getMessage());
            return new HttpInput.Result(request, e);
        }
    }

    HttpInput.Result doExecute(WatchExecutionContext ctx, HttpRequest request) throws Exception {
        XContentType contentType;
        HttpResponse response = this.client.execute(request);
        Map<String, List<String>> headers = response.headers();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("_status_code", response.status());
        if (!headers.isEmpty()) {
            payloadMap.put("_headers", headers);
        }
        if (!response.hasContent()) {
            return new HttpInput.Result(request, response.status(), new Payload.Simple(payloadMap));
        }
        XContentType responseContentType = response.xContentType();
        if (((HttpInput)this.input).getExpectedResponseXContentType() == null) {
            contentType = responseContentType != null ? responseContentType : XContentFactory.xContentType((BytesReference)response.body());
        } else {
            contentType = ((HttpInput)this.input).getExpectedResponseXContentType().contentType();
            if (responseContentType != contentType) {
                this.logger.warn("[{}] [{}] input expected content type [{}] but read [{}] from headers, using expected one", (Object)this.type(), (Object)ctx.id(), (Object)((HttpInput)this.input).getExpectedResponseXContentType(), (Object)responseContentType);
            }
        }
        if (contentType != null) {
            try (XContentParser parser = contentType.xContent().createParser(NamedXContentRegistry.EMPTY, response.body());){
                if (((HttpInput)this.input).getExtractKeys() != null) {
                    payloadMap.putAll(XContentFilterKeysUtils.filterMapOrdered(((HttpInput)this.input).getExtractKeys(), parser));
                }
                payloadMap.putAll(parser.mapOrdered());
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("could not parse response body [{}] it does not appear to be [{}]", new Object[]{this.type(), ctx.id(), response.body().utf8ToString(), contentType.shortName()});
            }
        } else {
            payloadMap.put("_value", response.body().utf8ToString());
        }
        return new HttpInput.Result(request, response.status(), new Payload.Simple(payloadMap));
    }

    public static void checkUrlDepreciation(Watch watch, String desc, HttpRequest request, Logger logger) {
        if (!Strings.isNullOrEmpty((String)request.path())) {
            try {
                new URL(request.scheme().scheme(), request.host(), request.port(), request.path()).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
                deprecationLogger.deprecated("watch [{}] url [{}://{}:{}/{}] in [{}] needs to be a valid URI (properly encoded) in 6.0", new Object[]{watch.id(), request.scheme().scheme(), request.host(), request.port(), request.path(), desc});
            }
        }
    }
}

