/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.throttler.ActionThrottler;
import org.elasticsearch.xpack.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class ActionWrapper
implements ToXContent {
    private String id;
    @Nullable
    private final Condition condition;
    @Nullable
    private final ExecutableTransform transform;
    private final ActionThrottler throttler;
    private final ExecutableAction action;

    public ActionWrapper(String id, ExecutableAction action) {
        this(id, null, null, null, action);
    }

    public ActionWrapper(String id, ActionThrottler throttler, @Nullable Condition condition, @Nullable ExecutableTransform transform, ExecutableAction action) {
        this.id = id;
        this.condition = condition;
        this.throttler = throttler;
        this.transform = transform;
        this.action = action;
    }

    public String id() {
        return this.id;
    }

    public Condition condition() {
        return this.condition;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ExecutableAction action() {
        return this.action;
    }

    public Result execute(WatchExecutionContext ctx) {
        Throttler.Result throttleResult;
        Result result = ctx.actionsResults().get(this.id);
        if (result != null) {
            return result;
        }
        if (!ctx.skipThrottling(this.id) && (throttleResult = this.throttler.throttle(this.id, ctx)).throttle()) {
            return new Result(this.id, new Action.Result.Throttled(this.action.type(), throttleResult.reason()));
        }
        Condition.Result conditionResult = null;
        if (this.condition != null) {
            try {
                conditionResult = this.condition.execute(ctx);
                if (!conditionResult.met()) {
                    return new Result(this.id, conditionResult, null, new Action.Result.ConditionFailed(this.action.type(), "condition not met. skipping", new Object[0]));
                }
            }
            catch (RuntimeException e) {
                this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]. failed to execute condition", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
                return new Result(this.id, new Action.Result.ConditionFailed(this.action.type(), "condition failed. skipping: {}", e.getMessage()));
            }
        }
        Payload payload = ctx.payload();
        Transform.Result transformResult = null;
        if (this.transform != null) {
            try {
                transformResult = (Transform.Result)this.transform.execute(ctx, payload);
                if (transformResult.status() == Transform.Result.Status.FAILURE) {
                    this.action.logger().error("failed to execute action [{}/{}]. failed to transform payload. {}", (Object)ctx.watch().id(), (Object)this.id, (Object)transformResult.reason());
                    String msg = "Failed to transform payload";
                    return new Result(this.id, conditionResult, transformResult, new Action.Result.Failure(this.action.type(), msg, new Object[0]));
                }
                payload = transformResult.payload();
            }
            catch (Exception e) {
                this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]. failed to transform payload.", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
                return new Result(this.id, conditionResult, null, new Action.Result.Failure(this.action.type(), "Failed to transform payload. error: {}", ExceptionsHelper.detailedMessage((Throwable)e)));
            }
        }
        try {
            Action.Result actionResult = this.action.execute(this.id, ctx, payload);
            return new Result(this.id, conditionResult, transformResult, actionResult);
        }
        catch (Exception e) {
            this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
            return new Result(this.id, new Action.Result.Failure(this.action.type(), ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionWrapper that = (ActionWrapper)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.transform != null ? !this.transform.equals(that.transform) : that.transform != null) {
            return false;
        }
        return this.action.equals(that.action);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.transform != null ? this.transform.hashCode() : 0);
        result = 31 * result + this.action.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        TimeValue throttlePeriod = this.throttler.throttlePeriod();
        if (throttlePeriod != null) {
            builder.timeValueField(Throttler.Field.THROTTLE_PERIOD.getPreferredName(), Throttler.Field.THROTTLE_PERIOD_HUMAN.getPreferredName(), throttlePeriod);
        }
        if (this.condition != null) {
            builder.startObject(Watch.Field.CONDITION.getPreferredName()).field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        }
        if (this.transform != null) {
            builder.startObject(Transform.Field.TRANSFORM.getPreferredName()).field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        builder.field(this.action.type(), (ToXContent)this.action, params);
        return builder.endObject();
    }

    static ActionWrapper parse(String watchId, String actionId, XContentParser parser, ActionRegistry actionRegistry, Clock clock, XPackLicenseState licenseState, boolean upgradeActionSource) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        Condition condition = null;
        ExecutableTransform transform = null;
        TimeValue throttlePeriod = null;
        ExecutableAction action = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Watch.Field.CONDITION.match(currentFieldName)) {
                condition = actionRegistry.getConditionRegistry().parseExecutable(watchId, parser, upgradeActionSource);
                continue;
            }
            if (Transform.Field.TRANSFORM.match(currentFieldName)) {
                transform = actionRegistry.getTransformRegistry().parse(watchId, parser, upgradeActionSource);
                continue;
            }
            if (Throttler.Field.THROTTLE_PERIOD.match(currentFieldName)) {
                throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (Throttler.Field.THROTTLE_PERIOD_HUMAN.match(currentFieldName)) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, Throttler.Field.THROTTLE_PERIOD_HUMAN.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse action [{}/{}]. failed to parse field [{}] as time value", (Throwable)pe, new Object[]{watchId, actionId, currentFieldName});
                }
            }
            ActionFactory actionFactory = actionRegistry.factory(currentFieldName);
            if (actionFactory == null) {
                throw new ElasticsearchParseException("could not parse action [{}/{}]. unknown action type [{}]", new Object[]{watchId, actionId, currentFieldName});
            }
            action = actionFactory.parseExecutable(watchId, actionId, parser);
        }
        if (action == null) {
            throw new ElasticsearchParseException("could not parse watch action [{}/{}]. missing action type", new Object[]{watchId, actionId});
        }
        ActionThrottler throttler = new ActionThrottler(clock, throttlePeriod, licenseState);
        return new ActionWrapper(actionId, throttler, condition, transform, action);
    }

    static interface Field {
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField STATUS = new ParseField("status", new String[0]);
    }

    public static class Result
    implements ToXContent {
        private final String id;
        @Nullable
        private final Condition.Result condition;
        @Nullable
        private final Transform.Result transform;
        private final Action.Result action;

        public Result(String id, Action.Result action) {
            this(id, null, null, action);
        }

        public Result(String id, @Nullable Condition.Result condition, @Nullable Transform.Result transform, Action.Result action) {
            this.id = id;
            this.condition = condition;
            this.transform = transform;
            this.action = action;
        }

        public String id() {
            return this.id;
        }

        public Condition.Result condition() {
            return this.condition;
        }

        public Transform.Result transform() {
            return this.transform;
        }

        public Action.Result action() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (!this.id.equals(result.id)) {
                return false;
            }
            if (this.condition != null ? !this.condition.equals(result.condition) : result.condition != null) {
                return false;
            }
            if (this.transform != null ? !this.transform.equals(result.transform) : result.transform != null) {
                return false;
            }
            return this.action.equals(result.action);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.transform != null ? this.transform.hashCode() : 0);
            result = 31 * result + this.action.hashCode();
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.ID.getPreferredName(), this.id);
            builder.field(Field.TYPE.getPreferredName(), this.action.type());
            builder.field(Field.STATUS.getPreferredName(), (ToXContent)this.action.status(), params);
            if (this.condition != null) {
                builder.field(Watch.Field.CONDITION.getPreferredName(), (ToXContent)this.condition, params);
            }
            if (this.transform != null) {
                builder.field(Transform.Field.TRANSFORM.getPreferredName(), (ToXContent)this.transform, params);
            }
            this.action.toXContent(builder, params);
            return builder.endObject();
        }
    }
}

