/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.network.InetAddressHelper;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.env.Environment;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CertUtils {
    private static final int SERIAL_BIT_LENGTH = 160;
    static final BouncyCastleProvider BC_PROV = new BouncyCastleProvider();

    private CertUtils() {
    }

    @SuppressForbidden(reason="we don't have the environment to resolve files from when running in a transport client")
    static Path resolvePath(String path, @Nullable Environment environment) {
        if (environment != null) {
            return environment.configFile().resolve(path);
        }
        return PathUtils.get((String)Strings.cleanPath((String)path), (String[])new String[0]);
    }

    static X509ExtendedKeyManager keyManager(Certificate[] certificateChain, PrivateKey privateKey, char[] password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, password, certificateChain);
        return CertUtils.keyManager(keyStore, password, KeyManagerFactory.getDefaultAlgorithm());
    }

    static X509ExtendedKeyManager keyManager(KeyStore keyStore, char[] password, String algorithm) throws Exception {
        KeyManager[] keyManagers;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keyStore, password);
        for (KeyManager keyManager : keyManagers = kmf.getKeyManagers()) {
            if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)keyManager;
        }
        throw new IllegalStateException("failed to find a X509ExtendedKeyManager");
    }

    public static X509ExtendedTrustManager trustManager(Certificate[] certificates) throws Exception {
        KeyStore store = KeyStore.getInstance("jks");
        store.load(null, null);
        int counter = 0;
        for (Certificate certificate : certificates) {
            store.setCertificateEntry("cert" + counter, certificate);
            ++counter;
        }
        return CertUtils.trustManager(store, TrustManagerFactory.getDefaultAlgorithm());
    }

    public static X509ExtendedTrustManager trustManager(String trustStorePath, String trustStorePassword, String trustStoreAlgorithm, @Nullable Environment env) throws Exception {
        try (InputStream in = Files.newInputStream(CertUtils.resolvePath(trustStorePath, env), new OpenOption[0]);){
            KeyStore trustStore = KeyStore.getInstance("jks");
            assert (trustStorePassword != null);
            trustStore.load(in, trustStorePassword.toCharArray());
            X509ExtendedTrustManager x509ExtendedTrustManager = CertUtils.trustManager(trustStore, trustStoreAlgorithm);
            return x509ExtendedTrustManager;
        }
    }

    static X509ExtendedTrustManager trustManager(KeyStore keyStore, String algorithm) throws Exception {
        TrustManager[] trustManagers;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        for (TrustManager trustManager : trustManagers = tmf.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)trustManager;
        }
        throw new IllegalStateException("failed to find a X509ExtendedTrustManager");
    }

    public static Certificate[] readCertificates(List<String> certPaths, @Nullable Environment environment) throws Exception {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certPaths.size());
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        for (String path : certPaths) {
            BufferedReader reader = Files.newBufferedReader(CertUtils.resolvePath(path, environment), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                CertUtils.readCertificates(reader, certificates, certFactory);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    static void readCertificates(Reader reader, List<Certificate> certificates, CertificateFactory certFactory) throws Exception {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object parsed = pemParser.readObject();
            if (parsed == null) {
                throw new IllegalArgumentException("could not parse pem certificate");
            }
            while (parsed != null) {
                X509CertificateHolder holder;
                if (parsed instanceof X509CertificateHolder) {
                    holder = (X509CertificateHolder)parsed;
                } else if (parsed instanceof X509TrustedCertificateBlock) {
                    X509TrustedCertificateBlock certificateBlock = (X509TrustedCertificateBlock)parsed;
                    holder = certificateBlock.getCertificateHolder();
                } else {
                    throw new IllegalArgumentException("parsed an unsupported object [" + parsed.getClass().getSimpleName() + "]");
                }
                certificates.add(certFactory.generateCertificate(new ByteArrayInputStream(holder.getEncoded())));
                parsed = pemParser.readObject();
            }
        }
    }

    static PrivateKey readPrivateKey(Reader reader, Supplier<char[]> passwordSupplier) throws Exception {
        try (PEMParser parser = new PEMParser(reader);){
            PrivateKeyInfo privateKeyInfo;
            Object parsed;
            ArrayList<Object> list = new ArrayList<Object>(1);
            do {
                if ((parsed = parser.readObject()) == null) continue;
                list.add(parsed);
            } while (parsed != null);
            if (list.size() != 1) {
                throw new IllegalStateException("key file contained [" + list.size() + "] entries, expected one");
            }
            Object parsedObject = list.get(0);
            if (parsedObject instanceof PEMEncryptedKeyPair) {
                char[] keyPassword = passwordSupplier.get();
                if (keyPassword == null) {
                    throw new IllegalArgumentException("cannot read encrypted key without a password");
                }
                PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)parsedObject;
                privateKeyInfo = encryptedKeyPair.decryptKeyPair(new JcePEMDecryptorProviderBuilder().setProvider((Provider)BC_PROV).build(keyPassword)).getPrivateKeyInfo();
            } else if (parsedObject instanceof PEMKeyPair) {
                privateKeyInfo = ((PEMKeyPair)parsedObject).getPrivateKeyInfo();
            } else if (parsedObject instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)parsedObject;
            } else {
                throw new IllegalArgumentException("parsed an unsupported object [" + parsedObject.getClass().getSimpleName() + "]");
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
            return privateKey;
        }
    }

    static X509Certificate generateCACertificate(X500Principal x500Principal, KeyPair keyPair, int days) throws Exception {
        return CertUtils.generateSignedCertificate(x500Principal, null, keyPair, null, null, true, days);
    }

    public static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, int days) throws Exception {
        return CertUtils.generateSignedCertificate(principal, subjectAltNames, keyPair, caCert, caPrivKey, false, days);
    }

    private static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, boolean isCa, int days) throws Exception {
        AuthorityKeyIdentifier authorityKeyIdentifier;
        X500Name issuer;
        DateTime notBefore = new DateTime(DateTimeZone.UTC);
        if (days < 1) {
            throw new IllegalArgumentException("the certificate must be valid for at least one day");
        }
        DateTime notAfter = notBefore.plusDays(days);
        BigInteger serial = CertUtils.getSerial();
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        X500Name subject = X500Name.getInstance((Object)principal.getEncoded());
        if (caCert != null) {
            if (caCert.getBasicConstraints() < 0) {
                throw new IllegalArgumentException("ca certificate is not a CA!");
            }
            issuer = X500Name.getInstance((Object)caCert.getIssuerX500Principal().getEncoded());
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(caCert);
        } else {
            issuer = subject;
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(keyPair.getPublic(), new X500Principal(issuer.toString()), serial);
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, new Time(notBefore.toDate(), Locale.ROOT), new Time(notAfter.toDate(), Locale.ROOT), subject, keyPair.getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
        if (subjectAltNames != null) {
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        }
        builder.addExtension(Extension.basicConstraints, isCa, (ASN1Encodable)new BasicConstraints(isCa));
        PrivateKey signingKey = caPrivKey != null ? caPrivKey : keyPair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(signingKey);
        X509CertificateHolder certificateHolder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(certificateHolder);
    }

    static PKCS10CertificationRequest generateCSR(KeyPair keyPair, X500Principal principal, GeneralNames sanList) throws Exception {
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(principal, keyPair.getPublic());
        if (sanList != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)sanList);
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        return builder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider((Provider)BC_PROV).build(keyPair.getPrivate()));
    }

    static BigInteger getSerial() {
        SecureRandom random = new SecureRandom();
        BigInteger serial = new BigInteger(160, random);
        assert (serial.compareTo(BigInteger.valueOf(0L)) >= 0);
        return serial;
    }

    static KeyPair generateKeyPair(int keysize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }

    static GeneralNames getSubjectAlternativeNames(boolean resolveName, Set<InetAddress> addresses) throws Exception {
        HashSet<GeneralName> generalNameList = new HashSet<GeneralName>();
        for (InetAddress address : addresses) {
            if (address.isAnyLocalAddress()) {
                for (InetAddress inetAddress : InetAddressHelper.getAllAddresses()) {
                    CertUtils.addSubjectAlternativeNames(resolveName, inetAddress, generalNameList);
                }
                continue;
            }
            CertUtils.addSubjectAlternativeNames(resolveName, address, generalNameList);
        }
        return new GeneralNames(generalNameList.toArray(new GeneralName[generalNameList.size()]));
    }

    @SuppressForbidden(reason="need to use getHostName to resolve DNS name and getHostAddress to ensure we resolved the name")
    private static void addSubjectAlternativeNames(boolean resolveName, InetAddress inetAddress, Set<GeneralName> list) {
        String possibleHostName;
        String hostaddress = inetAddress.getHostAddress();
        String ip = NetworkAddress.format((InetAddress)inetAddress);
        list.add(new GeneralName(7, ip));
        if (resolveName && !inetAddress.isLinkLocalAddress() && !(possibleHostName = inetAddress.getHostName()).equals(hostaddress)) {
            list.add(new GeneralName(2, possibleHostName));
        }
    }
}

