/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty4HttpServerTransport
extends Netty4HttpServerTransport {
    private final IPFilter ipFilter;
    private final SSLService sslService;
    private final boolean ssl;

    public SecurityNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, IPFilter ipFilter, SSLService sslService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry);
        this.ipFilter = ipFilter;
        this.ssl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        this.sslService = sslService;
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Netty4Utils.maybeDie((Throwable)cause);
        if (!this.lifecycle.started()) {
            return;
        }
        if (SSLExceptionHelper.isNotSslRecordException(cause)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("received plaintext http traffic on a https channel, closing connection {}", (Object)ctx.channel()), cause);
            } else {
                this.logger.warn("received plaintext http traffic on a https channel, closing connection {}", (Object)ctx.channel());
            }
            ctx.channel().close();
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(cause)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("connection {} closed during handshake", (Object)ctx.channel()), cause);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)ctx.channel());
            }
            ctx.channel().close();
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    protected void doStart() {
        super.doStart();
        this.ipFilter.setBoundHttpTransportAddress(this.boundAddress());
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpSslChannelHandler(this);
    }

    public static void overrideSettings(Settings.Builder settingsBuilder, Settings settings) {
        if (((Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)).booleanValue() && !HttpTransportSettings.SETTING_HTTP_COMPRESSION.exists(settings)) {
            settingsBuilder.put(HttpTransportSettings.SETTING_HTTP_COMPRESSION.getKey(), false);
        }
    }

    private class HttpSslChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        private final Settings sslSettings;

        HttpSslChannelHandler(Netty4HttpServerTransport transport) {
            super(transport, SecurityNetty4HttpServerTransport.this.detailedErrorsEnabled, SecurityNetty4HttpServerTransport.this.threadPool.getThreadContext());
            this.sslSettings = SSLService.getHttpTransportSSLSettings(SecurityNetty4HttpServerTransport.this.settings);
            if (SecurityNetty4HttpServerTransport.this.ssl && !SecurityNetty4HttpServerTransport.this.sslService.isConfigurationValidForServerUsage(this.sslSettings, Settings.EMPTY)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4HttpServerTransport.this.ssl) {
                SSLEngine engine = SecurityNetty4HttpServerTransport.this.sslService.createSSLEngine(this.sslSettings, Settings.EMPTY);
                engine.setUseClientMode(false);
                ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine));
            }
            ch.pipeline().addFirst("ip_filter", (ChannelHandler)new IpFilterRemoteAddressFilter(SecurityNetty4HttpServerTransport.this.ipFilter, ".http"));
        }
    }
}

