/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.filter;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class IPFilter {
    public static final String HTTP_PROFILE_NAME = ".http";
    public static final Setting<Boolean> ALLOW_BOUND_ADDRESSES_SETTING = Setting.boolSetting((String)Security.setting("filter.always_allow_bound_address"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> IP_FILTER_ENABLED_HTTP_SETTING = Setting.boolSetting((String)Security.setting("http.filter.enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> IP_FILTER_ENABLED_SETTING = Setting.boolSetting((String)Security.setting("transport.filter.enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> TRANSPORT_FILTER_ALLOW_SETTING = Setting.listSetting((String)Security.setting("transport.filter.allow"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> TRANSPORT_FILTER_DENY_SETTING = Setting.listSetting((String)Security.setting("transport.filter.deny"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting<List<String>> HTTP_FILTER_ALLOW_FALLBACK = Setting.listSetting((String)"transport.profiles.default.xpack.security.filter.allow", TRANSPORT_FILTER_ALLOW_SETTING, s -> s, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> HTTP_FILTER_ALLOW_SETTING = Setting.listSetting((String)Security.setting("http.filter.allow"), HTTP_FILTER_ALLOW_FALLBACK, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting<List<String>> HTTP_FILTER_DENY_FALLBACK = Setting.listSetting((String)"transport.profiles.default.xpack.security.filter.deny", TRANSPORT_FILTER_DENY_SETTING, s -> s, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> HTTP_FILTER_DENY_SETTING = Setting.listSetting((String)Security.setting("http.filter.deny"), HTTP_FILTER_DENY_FALLBACK, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Map<String, Object> DISABLED_USAGE_STATS = new MapBuilder().put((Object)"http", (Object)false).put((Object)"transport", (Object)false).immutableMap();
    public static final SecurityIpFilterRule DEFAULT_PROFILE_ACCEPT_ALL = new SecurityIpFilterRule(true, "default:accept_all"){

        @Override
        public boolean contains(InetAddress inetAddress) {
            return true;
        }

        @Override
        public boolean isAllowRule() {
            return true;
        }

        @Override
        public boolean isDenyRule() {
            return false;
        }
    };
    private final AuditTrailService auditTrail;
    private final XPackLicenseState licenseState;
    private final boolean alwaysAllowBoundAddresses;
    private final Logger logger;
    private volatile Map<String, SecurityIpFilterRule[]> rules = Collections.emptyMap();
    private volatile boolean isIpFilterEnabled;
    private volatile boolean isHttpFilterEnabled;
    private volatile Map<String, Settings> transportGroups;
    private volatile List<String> transportAllowFilter;
    private volatile List<String> transportDenyFilter;
    private volatile List<String> httpAllowFilter;
    private volatile List<String> httpDenyFilter;
    private final SetOnce<BoundTransportAddress> boundTransportAddress = new SetOnce();
    private final SetOnce<BoundTransportAddress> boundHttpTransportAddress = new SetOnce();
    private final SetOnce<Map<String, BoundTransportAddress>> profileBoundAddress = new SetOnce();

    public IPFilter(Settings settings, AuditTrailService auditTrail, ClusterSettings clusterSettings, XPackLicenseState licenseState) {
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.auditTrail = auditTrail;
        this.licenseState = licenseState;
        this.alwaysAllowBoundAddresses = (Boolean)ALLOW_BOUND_ADDRESSES_SETTING.get(settings);
        this.httpDenyFilter = (List)HTTP_FILTER_DENY_SETTING.get(settings);
        this.httpAllowFilter = (List)HTTP_FILTER_ALLOW_SETTING.get(settings);
        this.transportAllowFilter = (List)TRANSPORT_FILTER_ALLOW_SETTING.get(settings);
        this.transportDenyFilter = (List)TRANSPORT_FILTER_DENY_SETTING.get(settings);
        this.isHttpFilterEnabled = (Boolean)IP_FILTER_ENABLED_HTTP_SETTING.get(settings);
        this.isIpFilterEnabled = (Boolean)IP_FILTER_ENABLED_SETTING.get(settings);
        this.transportGroups = ((Settings)TransportSettings.TRANSPORT_PROFILES_SETTING.get(settings)).getAsGroups();
        clusterSettings.addSettingsUpdateConsumer(IP_FILTER_ENABLED_HTTP_SETTING, this::setHttpFiltering);
        clusterSettings.addSettingsUpdateConsumer(IP_FILTER_ENABLED_SETTING, this::setTransportFiltering);
        clusterSettings.addSettingsUpdateConsumer(TRANSPORT_FILTER_ALLOW_SETTING, this::setTransportAllowFilter);
        clusterSettings.addSettingsUpdateConsumer(TRANSPORT_FILTER_DENY_SETTING, this::setTransportDenyFilter);
        clusterSettings.addSettingsUpdateConsumer(HTTP_FILTER_ALLOW_SETTING, this::setHttpAllowFilter);
        clusterSettings.addSettingsUpdateConsumer(HTTP_FILTER_DENY_SETTING, this::setHttpDenyFilter);
        clusterSettings.addSettingsUpdateConsumer(TransportSettings.TRANSPORT_PROFILES_SETTING, this::setTransportProfiles);
        this.updateRules();
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        boolean httpFilterEnabled = this.isHttpFilterEnabled && (!this.httpAllowFilter.isEmpty() || !this.httpDenyFilter.isEmpty());
        boolean transportFilterEnabled = this.isIpFilterEnabled && (!this.transportAllowFilter.isEmpty() || !this.transportDenyFilter.isEmpty());
        map.put("http", httpFilterEnabled);
        map.put("transport", transportFilterEnabled);
        return map;
    }

    private void setTransportProfiles(Settings settings) {
        this.transportGroups = settings.getAsGroups();
        this.updateRules();
    }

    private void setHttpDenyFilter(List<String> filter) {
        this.httpDenyFilter = filter;
        this.updateRules();
    }

    private void setHttpAllowFilter(List<String> filter) {
        this.httpAllowFilter = filter;
        this.updateRules();
    }

    private void setTransportDenyFilter(List<String> filter) {
        this.transportDenyFilter = filter;
        this.updateRules();
    }

    private void setTransportAllowFilter(List<String> filter) {
        this.transportAllowFilter = filter;
        this.updateRules();
    }

    private void setTransportFiltering(boolean enabled) {
        this.isIpFilterEnabled = enabled;
        this.updateRules();
    }

    private void setHttpFiltering(boolean enabled) {
        this.isHttpFilterEnabled = enabled;
        this.updateRules();
    }

    public boolean accept(String profile, InetAddress peerAddress) {
        if (!this.licenseState.isIpFilteringAllowed()) {
            return true;
        }
        if (!this.rules.containsKey(profile)) {
            return true;
        }
        for (SecurityIpFilterRule rule : this.rules.get(profile)) {
            if (!rule.contains(peerAddress)) continue;
            boolean isAllowed = rule.isAllowRule();
            if (isAllowed) {
                this.auditTrail.connectionGranted(peerAddress, profile, rule);
            } else {
                this.auditTrail.connectionDenied(peerAddress, profile, rule);
            }
            return isAllowed;
        }
        this.auditTrail.connectionGranted(peerAddress, profile, DEFAULT_PROFILE_ACCEPT_ALL);
        return true;
    }

    private synchronized void updateRules() {
        this.rules = this.parseSettings();
    }

    private Map<String, SecurityIpFilterRule[]> parseSettings() {
        if (this.isIpFilterEnabled || this.isHttpFilterEnabled) {
            TransportAddress[] localAddresses;
            HashMap<String, SecurityIpFilterRule[]> profileRules = new HashMap<String, SecurityIpFilterRule[]>();
            if (this.isHttpFilterEnabled && this.boundHttpTransportAddress.get() != null) {
                localAddresses = ((BoundTransportAddress)this.boundHttpTransportAddress.get()).boundAddresses();
                profileRules.put(HTTP_PROFILE_NAME, this.createRules(this.httpAllowFilter, this.httpDenyFilter, localAddresses));
            }
            if (this.isIpFilterEnabled && this.boundTransportAddress.get() != null) {
                localAddresses = ((BoundTransportAddress)this.boundTransportAddress.get()).boundAddresses();
                profileRules.put("default", this.createRules(this.transportAllowFilter, this.transportDenyFilter, localAddresses));
                for (Map.Entry<String, Settings> entry : this.transportGroups.entrySet()) {
                    String profile = entry.getKey();
                    BoundTransportAddress profileBoundTransportAddress = (BoundTransportAddress)((Map)this.profileBoundAddress.get()).get(profile);
                    if (profileBoundTransportAddress == null) {
                        this.logger.warn("skipping ip filter rules for profile [{}] since the profile is not bound to any addresses", (Object)profile);
                        continue;
                    }
                    Settings profileSettings = entry.getValue().getByPrefix(Security.setting("filter."));
                    profileRules.put(profile, this.createRules(Arrays.asList(profileSettings.getAsArray("allow")), Arrays.asList(profileSettings.getAsArray("deny")), profileBoundTransportAddress.boundAddresses()));
                }
            }
            this.logger.debug("loaded ip filtering profiles: {}", profileRules.keySet());
            return Collections.unmodifiableMap(profileRules);
        }
        return Collections.emptyMap();
    }

    private SecurityIpFilterRule[] createRules(List<String> allow, List<String> deny, TransportAddress[] boundAddresses) {
        ArrayList<SecurityIpFilterRule> rules = new ArrayList<SecurityIpFilterRule>();
        if (this.alwaysAllowBoundAddresses) {
            assert (boundAddresses != null && boundAddresses.length > 0);
            rules.add(new SecurityIpFilterRule(true, boundAddresses));
        }
        for (String value : allow) {
            rules.add(new SecurityIpFilterRule(true, value));
        }
        for (String value : deny) {
            rules.add(new SecurityIpFilterRule(false, value));
        }
        return rules.toArray(new SecurityIpFilterRule[rules.size()]);
    }

    public void setBoundTransportAddress(BoundTransportAddress boundTransportAddress, Map<String, BoundTransportAddress> profileBoundAddress) {
        this.boundTransportAddress.set((Object)boundTransportAddress);
        this.profileBoundAddress.set(profileBoundAddress);
        this.updateRules();
    }

    public void setBoundHttpTransportAddress(BoundTransportAddress boundHttpTransportAddress) {
        this.boundHttpTransportAddress.set((Object)boundHttpTransportAddress);
        this.updateRules();
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ALLOW_BOUND_ADDRESSES_SETTING);
        settings.add(IP_FILTER_ENABLED_SETTING);
        settings.add(IP_FILTER_ENABLED_HTTP_SETTING);
        settings.add(HTTP_FILTER_ALLOW_SETTING);
        settings.add(HTTP_FILTER_DENY_SETTING);
        settings.add(TRANSPORT_FILTER_ALLOW_SETTING);
        settings.add(TRANSPORT_FILTER_DENY_SETTING);
    }
}

