/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;

public class CompositeRolesStore
extends AbstractComponent {
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    public static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)Security.setting("authz.store.roles.cache.max_size"), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final FileRolesStore fileRolesStore;
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;
    private final XPackLicenseState licenseState;
    private final Cache<Set<String>, Role> roleCache;
    private final Set<String> negativeLookupCache;
    private final AtomicLong numInvalidation;

    public CompositeRolesStore(Settings settings, FileRolesStore fileRolesStore, NativeRolesStore nativeRolesStore, ReservedRolesStore reservedRolesStore, XPackLicenseState licenseState) {
        super(settings);
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.numInvalidation = new AtomicLong();
        this.fileRolesStore = fileRolesStore;
        fileRolesStore.addListener(this::invalidateAll);
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
        this.licenseState = licenseState;
        CacheBuilder builder = CacheBuilder.builder();
        int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
        if (cacheSize >= 0) {
            builder.setMaximumWeight((long)cacheSize);
        }
        this.roleCache = builder.build();
        this.negativeLookupCache = ConcurrentCollections.newConcurrentSet();
    }

    public void roles(Set<String> roleNames, FieldPermissionsCache fieldPermissionsCache, ActionListener<Role> roleActionListener) {
        Role existing = (Role)this.roleCache.get(roleNames);
        if (existing != null) {
            roleActionListener.onResponse((Object)existing);
        } else {
            long invalidationCounter = this.numInvalidation.get();
            this.roleDescriptors(roleNames, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(descriptors -> {
                Role role;
                if (this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
                    role = CompositeRolesStore.buildRoleFromDescriptors(descriptors, fieldPermissionsCache);
                } else {
                    Set<RoleDescriptor> filtered = descriptors.stream().filter(rd -> !rd.isUsingDocumentOrFieldLevelSecurity()).collect(Collectors.toSet());
                    role = CompositeRolesStore.buildRoleFromDescriptors(filtered, fieldPermissionsCache);
                }
                if (role != null) {
                    try (ReleasableLock ignored = this.readLock.acquire();){
                        if (invalidationCounter == this.numInvalidation.get()) {
                            this.roleCache.computeIfAbsent((Object)roleNames, s -> role);
                        }
                    }
                }
                roleActionListener.onResponse((Object)role);
            }, arg_0 -> roleActionListener.onFailure(arg_0)));
        }
    }

    private void roleDescriptors(Set<String> roleNames, ActionListener<Set<RoleDescriptor>> roleDescriptorActionListener) {
        Set<RoleDescriptor> builtInRoleDescriptors;
        Set<String> filteredRoleNames = roleNames.stream().filter(s -> !this.negativeLookupCache.contains(s)).collect(Collectors.toSet());
        Set<String> remainingRoleNames = this.difference(filteredRoleNames, builtInRoleDescriptors = this.getBuiltInRoleDescriptors(filteredRoleNames));
        if (remainingRoleNames.isEmpty()) {
            roleDescriptorActionListener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
        } else {
            this.nativeRolesStore.getRoleDescriptors(remainingRoleNames.toArray(Strings.EMPTY_ARRAY), (ActionListener<Collection<RoleDescriptor>>)ActionListener.wrap(descriptors -> {
                builtInRoleDescriptors.addAll((Collection<RoleDescriptor>)descriptors);
                if (builtInRoleDescriptors.size() != filteredRoleNames.size()) {
                    Set<String> missing = this.difference(filteredRoleNames, builtInRoleDescriptors);
                    assert (!missing.isEmpty()) : "the missing set should not be empty if the sizes didn't match";
                    this.negativeLookupCache.addAll(missing);
                }
                roleDescriptorActionListener.onResponse(Collections.unmodifiableSet(builtInRoleDescriptors));
            }, arg_0 -> roleDescriptorActionListener.onFailure(arg_0)));
        }
    }

    private Set<RoleDescriptor> getBuiltInRoleDescriptors(Set<String> roleNames) {
        Set descriptors = this.reservedRolesStore.roleDescriptors().stream().filter(rd -> roleNames.contains(rd.getName())).collect(Collectors.toCollection(HashSet::new));
        Set<String> difference = this.difference(roleNames, descriptors);
        if (!difference.isEmpty()) {
            descriptors.addAll(this.fileRolesStore.roleDescriptors(difference));
        }
        return descriptors;
    }

    private Set<String> difference(Set<String> roleNames, Set<RoleDescriptor> descriptors) {
        Set foundNames = descriptors.stream().map(RoleDescriptor::getName).collect(Collectors.toSet());
        return Sets.difference(roleNames, foundNames);
    }

    public static Role buildRoleFromDescriptors(Set<RoleDescriptor> roleDescriptors, FieldPermissionsCache fieldPermissionsCache) {
        if (roleDescriptors.isEmpty()) {
            return Role.EMPTY;
        }
        StringBuilder nameBuilder = new StringBuilder();
        HashSet<String> clusterPrivileges = new HashSet<String>();
        HashSet<String> runAs = new HashSet<String>();
        HashMap<Set, MergeableIndicesPrivilege> indicesPrivilegesMap = new HashMap<Set, MergeableIndicesPrivilege>();
        for (RoleDescriptor descriptor : roleDescriptors) {
            RoleDescriptor.IndicesPrivileges[] indicesPrivileges;
            nameBuilder.append(descriptor.getName());
            nameBuilder.append('_');
            if (descriptor.getClusterPrivileges() != null) {
                clusterPrivileges.addAll(Arrays.asList(descriptor.getClusterPrivileges()));
            }
            if (descriptor.getRunAs() != null) {
                runAs.addAll(Arrays.asList(descriptor.getRunAs()));
            }
            for (RoleDescriptor.IndicesPrivileges indicesPrivilege : indicesPrivileges = descriptor.getIndicesPrivileges()) {
                boolean isExplicitDenial;
                HashSet key = Sets.newHashSet((Object[])indicesPrivilege.getIndices());
                boolean bl = isExplicitDenial = indicesPrivileges.length == 1 && "none".equalsIgnoreCase(indicesPrivilege.getPrivileges()[0]);
                if (isExplicitDenial) continue;
                indicesPrivilegesMap.compute(key, (k, value) -> {
                    if (value == null) {
                        return new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery());
                    }
                    value.merge(new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery()));
                    return value;
                });
            }
        }
        HashSet<String> clusterPrivs = clusterPrivileges.isEmpty() ? null : clusterPrivileges;
        Privilege runAsPrivilege = runAs.isEmpty() ? Privilege.NONE : new Privilege(runAs, runAs.toArray(Strings.EMPTY_ARRAY));
        Role.Builder builder = Role.builder(nameBuilder.toString(), fieldPermissionsCache).cluster(ClusterPrivilege.get(clusterPrivs)).runAs(runAsPrivilege);
        indicesPrivilegesMap.entrySet().forEach(entry -> {
            MergeableIndicesPrivilege privilege = (MergeableIndicesPrivilege)entry.getValue();
            builder.add(fieldPermissionsCache.getFieldPermissions(privilege.grantedFields, privilege.deniedFields), privilege.query, IndexPrivilege.get(privilege.privileges), privilege.indices.toArray(Strings.EMPTY_ARRAY));
        });
        return builder.build();
    }

    public void invalidateAll() {
        this.numInvalidation.incrementAndGet();
        this.negativeLookupCache.clear();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.roleCache.invalidateAll();
        }
    }

    public void invalidate(String role) {
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator keyIter = this.roleCache.keys().iterator();
            while (keyIter.hasNext()) {
                Set key = (Set)keyIter.next();
                if (!key.contains(role)) continue;
                keyIter.remove();
            }
        }
        this.negativeLookupCache.remove(role);
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> usage = new HashMap<String, Object>(2);
        usage.put("file", this.fileRolesStore.usageStats());
        usage.put("native", this.nativeRolesStore.usageStats());
        return usage;
    }

    private static class MergeableIndicesPrivilege {
        private Set<String> indices;
        private Set<String> privileges;
        private Set<String> grantedFields = null;
        private Set<String> deniedFields = null;
        private Set<BytesReference> query = null;

        MergeableIndicesPrivilege(String[] indices, String[] privileges, @Nullable String[] grantedFields, @Nullable String[] deniedFields, @Nullable BytesReference query) {
            this.indices = Sets.newHashSet((Object[])Objects.requireNonNull(indices));
            this.privileges = Sets.newHashSet((Object[])Objects.requireNonNull(privileges));
            this.grantedFields = grantedFields == null ? null : Sets.newHashSet((Object[])grantedFields);
            HashSet hashSet = this.deniedFields = deniedFields == null ? null : Sets.newHashSet((Object[])deniedFields);
            if (query != null) {
                this.query = Sets.newHashSet((Object[])new BytesReference[]{query});
            }
        }

        void merge(MergeableIndicesPrivilege other) {
            assert (this.indices.equals(other.indices)) : "index names must be equivalent in order to merge";
            this.grantedFields = MergeableIndicesPrivilege.combineFieldSets(this.grantedFields, other.grantedFields);
            this.deniedFields = MergeableIndicesPrivilege.combineFieldSets(this.deniedFields, other.deniedFields);
            this.privileges.addAll(other.privileges);
            if (this.query == null || other.query == null) {
                this.query = null;
            } else {
                this.query.addAll(other.query);
            }
        }

        private static Set<String> combineFieldSets(Set<String> set, Set<String> other) {
            if (set == null || other == null) {
                return null;
            }
            set.addAll(other);
            return set;
        }
    }
}

