/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissions;

public final class FieldPermissionsCache {
    public static final Setting<Long> CACHE_SIZE_SETTING = Setting.longSetting((String)Security.setting("authz.store.roles.field_permissions.cache.max_size_in_bytes"), (long)0x6400000L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Cache<Key, FieldPermissions> cache;

    public FieldPermissionsCache(Settings settings) {
        this.cache = CacheBuilder.builder().setMaximumWeight(((Long)CACHE_SIZE_SETTING.get(settings)).longValue()).weigher((key, fieldPermissions) -> fieldPermissions.getPermittedFieldsAutomaton().ramBytesUsed()).build();
    }

    FieldPermissions getFieldPermissions(String[] granted, String[] denied) {
        HashSet<String> deniedSet;
        HashSet<String> grantedSet;
        if (granted != null) {
            grantedSet = new HashSet<String>(granted.length);
            Collections.addAll(grantedSet, granted);
        } else {
            grantedSet = null;
        }
        if (denied != null) {
            deniedSet = new HashSet<String>(denied.length);
            Collections.addAll(deniedSet, denied);
        } else {
            deniedSet = null;
        }
        return this.getFieldPermissions(grantedSet, deniedSet);
    }

    public FieldPermissions getFieldPermissions(Set<String> granted, Set<String> denied) {
        Key fpKey = new Key(granted == null ? null : Collections.unmodifiableSet(granted), denied == null ? null : Collections.unmodifiableSet(denied));
        try {
            return (FieldPermissions)this.cache.computeIfAbsent((Object)fpKey, key -> new FieldPermissions(((Key)key).grantedFields == null ? null : ((Key)key).grantedFields.toArray(Strings.EMPTY_ARRAY), ((Key)key).deniedFields == null ? null : ((Key)key).deniedFields.toArray(Strings.EMPTY_ARRAY)));
        }
        catch (ExecutionException e) {
            throw new ElasticsearchException("unable to compute field permissions", (Throwable)e, new Object[0]);
        }
    }

    FieldPermissions getFieldPermissions(Collection<FieldPermissions> fieldPermissionsCollection) {
        Optional<FieldPermissions> allowAllFieldPermissions = fieldPermissionsCollection.stream().filter(fp -> Operations.isTotal((Automaton)fp.getPermittedFieldsAutomaton())).findFirst();
        return allowAllFieldPermissions.orElseGet(() -> {
            Optional<FieldPermissions> nullAllowedFields = fieldPermissionsCollection.stream().filter(fieldPermissions -> fieldPermissions.getGrantedFieldsArray() == null).findFirst();
            Set<String> allowedFields = nullAllowedFields.isPresent() ? null : fieldPermissionsCollection.stream().flatMap(fieldPermissions -> Arrays.stream(fieldPermissions.getGrantedFieldsArray())).collect(Collectors.toSet());
            Set<String> deniedFields = fieldPermissionsCollection.stream().filter(fieldPermissions -> fieldPermissions.getDeniedFieldsArray() != null).flatMap(fieldPermissions -> Arrays.stream(fieldPermissions.getDeniedFieldsArray())).collect(Collectors.toSet());
            try {
                return (FieldPermissions)this.cache.computeIfAbsent((Object)new Key(allowedFields, deniedFields), key -> {
                    String[] actualDeniedFields = ((Key)key).deniedFields == null ? null : FieldPermissionsCache.computeDeniedFieldsForPermissions(fieldPermissionsCollection, ((Key)key).deniedFields);
                    return new FieldPermissions(((Key)key).grantedFields == null ? null : ((Key)key).grantedFields.toArray(Strings.EMPTY_ARRAY), actualDeniedFields);
                });
            }
            catch (ExecutionException e) {
                throw new ElasticsearchException("unable to compute field permissions", (Throwable)e, new Object[0]);
            }
        });
    }

    private static String[] computeDeniedFieldsForPermissions(Collection<FieldPermissions> fieldPermissionsCollection, Set<String> allDeniedFields) {
        HashSet allowedDeniedFields = new HashSet();
        fieldPermissionsCollection.stream().filter(fieldPermissions -> fieldPermissions.getDeniedFieldsArray() != null).forEach(fieldPermissions -> {
            String[] deniedFieldsForPermission = fieldPermissions.getDeniedFieldsArray();
            fieldPermissionsCollection.forEach(fp -> {
                if (fp != fieldPermissions) {
                    Arrays.stream(deniedFieldsForPermission).forEach(field -> {
                        if (fp.grantsAccessTo((String)field)) {
                            allowedDeniedFields.add(field);
                        }
                    });
                }
            });
        });
        Set difference = Sets.difference(allDeniedFields, allowedDeniedFields);
        if (difference.isEmpty()) {
            return null;
        }
        return difference.toArray(Strings.EMPTY_ARRAY);
    }

    private static class Key {
        private final Set<String> grantedFields;
        private final Set<String> deniedFields;

        Key(Set<String> grantedFields, Set<String> deniedFields) {
            this.grantedFields = grantedFields == null ? null : Collections.unmodifiableSet(grantedFields);
            this.deniedFields = deniedFields == null ? null : Collections.unmodifiableSet(deniedFields);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.grantedFields != null ? !this.grantedFields.equals(key.grantedFields) : key.grantedFields != null) {
                return false;
            }
            return this.deniedFields != null ? this.deniedFields.equals(key.deniedFields) : key.deniedFields == null;
        }

        public int hashCode() {
            int result = this.grantedFields != null ? this.grantedFields.hashCode() : 0;
            result = 31 * result + (this.deniedFields != null ? this.deniedFields.hashCode() : 0);
            return result;
        }
    }
}

