/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.Objects;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.TransportRequest;

public final class RequestContext {
    private static final ThreadLocal<RequestContext> current = new ThreadLocal();
    private final ThreadContext threadContext;
    private final TransportRequest request;

    public static RequestContext current() {
        return current.get();
    }

    public static void setCurrent(RequestContext value) {
        current.set(value);
    }

    public static void removeCurrent() {
        current.remove();
    }

    public RequestContext(TransportRequest request, ThreadContext threadContext) {
        this.request = Objects.requireNonNull(request);
        this.threadContext = Objects.requireNonNull(threadContext);
    }

    public TransportRequest getRequest() {
        return this.request;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }
}

