/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.security.support.MetadataUtils;
import org.elasticsearch.xpack.security.support.Validation;

public class RoleDescriptor
implements ToXContent {
    private final String name;
    private final String[] clusterPrivileges;
    private final IndicesPrivileges[] indicesPrivileges;
    private final String[] runAs;
    private final Map<String, Object> metadata;
    private final Map<String, Object> transientMetadata;

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs) {
        this(name, clusterPrivileges, indicesPrivileges, runAs, null);
    }

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata) {
        this(name, clusterPrivileges, indicesPrivileges, runAs, metadata, null);
    }

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata, @Nullable Map<String, Object> transientMetadata) {
        this.name = name;
        this.clusterPrivileges = clusterPrivileges != null ? clusterPrivileges : Strings.EMPTY_ARRAY;
        this.indicesPrivileges = indicesPrivileges != null ? indicesPrivileges : IndicesPrivileges.NONE;
        this.runAs = runAs != null ? runAs : Strings.EMPTY_ARRAY;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.transientMetadata = transientMetadata != null ? Collections.unmodifiableMap(transientMetadata) : Collections.singletonMap("enabled", true);
    }

    public String getName() {
        return this.name;
    }

    public String[] getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public IndicesPrivileges[] getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public String[] getRunAs() {
        return this.runAs;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getTransientMetadata() {
        return this.transientMetadata;
    }

    public boolean isUsingDocumentOrFieldLevelSecurity() {
        return Arrays.stream(this.indicesPrivileges).anyMatch(ip -> ip.isUsingDocumentLevelSecurity() || ip.isUsingFieldLevelSecurity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Role[");
        sb.append("name=").append(this.name);
        sb.append(", cluster=[").append(Strings.arrayToCommaDelimitedString((Object[])this.clusterPrivileges));
        sb.append("], indicesPrivileges=[");
        for (IndicesPrivileges group : this.indicesPrivileges) {
            sb.append(group.toString()).append(",");
        }
        sb.append("], runAs=[").append(Strings.arrayToCommaDelimitedString((Object[])this.runAs));
        sb.append("], metadata=[");
        MetadataUtils.writeValue(sb, this.metadata);
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleDescriptor that = (RoleDescriptor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.clusterPrivileges, that.clusterPrivileges)) {
            return false;
        }
        if (!Arrays.equals(this.indicesPrivileges, that.indicesPrivileges)) {
            return false;
        }
        if (!this.metadata.equals(that.getMetadata())) {
            return false;
        }
        return Arrays.equals(this.runAs, that.runAs);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.clusterPrivileges);
        result = 31 * result + Arrays.hashCode(this.indicesPrivileges);
        result = 31 * result + Arrays.hashCode(this.runAs);
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeTransient) throws IOException {
        builder.startObject();
        builder.array(Fields.CLUSTER.getPreferredName(), this.clusterPrivileges);
        builder.array(Fields.INDICES.getPreferredName(), (Object[])this.indicesPrivileges);
        if (this.runAs != null) {
            builder.array(Fields.RUN_AS.getPreferredName(), this.runAs);
        }
        builder.field(Fields.METADATA.getPreferredName(), this.metadata);
        if (includeTransient) {
            builder.field(Fields.TRANSIENT_METADATA.getPreferredName(), this.transientMetadata);
        }
        return builder.endObject();
    }

    public static RoleDescriptor readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        String[] clusterPrivileges = in.readStringArray();
        int size = in.readVInt();
        IndicesPrivileges[] indicesPrivileges = new IndicesPrivileges[size];
        for (int i = 0; i < size; ++i) {
            indicesPrivileges[i] = IndicesPrivileges.createFrom(in);
        }
        String[] runAs = in.readStringArray();
        Map metadata = in.readMap();
        Map transientMetadata = in.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED) ? in.readMap() : Collections.emptyMap();
        return new RoleDescriptor(name, clusterPrivileges, indicesPrivileges, runAs, metadata, transientMetadata);
    }

    public static void writeTo(RoleDescriptor descriptor, StreamOutput out) throws IOException {
        out.writeString(descriptor.name);
        out.writeStringArray(descriptor.clusterPrivileges);
        out.writeVInt(descriptor.indicesPrivileges.length);
        for (IndicesPrivileges group : descriptor.indicesPrivileges) {
            group.writeTo(out);
        }
        out.writeStringArray(descriptor.runAs);
        out.writeMap(descriptor.metadata);
        if (out.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED)) {
            out.writeMap(descriptor.transientMetadata);
        }
    }

    public static RoleDescriptor parse(String name, BytesReference source, boolean allow2xFormat) throws IOException {
        assert (name != null);
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)source);){
            RoleDescriptor roleDescriptor = RoleDescriptor.parse(name, parser, allow2xFormat);
            return roleDescriptor;
        }
    }

    public static RoleDescriptor parse(String name, XContentParser parser, boolean allow2xFormat) throws IOException {
        XContentParser.Token token;
        Validation.Error validationError = Validation.Roles.validateRoleName(name, true);
        if (validationError != null) {
            ValidationException ve = new ValidationException();
            ve.addValidationError(validationError.toString());
            throw ve;
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse role [{}]. expected an object but found [{}] instead", new Object[]{name, token});
        }
        String currentFieldName = null;
        IndicesPrivileges[] indicesPrivileges = null;
        String[] clusterPrivileges = null;
        String[] runAsUsers = null;
        Map metadata = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.INDICES.match(currentFieldName)) {
                indicesPrivileges = RoleDescriptor.parseIndices(name, parser, allow2xFormat);
                continue;
            }
            if (Fields.RUN_AS.match(currentFieldName)) {
                runAsUsers = RoleDescriptor.readStringArray(name, parser, true);
                continue;
            }
            if (Fields.CLUSTER.match(currentFieldName)) {
                clusterPrivileges = RoleDescriptor.readStringArray(name, parser, true);
                continue;
            }
            if (Fields.METADATA.match(currentFieldName)) {
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("expected field [{}] to be of type object, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                metadata = parser.map();
                continue;
            }
            if (Fields.TRANSIENT_METADATA.match(currentFieldName)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    parser.map();
                    continue;
                }
                throw new ElasticsearchParseException("expected field [{}] to be an object, but found [{}] instead", new Object[]{currentFieldName, token});
            }
            throw new ElasticsearchParseException("failed to parse role [{}]. unexpected field [{}]", new Object[]{name, currentFieldName});
        }
        return new RoleDescriptor(name, clusterPrivileges, indicesPrivileges, runAsUsers, metadata);
    }

    private static String[] readStringArray(String roleName, XContentParser parser, boolean allowNull) throws IOException {
        try {
            return XContentUtils.readStringArray(parser, allowNull);
        }
        catch (ElasticsearchParseException e) {
            throw new ElasticsearchParseException("failed to parse role [{}]", (Throwable)e, new Object[]{roleName});
        }
    }

    private static IndicesPrivileges[] parseIndices(String roleName, XContentParser parser, boolean allow2xFormat) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        ArrayList<IndicesPrivileges> privileges = new ArrayList<IndicesPrivileges>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            privileges.add(RoleDescriptor.parseIndex(roleName, parser, allow2xFormat));
        }
        return privileges.toArray(new IndicesPrivileges[privileges.size()]);
    }

    private static IndicesPrivileges parseIndex(String roleName, XContentParser parser, boolean allow2xFormat) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array of objects, but found an array element of type [{}]", new Object[]{roleName, parser.currentName(), token});
        }
        String currentFieldName = null;
        String[] names = null;
        BytesReference query = null;
        String[] privileges = null;
        String[] grantedFields = null;
        String[] deniedFields = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.NAMES.match(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    names = new String[]{parser.text()};
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    names = RoleDescriptor.readStringArray(roleName, parser, false);
                    if (names.length != 0) continue;
                    throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. [{}] cannot be an empty array", new Object[]{roleName, currentFieldName});
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be a string or an array of strings, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (Fields.QUERY.match(currentFieldName)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = JsonXContent.contentBuilder();
                    XContentHelper.copyCurrentStructure((XContentGenerator)builder.generator(), (XContentParser)parser);
                    query = builder.bytes();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String text = parser.text();
                    if (text.isEmpty()) continue;
                    query = new BytesArray(text);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NULL) continue;
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be null, a string, an array, or an object, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (Fields.FIELD_PERMISSIONS.match(currentFieldName)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    do {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            if (Fields.GRANT_FIELDS.match(currentFieldName)) {
                                parser.nextToken();
                                grantedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                                if (grantedFields != null) continue;
                                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} must not be null.", new Object[]{roleName, Fields.GRANT_FIELDS});
                            }
                            if (Fields.EXCEPT_FIELDS.match(currentFieldName)) {
                                parser.nextToken();
                                deniedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                                if (deniedFields != null) continue;
                                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} must not be null.", new Object[]{roleName, Fields.EXCEPT_FIELDS});
                            }
                            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. \"{}\" only accepts options {} and {}, but got: {}", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS, parser.currentName()});
                        }
                        if (token == XContentParser.Token.END_OBJECT) {
                            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. \"{}\" must not be empty.", new Object[]{roleName, Fields.FIELD_PERMISSIONS});
                        }
                        throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected {} but got {}.", new Object[]{roleName, XContentParser.Token.FIELD_NAME, token});
                    } while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT);
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected {} or {} but got {} in \"{}\".", new Object[]{roleName, XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, token, Fields.FIELD_PERMISSIONS});
            }
            if (Fields.PRIVILEGES.match(currentFieldName)) {
                privileges = RoleDescriptor.readStringArray(roleName, parser, true);
                continue;
            }
            if (Fields.FIELD_PERMISSIONS_2X.match(currentFieldName)) {
                if (allow2xFormat) {
                    grantedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                    continue;
                }
                throw new ElasticsearchParseException("[\"fields\": [...]] format has changed for field permissions in role [{}], use [\"{}\": {\"{}\":[...],\"{}\":[...]}] instead", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS, roleName});
            }
            if (Fields.TRANSIENT_METADATA.match(currentFieldName)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    }
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse transient metadata for role [{}]. expected {} but got {} in \"{}\".", new Object[]{roleName, XContentParser.Token.START_OBJECT, token, Fields.TRANSIENT_METADATA});
            }
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. unexpected field [{}]", new Object[]{roleName, currentFieldName});
        }
        if (names == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.NAMES.getPreferredName()});
        }
        if (privileges == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.PRIVILEGES.getPreferredName()});
        }
        if (deniedFields != null && grantedFields == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} requires {} if {} is given", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS});
        }
        return IndicesPrivileges.builder().indices(names).privileges(privileges).grantedFields(grantedFields).deniedFields(deniedFields).query(query).build();
    }

    public static interface Fields {
        public static final ParseField CLUSTER = new ParseField("cluster", new String[0]);
        public static final ParseField INDICES = new ParseField("indices", new String[0]);
        public static final ParseField RUN_AS = new ParseField("run_as", new String[0]);
        public static final ParseField NAMES = new ParseField("names", new String[0]);
        public static final ParseField QUERY = new ParseField("query", new String[0]);
        public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
        public static final ParseField FIELD_PERMISSIONS = new ParseField("field_security", new String[0]);
        public static final ParseField FIELD_PERMISSIONS_2X = new ParseField("fields", new String[0]);
        public static final ParseField GRANT_FIELDS = new ParseField("grant", new String[0]);
        public static final ParseField EXCEPT_FIELDS = new ParseField("except", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField TRANSIENT_METADATA = new ParseField("transient_metadata", new String[0]);
    }

    public static class IndicesPrivileges
    implements ToXContent,
    Streamable {
        private static final IndicesPrivileges[] NONE = new IndicesPrivileges[0];
        private String[] indices;
        private String[] privileges;
        private String[] grantedFields = null;
        private String[] deniedFields = null;
        private BytesReference query;

        private IndicesPrivileges() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public String[] getIndices() {
            return this.indices;
        }

        public String[] getPrivileges() {
            return this.privileges;
        }

        @Nullable
        public String[] getGrantedFields() {
            return this.grantedFields;
        }

        @Nullable
        public String[] getDeniedFields() {
            return this.deniedFields;
        }

        @Nullable
        public BytesReference getQuery() {
            return this.query;
        }

        public boolean isUsingDocumentLevelSecurity() {
            return this.query != null;
        }

        public boolean isUsingFieldLevelSecurity() {
            return this.hasDeniedFields() || this.hasGrantedFields();
        }

        private boolean hasDeniedFields() {
            return this.deniedFields != null && this.deniedFields.length > 0;
        }

        private boolean hasGrantedFields() {
            if (this.grantedFields != null && this.grantedFields.length >= 0) {
                return this.grantedFields.length != 1 || !"*".equals(this.grantedFields[0]);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IndicesPrivileges[");
            sb.append("indices=[").append(Strings.arrayToCommaDelimitedString((Object[])this.indices));
            sb.append("], privileges=[").append(Strings.arrayToCommaDelimitedString((Object[])this.privileges));
            sb.append("], ");
            if (this.grantedFields != null || this.deniedFields != null) {
                sb.append(Fields.FIELD_PERMISSIONS).append("=[");
                if (this.grantedFields == null) {
                    sb.append(Fields.GRANT_FIELDS).append("=null");
                } else {
                    sb.append(Fields.GRANT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.grantedFields));
                    sb.append("]");
                }
                if (this.deniedFields == null) {
                    sb.append(", ").append(Fields.EXCEPT_FIELDS).append("=null");
                } else {
                    sb.append(", ").append(Fields.EXCEPT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.deniedFields));
                    sb.append("]");
                }
                sb.append("]");
            }
            if (this.query != null) {
                sb.append(", query=");
                sb.append(this.query.utf8ToString());
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndicesPrivileges that = (IndicesPrivileges)o;
            if (!Arrays.equals(this.indices, that.indices)) {
                return false;
            }
            if (!Arrays.equals(this.privileges, that.privileges)) {
                return false;
            }
            if (!Arrays.equals(this.grantedFields, that.grantedFields)) {
                return false;
            }
            if (!Arrays.equals(this.deniedFields, that.deniedFields)) {
                return false;
            }
            return !(this.query == null ? that.query != null : !this.query.equals((Object)that.query));
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.indices);
            result = 31 * result + Arrays.hashCode(this.privileges);
            result = 31 * result + Arrays.hashCode(this.grantedFields);
            result = 31 * result + Arrays.hashCode(this.deniedFields);
            result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.array("names", this.indices);
            builder.array("privileges", this.privileges);
            if (this.grantedFields != null || this.deniedFields != null) {
                builder.startObject(Fields.FIELD_PERMISSIONS.getPreferredName());
                if (this.grantedFields != null) {
                    builder.array(Fields.GRANT_FIELDS.getPreferredName(), this.grantedFields);
                }
                if (this.deniedFields != null) {
                    builder.array(Fields.EXCEPT_FIELDS.getPreferredName(), this.deniedFields);
                }
                builder.endObject();
            }
            if (this.query != null) {
                builder.field("query", this.query.utf8ToString());
            }
            return builder.endObject();
        }

        public static IndicesPrivileges createFrom(StreamInput in) throws IOException {
            IndicesPrivileges ip = new IndicesPrivileges();
            ip.readFrom(in);
            return ip;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.grantedFields = in.readOptionalStringArray();
            this.deniedFields = in.readOptionalStringArray();
            this.privileges = in.readStringArray();
            this.query = in.readOptionalBytesReference();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indices);
            out.writeOptionalStringArray(this.grantedFields);
            out.writeOptionalStringArray(this.deniedFields);
            out.writeStringArray(this.privileges);
            out.writeOptionalBytesReference(this.query);
        }

        static /* synthetic */ String[] access$302(IndicesPrivileges x0, String[] x1) {
            x0.indices = x1;
            return x1;
        }

        static /* synthetic */ String[] access$402(IndicesPrivileges x0, String[] x1) {
            x0.privileges = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(IndicesPrivileges x0, String[] x1) {
            x0.grantedFields = x1;
            return x1;
        }

        static /* synthetic */ String[] access$602(IndicesPrivileges x0, String[] x1) {
            x0.deniedFields = x1;
            return x1;
        }

        public static class Builder {
            private IndicesPrivileges indicesPrivileges = new IndicesPrivileges();

            private Builder() {
            }

            public Builder indices(String ... indices) {
                IndicesPrivileges.access$302(this.indicesPrivileges, indices);
                return this;
            }

            public Builder privileges(String ... privileges) {
                IndicesPrivileges.access$402(this.indicesPrivileges, privileges);
                return this;
            }

            public Builder grantedFields(String ... grantedFields) {
                IndicesPrivileges.access$502(this.indicesPrivileges, grantedFields);
                return this;
            }

            public Builder deniedFields(String ... deniedFields) {
                IndicesPrivileges.access$602(this.indicesPrivileges, deniedFields);
                return this;
            }

            public Builder query(@Nullable String query) {
                return this.query((BytesReference)(query == null ? null : new BytesArray(query)));
            }

            public Builder query(@Nullable BytesReference query) {
                if (query == null) {
                    this.indicesPrivileges.query = null;
                } else {
                    this.indicesPrivileges.query = query;
                }
                return this;
            }

            public IndicesPrivileges build() {
                if (this.indicesPrivileges.indices == null || this.indicesPrivileges.indices.length == 0) {
                    throw new IllegalArgumentException("indices privileges must refer to at least one index name or index name pattern");
                }
                if (this.indicesPrivileges.privileges == null || this.indicesPrivileges.privileges.length == 0) {
                    throw new IllegalArgumentException("indices privileges must define at least one privilege");
                }
                return this.indicesPrivileges;
            }
        }
    }
}

