/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.security.user.User;

public class GetUsersResponse
extends ActionResponse {
    private User[] users;

    public GetUsersResponse(User ... users) {
        this.users = users;
    }

    public GetUsersResponse(Collection<User> users) {
        this(users.toArray(new User[users.size()]));
    }

    public User[] users() {
        return this.users;
    }

    public boolean hasUsers() {
        return this.users != null && this.users.length > 0;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        if (size < 0) {
            this.users = null;
        } else {
            this.users = new User[size];
            for (int i = 0; i < size; ++i) {
                this.users[i] = User.readFrom(in);
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.users == null ? -1 : this.users.length);
        if (this.users != null) {
            for (User user : this.users) {
                User.writeTo(user, out);
            }
        }
    }
}

